/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.theme;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.oscim.theme.IRenderTheme;
import org.oscim.theme.ThemeFile;
import org.oscim.theme.ThemeUtils;
import org.oscim.theme.XmlRenderThemeMenuCallback;
import org.oscim.utils.Utils;

public class StreamRenderTheme
implements ThemeFile {
    private static final long serialVersionUID = 1L;
    private final InputStream mInputStream;
    private XmlRenderThemeMenuCallback mMenuCallback;
    private final String mRelativePathPrefix;

    public StreamRenderTheme(String relativePathPrefix, InputStream inputStream) {
        this(relativePathPrefix, inputStream, null);
    }

    public StreamRenderTheme(String relativePathPrefix, InputStream inputStream, XmlRenderThemeMenuCallback menuCallback) {
        this.mRelativePathPrefix = relativePathPrefix;
        this.mInputStream = new BufferedInputStream(inputStream);
        this.mInputStream.mark(0);
        this.mMenuCallback = menuCallback;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof StreamRenderTheme)) {
            return false;
        }
        StreamRenderTheme other = (StreamRenderTheme)obj;
        if (this.mInputStream != other.mInputStream) {
            return false;
        }
        return Utils.equals(this.mRelativePathPrefix, other.mRelativePathPrefix);
    }

    @Override
    public XmlRenderThemeMenuCallback getMenuCallback() {
        return this.mMenuCallback;
    }

    @Override
    public String getRelativePathPrefix() {
        return this.mRelativePathPrefix;
    }

    @Override
    public InputStream getRenderThemeAsStream() throws IRenderTheme.ThemeException {
        try {
            this.mInputStream.reset();
        }
        catch (IOException e) {
            throw new IRenderTheme.ThemeException(e.getMessage());
        }
        return this.mInputStream;
    }

    @Override
    public boolean isMapsforgeTheme() {
        return ThemeUtils.isMapsforgeTheme(this);
    }

    @Override
    public void setMenuCallback(XmlRenderThemeMenuCallback menuCallback) {
        this.mMenuCallback = menuCallback;
    }
}

