/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.tiling.source;

import java.io.IOException;
import java.io.InputStream;
import org.oscim.core.GeometryBuffer;
import org.oscim.tiling.source.ITileDecoder;
import org.oscim.utils.UTF8Decoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PbfDecoder
implements ITileDecoder {
    static final Logger log = LoggerFactory.getLogger(PbfDecoder.class);
    private static final int S1 = 7;
    private static final int S2 = 14;
    private static final int S3 = 21;
    private static final int S4 = 28;
    private static final int M1 = 127;
    private static final int M2 = 16383;
    private static final int M3 = 0x1FFFFF;
    private static final int M4 = 0xFFFFFFF;
    protected static final boolean debug = false;
    static final ProtobufException TRUNCATED_MSG = new ProtobufException("truncated msg");
    protected static final ProtobufException INVALID_VARINT = new ProtobufException("invalid varint");
    protected static final ProtobufException INVALID_PACKED_SIZE = new ProtobufException("invalid message size");
    private static final int BUFFER_SIZE = 32768;
    protected byte[] buffer = new byte[32768];
    protected int bufferPos;
    protected int bufferFill;
    private int mBufferOffset;
    private int mMsgPos;
    private InputStream mInputStream;
    private final UTF8Decoder mStringDecoder = new UTF8Decoder();

    protected void error(String msg) throws IOException {
        throw new ProtobufException(msg);
    }

    public void setInputStream(InputStream is) {
        this.mInputStream = is;
        this.bufferFill = 0;
        this.bufferPos = 0;
        this.mBufferOffset = 0;
        this.mMsgPos = 0;
    }

    protected int decodeVarint32() throws IOException {
        int bytesLeft = 0;
        int val = 0;
        for (int shift = 0; shift < 32; shift += 7) {
            if (bytesLeft == 0) {
                bytesLeft = this.fillBuffer(1);
            }
            byte b = this.buffer[this.bufferPos++];
            val |= (b & 0x7F) << shift;
            if (b >= 0) {
                return val;
            }
            --bytesLeft;
        }
        throw INVALID_VARINT;
    }

    protected long decodeVarint64() throws IOException {
        int bytesLeft = 0;
        long val = 0L;
        for (int shift = 0; shift < 64; shift += 7) {
            if (bytesLeft == 0) {
                bytesLeft = this.fillBuffer(1);
            }
            byte b = this.buffer[this.bufferPos++];
            val |= (long)(b & 0x7F) << shift;
            if (b >= 0) {
                return val;
            }
            --bytesLeft;
        }
        throw INVALID_VARINT;
    }

    protected String decodeString() throws IOException {
        int size = this.decodeVarint32();
        this.fillBuffer(size);
        String result = this.mStringDecoder == null ? new String(this.buffer, this.bufferPos, size, "UTF-8") : this.mStringDecoder.decode(this.buffer, this.bufferPos, size);
        this.bufferPos += size;
        return result;
    }

    protected float decodeFloat() throws IOException {
        if (this.bufferPos + 4 > this.bufferFill) {
            this.fillBuffer(4);
        }
        int val = this.buffer[this.bufferPos++] & 0xFF | (this.buffer[this.bufferPos++] & 0xFF) << 8 | (this.buffer[this.bufferPos++] & 0xFF) << 16 | (this.buffer[this.bufferPos++] & 0xFF) << 24;
        return Float.intBitsToFloat(val);
    }

    protected double decodeDouble() throws IOException {
        if (this.bufferPos + 8 > this.bufferFill) {
            this.fillBuffer(8);
        }
        long val = (long)this.buffer[this.bufferPos++] & 0xFFL | ((long)this.buffer[this.bufferPos++] & 0xFFL) << 8 | ((long)this.buffer[this.bufferPos++] & 0xFFL) << 16 | ((long)this.buffer[this.bufferPos++] & 0xFFL) << 24 | ((long)this.buffer[this.bufferPos++] & 0xFFL) << 32 | ((long)this.buffer[this.bufferPos++] & 0xFFL) << 40 | ((long)this.buffer[this.bufferPos++] & 0xFFL) << 48 | ((long)this.buffer[this.bufferPos++] & 0xFFL) << 56;
        return Double.longBitsToDouble(val);
    }

    protected boolean decodeBool() throws IOException {
        if (this.bufferPos + 1 > this.bufferFill) {
            this.fillBuffer(1);
        }
        return this.buffer[this.bufferPos++] != 0;
    }

    protected int decodeInterleavedPoints(GeometryBuffer geom, float scale) throws IOException {
        float[] points = geom.points;
        int bytes = this.decodeVarint32();
        this.fillBuffer(bytes);
        int cnt = 0;
        int lastX = 0;
        int lastY = 0;
        boolean even = true;
        byte[] buf = this.buffer;
        int pos = this.bufferPos;
        int end = pos + bytes;
        while (pos < end) {
            int b;
            int val = b = buf[pos++];
            if (b < 0) {
                b = buf[pos++];
                val = val & 0x7F | b << 7;
                if (b < 0) {
                    b = buf[pos++];
                    val = val & 0x3FFF | b << 14;
                    if (b < 0) {
                        b = buf[pos++];
                        val = val & 0x1FFFFF | b << 21;
                        if (b < 0) {
                            b = buf[pos++];
                            val = val & 0xFFFFFFF | b << 28;
                            if (b < 0) {
                                throw INVALID_VARINT;
                            }
                        }
                    }
                }
            }
            int s = val >>> 1 ^ -(val & 1);
            if (even) {
                points[cnt++] = (float)(lastX += s) / scale;
                even = false;
                continue;
            }
            points[cnt++] = (float)(lastY += s) / scale;
            even = true;
        }
        if (pos != this.bufferPos + bytes) {
            throw INVALID_PACKED_SIZE;
        }
        this.bufferPos = pos;
        geom.pointNextPos = cnt;
        return cnt >> 1;
    }

    protected int decodeInterleavedPoints3D(float[] coords, float scale) throws IOException {
        int bytes = this.decodeVarint32();
        this.fillBuffer(bytes);
        int cnt = 0;
        int lastX = 0;
        int lastY = 0;
        int lastZ = 0;
        int cur = 0;
        byte[] buf = this.buffer;
        int pos = this.bufferPos;
        int end = pos + bytes;
        while (pos < end) {
            int b;
            int val = b = buf[pos++];
            if (b < 0) {
                b = buf[pos++];
                val = val & 0x7F | b << 7;
                if (b < 0) {
                    b = buf[pos++];
                    val = val & 0x3FFF | b << 14;
                    if (b < 0) {
                        b = buf[pos++];
                        val = val & 0x1FFFFF | b << 21;
                        if (b < 0) {
                            b = buf[pos++];
                            val = val & 0xFFFFFFF | b << 28;
                            if (b < 0) {
                                throw INVALID_VARINT;
                            }
                        }
                    }
                }
            }
            int s = val >>> 1 ^ -(val & 1);
            coords[cnt++] = cur == 0 ? (float)(lastX += s) / scale : (cur == 1 ? (float)(lastY += s) / scale : (float)(lastZ += s) / scale);
            cur = (cur + 1) % 3;
        }
        if (pos != this.bufferPos + bytes) {
            throw INVALID_PACKED_SIZE;
        }
        this.bufferPos = pos;
        return cnt;
    }

    protected static int deZigZag(int val) {
        return val >>> 1 ^ -(val & 1);
    }

    public void decodeVarintArray(int num, int[] array) throws IOException {
        int bytes = this.decodeVarint32();
        this.fillBuffer(bytes);
        byte[] buf = this.buffer;
        int pos = this.bufferPos;
        int cnt = 0;
        int end = pos + bytes;
        while (pos < end) {
            int b;
            if (cnt == num) {
                throw new ProtobufException("invalid array size " + num);
            }
            int val = b = buf[pos++];
            if (b < 0) {
                b = buf[pos++];
                val = val & 0x7F | b << 7;
                if (b < 0) {
                    b = buf[pos++];
                    val = val & 0x3FFF | b << 14;
                    if (b < 0) {
                        b = buf[pos++];
                        val = val & 0x1FFFFF | b << 21;
                        if (b < 0) {
                            b = buf[pos++];
                            val = val & 0xFFFFFFF | b << 28;
                            if (b < 0) {
                                throw INVALID_VARINT;
                            }
                        }
                    }
                }
            }
            array[cnt] = val;
            ++cnt;
        }
        if (pos != this.bufferPos + bytes) {
            throw INVALID_PACKED_SIZE;
        }
        this.bufferPos = pos;
    }

    protected short[] decodeUnsignedVarintArray(short[] array) throws IOException {
        int bytes = this.decodeVarint32();
        int arrayLength = 0;
        if (array == null) {
            arrayLength = 32;
            array = new short[32];
        }
        this.fillBuffer(bytes);
        int cnt = 0;
        byte[] buf = this.buffer;
        int pos = this.bufferPos;
        int end = pos + bytes;
        while (pos < end) {
            int b;
            int val = b = buf[pos++];
            if (b < 0) {
                b = buf[pos++];
                val = val & 0x7F | b << 7;
                if (b < 0) {
                    b = buf[pos++];
                    val = val & 0x3FFF | b << 14;
                    if (b < 0) {
                        b = buf[pos++];
                        val = val & 0x1FFFFF | b << 21;
                        if (b < 0) {
                            b = buf[pos++];
                            val = val & 0xFFFFFFF | b << 28;
                            if (b < 0) {
                                throw INVALID_VARINT;
                            }
                        }
                    }
                }
            }
            if (arrayLength <= cnt) {
                arrayLength = cnt + 16;
                short[] tmp = array;
                array = new short[arrayLength];
                System.arraycopy(tmp, 0, array, 0, cnt);
            }
            array[cnt] = (short)val;
            ++cnt;
        }
        if (pos != this.bufferPos + bytes) {
            throw INVALID_PACKED_SIZE;
        }
        this.bufferPos = pos;
        if (arrayLength > cnt) {
            array[cnt] = -1;
        }
        return array;
    }

    protected int decodeVarint32Filled() throws IOException {
        int b;
        byte[] buf = this.buffer;
        int pos = this.bufferPos;
        int val = b = buf[pos++];
        if (b < 0) {
            b = buf[pos++];
            val = val & 0x7F | b << 7;
            if (b < 0) {
                b = buf[pos++];
                val = val & 0x3FFF | b << 14;
                if (b < 0) {
                    b = buf[pos++];
                    val = val & 0x1FFFFF | b << 21;
                    if (b < 0) {
                        b = buf[pos++];
                        val = val & 0xFFFFFFF | b << 28;
                        if (b < 0) {
                            throw INVALID_VARINT;
                        }
                    }
                }
            }
        }
        this.bufferPos = pos;
        return val;
    }

    public boolean hasData() throws IOException {
        return this.fillBuffer(1) > 0;
    }

    public int position() {
        return this.mBufferOffset + this.bufferPos;
    }

    public int fillBuffer(int size) throws IOException {
        int bytesLeft = this.bufferFill - this.bufferPos;
        if (bytesLeft >= size) {
            return bytesLeft;
        }
        int maxSize = this.buffer.length;
        if (size > maxSize) {
            maxSize = size;
            byte[] tmp = this.buffer;
            this.buffer = new byte[maxSize];
            System.arraycopy(tmp, this.bufferPos, this.buffer, 0, bytesLeft);
            this.mBufferOffset += this.bufferPos;
            this.bufferPos = 0;
            this.bufferFill = bytesLeft;
        } else if (bytesLeft == 0) {
            this.mBufferOffset += this.bufferPos;
            this.bufferPos = 0;
            this.bufferFill = 0;
        } else if (this.bufferPos + size > maxSize) {
            System.arraycopy(this.buffer, this.bufferPos, this.buffer, 0, bytesLeft);
            this.mBufferOffset += this.bufferPos;
            this.bufferPos = 0;
            this.bufferFill = bytesLeft;
        }
        while (this.bufferFill - this.bufferPos < size) {
            int max = maxSize - this.bufferFill;
            if (max <= 0) {
                throw new IOException("burp");
            }
            int len = this.mInputStream.read(this.buffer, this.bufferFill, max);
            if (len < 0) {
                this.buffer[this.bufferFill] = 0;
                return this.bufferFill - this.bufferPos;
            }
            this.mMsgPos += len;
            this.bufferFill += len;
        }
        return this.bufferFill - this.bufferPos;
    }

    protected static int readUnsignedInt(InputStream is, byte[] buf) throws IOException {
        int read;
        int len = 0;
        for (read = 0; read < 4 && (len = is.read(buf, read, 4 - read)) >= 0; read += len) {
        }
        if (read < 4) {
            return read < 0 ? read * 10 : read;
        }
        return PbfDecoder.decodeInt(buf, 0);
    }

    static int decodeInt(byte[] buffer, int offset) {
        return buffer[offset] << 24 | (buffer[offset + 1] & 0xFF) << 16 | (buffer[offset + 2] & 0xFF) << 8 | buffer[offset + 3] & 0xFF;
    }

    static class ProtobufException
    extends IOException {
        private static final long serialVersionUID = 1L;

        public ProtobufException(String detailMessage) {
            super(detailMessage);
        }
    }
}

