/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.tiling.source.mapfile;

import org.oscim.core.Tile;
import org.oscim.tiling.source.mapfile.QueryParameters;
import org.oscim.tiling.source.mapfile.header.SubFileParameter;

final class QueryCalculations {
    private static int getFirstLevelTileBitmask(Tile tile) {
        if (tile.tileX % 2 == 0 && tile.tileY % 2 == 0) {
            return 52224;
        }
        if ((tile.tileX & 1) == 1 && tile.tileY % 2 == 0) {
            return 13056;
        }
        if (tile.tileX % 2 == 0 && (tile.tileY & 1) == 1) {
            return 204;
        }
        return 51;
    }

    private static int getSecondLevelTileBitmaskLowerLeft(long subtileX, long subtileY) {
        if (subtileX % 2L == 0L && subtileY % 2L == 0L) {
            return 128;
        }
        if (subtileX % 2L == 1L && subtileY % 2L == 0L) {
            return 64;
        }
        if (subtileX % 2L == 0L && subtileY % 2L == 1L) {
            return 8;
        }
        return 4;
    }

    private static int getSecondLevelTileBitmaskLowerRight(long subtileX, long subtileY) {
        if (subtileX % 2L == 0L && subtileY % 2L == 0L) {
            return 32;
        }
        if (subtileX % 2L == 1L && subtileY % 2L == 0L) {
            return 16;
        }
        if (subtileX % 2L == 0L && subtileY % 2L == 1L) {
            return 2;
        }
        return 1;
    }

    private static int getSecondLevelTileBitmaskUpperLeft(long subtileX, long subtileY) {
        if (subtileX % 2L == 0L && subtileY % 2L == 0L) {
            return 32768;
        }
        if (subtileX % 2L == 1L && subtileY % 2L == 0L) {
            return 16384;
        }
        if (subtileX % 2L == 0L && subtileY % 2L == 1L) {
            return 2048;
        }
        return 1024;
    }

    private static int getSecondLevelTileBitmaskUpperRight(long subtileX, long subtileY) {
        if (subtileX % 2L == 0L && subtileY % 2L == 0L) {
            return 8192;
        }
        if (subtileX % 2L == 1L && subtileY % 2L == 0L) {
            return 4096;
        }
        if (subtileX % 2L == 0L && subtileY % 2L == 1L) {
            return 512;
        }
        return 256;
    }

    static void calculateBaseTiles(QueryParameters queryParameters, Tile tile, SubFileParameter subFileParameter) {
        if (tile.zoomLevel < subFileParameter.baseZoomLevel) {
            int zoomLevelDifference = subFileParameter.baseZoomLevel - tile.zoomLevel;
            queryParameters.fromBaseTileX = tile.tileX << zoomLevelDifference;
            queryParameters.fromBaseTileY = tile.tileY << zoomLevelDifference;
            queryParameters.toBaseTileX = queryParameters.fromBaseTileX + (long)(1 << zoomLevelDifference) - 1L;
            queryParameters.toBaseTileY = queryParameters.fromBaseTileY + (long)(1 << zoomLevelDifference) - 1L;
            queryParameters.useTileBitmask = false;
        } else if (tile.zoomLevel > subFileParameter.baseZoomLevel) {
            int zoomLevelDifference = tile.zoomLevel - subFileParameter.baseZoomLevel;
            queryParameters.fromBaseTileX = tile.tileX >>> zoomLevelDifference;
            queryParameters.fromBaseTileY = tile.tileY >>> zoomLevelDifference;
            queryParameters.toBaseTileX = queryParameters.fromBaseTileX;
            queryParameters.toBaseTileY = queryParameters.fromBaseTileY;
            queryParameters.useTileBitmask = true;
            queryParameters.queryTileBitmask = QueryCalculations.calculateTileBitmask(tile, zoomLevelDifference);
        } else {
            queryParameters.fromBaseTileX = tile.tileX;
            queryParameters.fromBaseTileY = tile.tileY;
            queryParameters.toBaseTileX = queryParameters.fromBaseTileX;
            queryParameters.toBaseTileY = queryParameters.fromBaseTileY;
            queryParameters.useTileBitmask = false;
        }
    }

    static void calculateBaseTiles(QueryParameters queryParameters, Tile upperLeft, Tile lowerRight, SubFileParameter subFileParameter) {
        if (upperLeft.zoomLevel < subFileParameter.baseZoomLevel) {
            int zoomLevelDifference = subFileParameter.baseZoomLevel - upperLeft.zoomLevel;
            queryParameters.fromBaseTileX = upperLeft.tileX << zoomLevelDifference;
            queryParameters.fromBaseTileY = upperLeft.tileY << zoomLevelDifference;
            queryParameters.toBaseTileX = (lowerRight.tileX << zoomLevelDifference) + (1 << zoomLevelDifference) - 1;
            queryParameters.toBaseTileY = (lowerRight.tileY << zoomLevelDifference) + (1 << zoomLevelDifference) - 1;
            queryParameters.useTileBitmask = false;
        } else if (upperLeft.zoomLevel > subFileParameter.baseZoomLevel) {
            int zoomLevelDifference = upperLeft.zoomLevel - subFileParameter.baseZoomLevel;
            queryParameters.fromBaseTileX = upperLeft.tileX >>> zoomLevelDifference;
            queryParameters.fromBaseTileY = upperLeft.tileY >>> zoomLevelDifference;
            queryParameters.toBaseTileX = lowerRight.tileX >>> zoomLevelDifference;
            queryParameters.toBaseTileY = lowerRight.tileY >>> zoomLevelDifference;
            queryParameters.useTileBitmask = true;
            queryParameters.queryTileBitmask = QueryCalculations.calculateTileBitmask(upperLeft, lowerRight, zoomLevelDifference);
        } else {
            queryParameters.fromBaseTileX = upperLeft.tileX;
            queryParameters.fromBaseTileY = upperLeft.tileY;
            queryParameters.toBaseTileX = lowerRight.tileX;
            queryParameters.toBaseTileY = lowerRight.tileY;
            queryParameters.useTileBitmask = false;
        }
    }

    static void calculateBlocks(QueryParameters queryParameters, SubFileParameter subFileParameter) {
        queryParameters.fromBlockX = Math.max(queryParameters.fromBaseTileX - subFileParameter.boundaryTileLeft, 0L);
        queryParameters.fromBlockY = Math.max(queryParameters.fromBaseTileY - subFileParameter.boundaryTileTop, 0L);
        queryParameters.toBlockX = Math.min(queryParameters.toBaseTileX - subFileParameter.boundaryTileLeft, subFileParameter.blocksWidth - 1L);
        queryParameters.toBlockY = Math.min(queryParameters.toBaseTileY - subFileParameter.boundaryTileTop, subFileParameter.blocksHeight - 1L);
    }

    static int calculateTileBitmask(Tile tile, int zoomLevelDifference) {
        if (zoomLevelDifference == 1) {
            return QueryCalculations.getFirstLevelTileBitmask(tile);
        }
        long subtileX = tile.tileX >>> zoomLevelDifference - 2;
        long subtileY = tile.tileY >>> zoomLevelDifference - 2;
        long parentTileX = subtileX >>> 1;
        long parentTileY = subtileY >>> 1;
        if (parentTileX % 2L == 0L && parentTileY % 2L == 0L) {
            return QueryCalculations.getSecondLevelTileBitmaskUpperLeft(subtileX, subtileY);
        }
        if (parentTileX % 2L == 1L && parentTileY % 2L == 0L) {
            return QueryCalculations.getSecondLevelTileBitmaskUpperRight(subtileX, subtileY);
        }
        if (parentTileX % 2L == 0L && parentTileY % 2L == 1L) {
            return QueryCalculations.getSecondLevelTileBitmaskLowerLeft(subtileX, subtileY);
        }
        return QueryCalculations.getSecondLevelTileBitmaskLowerRight(subtileX, subtileY);
    }

    static int calculateTileBitmask(Tile upperLeft, Tile lowerRight, int zoomLevelDifference) {
        int bitmask = 0;
        for (int x = upperLeft.tileX; x <= lowerRight.tileX; ++x) {
            for (int y = upperLeft.tileY; y <= lowerRight.tileY; ++y) {
                Tile current = new Tile(x, y, upperLeft.zoomLevel);
                bitmask |= QueryCalculations.calculateTileBitmask(current, zoomLevelDifference);
            }
        }
        return bitmask;
    }

    private QueryCalculations() {
        throw new IllegalStateException();
    }
}

