/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.utils;

public class FastMath {
    public static float abs(float value) {
        return value < 0.0f ? -value : value;
    }

    public static float absMax(float value1, float value2) {
        float a1 = value1 < 0.0f ? -value1 : value1;
        float a2 = value2 < 0.0f ? -value2 : value2;
        return a2 < a1 ? a1 : a2;
    }

    public static boolean absMaxCmp(float value1, float value2, float cmp) {
        return value1 < -cmp || value1 > cmp || value2 < -cmp || value2 > cmp;
    }

    public static boolean absMaxCmp(int value1, int value2, int cmp) {
        return value1 < -cmp || value1 > cmp || value2 < -cmp || value2 > cmp;
    }

    public static int clamp(int value, int min, int max) {
        return value < min ? min : (value > max ? max : value);
    }

    public static float clamp(float value, float min, float max) {
        return value < min ? min : (value > max ? max : value);
    }

    public static double clamp(double value, double min, double max) {
        return value < min ? min : (value > max ? max : value);
    }

    public static double clampDegree(double degree) {
        while (degree > 180.0) {
            degree -= 360.0;
        }
        while (degree < -180.0) {
            degree += 360.0;
        }
        return degree;
    }

    public static float clampN(float value) {
        return value < 0.0f ? 0.0f : (value > 1.0f ? 1.0f : value);
    }

    public static double clampRadian(double radian) {
        while (radian > Math.PI) {
            radian -= Math.PI * 2;
        }
        while (radian < -Math.PI) {
            radian += Math.PI * 2;
        }
        return radian;
    }

    public static byte clampToByte(int value) {
        return (byte)(value < 0 ? 0 : (value > 255 ? 255 : value));
    }

    public static int log2(int x) {
        int r = 0;
        if ((x & 0xFFFF0000) != 0) {
            x >>= 16;
            r |= 0x10;
        }
        if ((x & 0xFF00) != 0) {
            x >>= 8;
            r |= 8;
        }
        if ((x & 0xF0) != 0) {
            x >>= 4;
            r |= 4;
        }
        if ((x & 0xC) != 0) {
            x >>= 2;
            r |= 2;
        }
        if ((x & 2) != 0) {
            r |= 1;
        }
        return r;
    }

    public static float pow(int x) {
        if (x == 0) {
            return 1.0f;
        }
        return x > 0 ? (float)(1 << x) : 1.0f / (float)(1 << -x);
    }

    public static float round2(float value) {
        return (float)Math.round(value * 100.0f) / 100.0f;
    }

    public static boolean withinSquaredDist(int dx, int dy, int distance) {
        return dx * dx + dy * dy < distance;
    }

    public static boolean withinSquaredDist(float dx, float dy, float distance) {
        return dx * dx + dy * dy < distance;
    }
}

