/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.utils;

import org.oscim.core.BoundingBox;
import org.oscim.core.GeoPoint;
import org.oscim.core.MercatorProjection;
import org.oscim.core.Point;
import org.oscim.core.Tile;

public final class GeoPointUtils {
    public static final double LATITUDE_MAX = 90.0;
    public static final double LATITUDE_MIN = -90.0;
    public static final double LONGITUDE_MAX = 180.0;
    public static final double LONGITUDE_MIN = -180.0;

    public static boolean contains(GeoPoint[] geoPoints, GeoPoint geoPoint) {
        boolean result = false;
        int i = 0;
        int j = geoPoints.length - 1;
        while (i < geoPoints.length) {
            if (geoPoints[i].getLatitude() > geoPoint.getLatitude() != geoPoints[j].getLatitude() > geoPoint.getLatitude() && geoPoint.getLongitude() < (geoPoints[j].getLongitude() - geoPoints[i].getLongitude()) * (geoPoint.getLatitude() - geoPoints[i].getLatitude()) / (geoPoints[j].getLatitude() - geoPoints[i].getLatitude()) + geoPoints[i].getLongitude()) {
                result = !result;
            }
            j = i++;
        }
        return result;
    }

    public static double distanceSegmentPoint(double startX, double startY, double endX, double endY, double pointX, double pointY) {
        Point nearest = GeoPointUtils.nearestSegmentPoint(startX, startY, endX, endY, pointX, pointY);
        return Math.hypot(nearest.x - pointX, nearest.y - pointY);
    }

    public static boolean isClosedWay(GeoPoint[] geoPoints) {
        return geoPoints[0].distance(geoPoints[geoPoints.length - 1]) < 1.0E-9;
    }

    public static Point nearestSegmentPoint(double startX, double startY, double endX, double endY, double pointX, double pointY) {
        double xDiff = endX - startX;
        double yDiff = endY - startY;
        double length2 = xDiff * xDiff + yDiff * yDiff;
        if (length2 == 0.0) {
            return new Point(startX, startY);
        }
        double t = ((pointX - startX) * (endX - startX) + (pointY - startY) * (endY - startY)) / length2;
        if (t < 0.0) {
            return new Point(startX, startY);
        }
        if (t > 1.0) {
            return new Point(endX, endY);
        }
        return new Point(startX + t * (endX - startX), startY + t * (endY - startY));
    }

    public static double scaleForBounds(BoundingBox bbox, int viewWidth, int viewHeight) {
        double minx = MercatorProjection.longitudeToX(bbox.getMinLongitude());
        double miny = MercatorProjection.latitudeToY(bbox.getMaxLatitude());
        double dx = Math.abs(MercatorProjection.longitudeToX(bbox.getMaxLongitude()) - minx);
        double dy = Math.abs(MercatorProjection.latitudeToY(bbox.getMinLatitude()) - miny);
        double zx = (double)viewWidth / (dx * (double)Tile.SIZE);
        double zy = (double)viewHeight / (dy * (double)Tile.SIZE);
        return Math.min(zx, zy);
    }

    public static double validateLatitude(double latitude) {
        if (Double.isNaN(latitude) || latitude < -90.0 || latitude > 90.0) {
            throw new IllegalArgumentException("invalid latitude: " + latitude);
        }
        return latitude;
    }

    public static double validateLongitude(double longitude) {
        if (Double.isNaN(longitude) || longitude < -180.0 || longitude > 180.0) {
            throw new IllegalArgumentException("invalid longitude: " + longitude);
        }
        return longitude;
    }

    private GeoPointUtils() {
        throw new IllegalStateException();
    }
}

