/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.utils;

import org.oscim.core.Tile;

public abstract class ScanBox {
    private final float[] mBox = new float[8];
    private Edge ab = new Edge();
    private Edge bc = new Edge();
    private Edge ca = new Edge();
    private int xmin;
    private int xmax;
    protected int mZoom;

    private float[] transScale(double x, double y, double scale, int zoom, float[] box) {
        double div = (scale *= (double)Tile.SIZE) / (double)(1 << zoom);
        x *= scale;
        y *= scale;
        for (int i = 0; i < 8; i += 2) {
            this.mBox[i + 0] = (float)((x + (double)box[i + 0]) / div);
            this.mBox[i + 1] = (float)((y + (double)box[i + 1]) / div);
        }
        return this.mBox;
    }

    protected abstract void setVisible(int var1, int var2, int var3);

    public void scan(double x, double y, double scale, int zoom, float[] box) {
        this.mZoom = zoom;
        box = this.transScale(x, y, scale, zoom, box);
        float max = Float.MIN_VALUE;
        float min = Float.MAX_VALUE;
        for (int i = 0; i < 8; i += 2) {
            float xx = box[i];
            if (xx > max) {
                max = xx;
            }
            if (!(xx < min)) continue;
            min = xx;
        }
        max = (float)Math.ceil(max);
        if ((min = (float)Math.floor(min)) == max) {
            max += 1.0f;
        }
        this.xmin = (int)min;
        this.xmax = (int)max;
        this.ab.set(box[0], box[1], box[2], box[3]);
        this.bc.set(box[2], box[3], box[4], box[5]);
        this.ca.set(box[4], box[5], box[0], box[1]);
        this.scanTriangle();
        this.ab.set(box[0], box[1], box[4], box[5]);
        this.bc.set(box[4], box[5], box[6], box[7]);
        this.ca.set(box[6], box[7], box[0], box[1]);
        this.scanTriangle();
    }

    private void scanTriangle() {
        Edge t;
        if (this.ab.dy > this.bc.dy) {
            t = this.ab;
            this.ab = this.bc;
            this.bc = t;
        }
        if (this.ab.dy > this.ca.dy) {
            t = this.ab;
            this.ab = this.ca;
            this.ca = t;
        }
        if (this.bc.dy > this.ca.dy) {
            t = this.bc;
            this.bc = this.ca;
            this.ca = t;
        }
        if (this.ca.dy == 0.0f) {
            return;
        }
        if ((double)this.ab.dy > 0.0) {
            this.scanSpans(this.ca, this.ab);
        }
        if ((double)this.bc.dy > 0.0) {
            this.scanSpans(this.ca, this.bc);
        }
    }

    private void scanSpans(Edge e0, Edge e1) {
        Edge t;
        int y0 = (int)Math.max(0.0, Math.floor(e1.y0));
        int y1 = (int)Math.min((double)(1 << this.mZoom), Math.ceil(e1.y1));
        if (e0.x0 == e1.x0 && e0.y0 == e1.y0) {
            if (e0.x0 + e1.dy / e0.dy * e0.dx < e1.x1) {
                t = e0;
                e0 = e1;
                e1 = t;
            }
        } else if (e0.x1 - e1.dy / e0.dy * e0.dx < e1.x0) {
            t = e0;
            e0 = e1;
            e1 = t;
        }
        float m0 = e0.dx / e0.dy;
        float m1 = e1.dx / e1.dy;
        int d0 = e0.dx > 0.0f ? 1 : 0;
        int d1 = e1.dx < 0.0f ? 1 : 0;
        for (int y = y0; y < y1; ++y) {
            int x1;
            float dy = (float)(d0 + y) - e0.y0;
            if (dy > e0.dy) {
                dy = e0.dy;
            }
            int x0 = (int)Math.ceil(e0.x0 + m0 * dy);
            dy = (float)(d1 + y) - e1.y0;
            if (dy > e1.dy) {
                dy = e1.dy;
            }
            if ((x1 = (int)Math.floor(e1.x0 + m1 * dy)) < this.xmin) {
                x1 = this.xmin;
            }
            if (x0 > this.xmax) {
                x0 = this.xmax;
            }
            if (x1 >= x0) continue;
            this.setVisible(y, x1, x0);
        }
    }

    static class Edge {
        float x0;
        float y0;
        float x1;
        float y1;
        float dx;
        float dy;

        Edge() {
        }

        void set(float x0, float y0, float x1, float y1) {
            if (y0 <= y1) {
                this.x0 = x0;
                this.y0 = y0;
                this.x1 = x1;
                this.y1 = y1;
            } else {
                this.x0 = x1;
                this.y0 = y1;
                this.x1 = x0;
                this.y1 = y0;
            }
            this.dx = this.x1 - this.x0;
            this.dy = this.y1 - this.y0;
        }
    }
}

