/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.core;

import org.oscim.core.GeoPoint;
import org.oscim.core.MapPosition;
import org.oscim.core.Point;
import org.oscim.core.Tile;
import org.oscim.utils.FastMath;

public final class MercatorProjection {
    public static final double EARTH_CIRCUMFERENCE = 4.0075016686E7;
    public static final double LATITUDE_MAX = 85.05112877980659;
    public static final double LATITUDE_MIN = -85.05112877980659;
    public static final double LONGITUDE_MAX = 180.0;
    public static final double LONGITUDE_MIN = -180.0;

    public static GeoPoint fromPixelsWithScale(double pixelX, double pixelY, double scale) {
        return new GeoPoint(MercatorProjection.pixelYToLatitudeWithScale(pixelY, scale), MercatorProjection.pixelXToLongitudeWithScale(pixelX, scale));
    }

    public static GeoPoint fromPixels(double pixelX, double pixelY, long mapSize) {
        return new GeoPoint(MercatorProjection.pixelYToLatitude(pixelY, mapSize), MercatorProjection.pixelXToLongitude(pixelX, mapSize));
    }

    public static long getMapSizeWithScale(double scale) {
        if (scale < 1.0) {
            throw new IllegalArgumentException("scale factor must not < 1 " + scale);
        }
        return (long)((double)Tile.SIZE * Math.pow(2.0, MercatorProjection.scaleToZoomLevel(scale)));
    }

    public static long getMapSize(byte zoomLevel) {
        if (zoomLevel < 0) {
            throw new IllegalArgumentException("zoom level must not be negative: " + zoomLevel);
        }
        return (long)Tile.SIZE << zoomLevel;
    }

    public static Point getPixelWithScale(GeoPoint geoPoint, double scale) {
        double pixelX = MercatorProjection.longitudeToPixelXWithScale(geoPoint.getLongitude(), scale);
        double pixelY = MercatorProjection.latitudeToPixelYWithScale(geoPoint.getLatitude(), scale);
        return new Point(pixelX, pixelY);
    }

    public static Point getPixel(GeoPoint geoPoint, long mapSize) {
        double pixelX = MercatorProjection.longitudeToPixelX(geoPoint.getLongitude(), mapSize);
        double pixelY = MercatorProjection.latitudeToPixelY(geoPoint.getLatitude(), mapSize);
        return new Point(pixelX, pixelY);
    }

    public static Point getPixelAbsolute(GeoPoint geoPoint, long mapSize) {
        return MercatorProjection.getPixelRelative(geoPoint, mapSize, 0.0, 0.0);
    }

    public static Point getPixelRelative(GeoPoint geoPoint, long mapSize, double x, double y) {
        double pixelX = MercatorProjection.longitudeToPixelX(geoPoint.getLongitude(), mapSize) - x;
        double pixelY = MercatorProjection.latitudeToPixelY(geoPoint.getLatitude(), mapSize) - y;
        return new Point(pixelX, pixelY);
    }

    public static Point getPixelRelative(GeoPoint geoPoint, long mapSize, Point origin) {
        return MercatorProjection.getPixelRelative(geoPoint, mapSize, origin.x, origin.y);
    }

    public static Point getPixelRelativeToTile(GeoPoint geoPoint, Tile tile) {
        return MercatorProjection.getPixelRelative(geoPoint, tile.mapSize, tile.getOrigin());
    }

    public static double groundResolutionWithScale(double latitude, double scale) {
        return Math.cos(latitude * (Math.PI / 180)) * 4.0075016686E7 / ((double)Tile.SIZE * scale);
    }

    public static float groundResolution(MapPosition pos) {
        double lat = MercatorProjection.toLatitude(pos.y);
        return (float)(Math.cos(lat * (Math.PI / 180)) * 4.0075016686E7 / ((double)Tile.SIZE * pos.scale));
    }

    public static double groundResolution(double latitude, long mapSize) {
        return Math.cos(latitude * (Math.PI / 180)) * 4.0075016686E7 / (double)mapSize;
    }

    public static double latitudeToPixelYWithScale(double latitude, double scale) {
        double sinLatitude = Math.sin(latitude * (Math.PI / 180));
        long mapSize = MercatorProjection.getMapSizeWithScale(scale);
        double pixelY = (0.5 - Math.log((1.0 + sinLatitude) / (1.0 - sinLatitude)) / (Math.PI * 4)) * (double)mapSize;
        return Math.min(Math.max(0.0, pixelY), (double)mapSize);
    }

    public static double latitudeToPixelY(double latitude, byte zoomLevel) {
        double sinLatitude = Math.sin(latitude * (Math.PI / 180));
        long mapSize = MercatorProjection.getMapSize(zoomLevel);
        double pixelY = (0.5 - Math.log((1.0 + sinLatitude) / (1.0 - sinLatitude)) / (Math.PI * 4)) * (double)mapSize;
        return Math.min(Math.max(0.0, pixelY), (double)mapSize);
    }

    public static double latitudeToPixelY(double latitude, long mapSize) {
        double sinLatitude = Math.sin(latitude * (Math.PI / 180));
        double pixelY = (0.5 - Math.log((1.0 + sinLatitude) / (1.0 - sinLatitude)) / (Math.PI * 4)) * (double)mapSize;
        return Math.min(Math.max(0.0, pixelY), (double)mapSize);
    }

    public static int latitudeToTileYWithScale(double latitude, double scale) {
        return MercatorProjection.pixelYToTileYWithScale(MercatorProjection.latitudeToPixelYWithScale(latitude, scale), scale);
    }

    public static int latitudeToTileY(double latitude, byte zoomLevel) {
        return MercatorProjection.pixelYToTileY(MercatorProjection.latitudeToPixelY(latitude, zoomLevel), zoomLevel);
    }

    public static double latitudeToY(double latitude) {
        double sinLatitude = Math.sin(latitude * (Math.PI / 180));
        return FastMath.clamp(0.5 - Math.log((1.0 + sinLatitude) / (1.0 - sinLatitude)) / (Math.PI * 4), 0.0, 1.0);
    }

    public static double limitLatitude(double latitude) {
        return Math.max(Math.min(latitude, 85.05112877980659), -85.05112877980659);
    }

    public static double limitLongitude(double longitude) {
        return Math.max(Math.min(longitude, 180.0), -180.0);
    }

    public static double longitudeToPixelXWithScale(double longitude, double scale) {
        long mapSize = MercatorProjection.getMapSizeWithScale(scale);
        return (longitude + 180.0) / 360.0 * (double)mapSize;
    }

    public static double longitudeToPixelX(double longitude, byte zoomLevel) {
        long mapSize = MercatorProjection.getMapSize(zoomLevel);
        return (longitude + 180.0) / 360.0 * (double)mapSize;
    }

    public static double longitudeToPixelX(double longitude, long mapSize) {
        return (longitude + 180.0) / 360.0 * (double)mapSize;
    }

    public static int longitudeToTileXWithScale(double longitude, double scale) {
        return MercatorProjection.pixelXToTileXWithScale(MercatorProjection.longitudeToPixelXWithScale(longitude, scale), scale);
    }

    public static int longitudeToTileX(double longitude, byte zoomLevel) {
        return MercatorProjection.pixelXToTileX(MercatorProjection.longitudeToPixelX(longitude, zoomLevel), zoomLevel);
    }

    public static double longitudeToX(double longitude) {
        return (longitude + 180.0) / 360.0;
    }

    public static double metersToPixelsWithScale(float meters, double latitude, double scale) {
        return (double)meters / MercatorProjection.groundResolutionWithScale(latitude, scale);
    }

    public static double metersToPixels(float meters, double latitude, long mapSize) {
        return (double)meters / MercatorProjection.groundResolution(latitude, mapSize);
    }

    public static double pixelXToLongitudeWithScale(double pixelX, double scale) {
        long mapSize = MercatorProjection.getMapSizeWithScale(scale);
        if (pixelX < 0.0 || pixelX > (double)mapSize) {
            throw new IllegalArgumentException("invalid pixelX coordinate at scale " + scale + ": " + pixelX);
        }
        return 360.0 * (pixelX / (double)mapSize - 0.5);
    }

    public static double pixelXToLongitude(double pixelX, long mapSize) {
        if (pixelX < 0.0 || pixelX > (double)mapSize) {
            throw new IllegalArgumentException("invalid pixelX coordinate " + mapSize + ": " + pixelX);
        }
        return 360.0 * (pixelX / (double)mapSize - 0.5);
    }

    public static int pixelXToTileXWithScale(double pixelX, double scale) {
        return (int)Math.min(Math.max(pixelX / (double)Tile.SIZE, 0.0), scale - 1.0);
    }

    public static int pixelXToTileX(double pixelX, byte zoomLevel) {
        return (int)Math.min(Math.max(pixelX / (double)Tile.SIZE, 0.0), Math.pow(2.0, zoomLevel) - 1.0);
    }

    public static double pixelYToLatitudeWithScale(double pixelY, double scale) {
        long mapSize = MercatorProjection.getMapSizeWithScale(scale);
        if (pixelY < 0.0 || pixelY > (double)mapSize) {
            throw new IllegalArgumentException("invalid pixelY coordinate at scale " + scale + ": " + pixelY);
        }
        double y = 0.5 - pixelY / (double)mapSize;
        return 90.0 - 360.0 * Math.atan(Math.exp(-y * (Math.PI * 2))) / Math.PI;
    }

    public static double pixelYToLatitude(double pixelY, long mapSize) {
        if (pixelY < 0.0 || pixelY > (double)mapSize) {
            throw new IllegalArgumentException("invalid pixelY coordinate " + mapSize + ": " + pixelY);
        }
        double y = 0.5 - pixelY / (double)mapSize;
        return 90.0 - 360.0 * Math.atan(Math.exp(-y * (Math.PI * 2))) / Math.PI;
    }

    public static int pixelYToTileYWithScale(double pixelY, double scale) {
        return (int)Math.min(Math.max(pixelY / (double)Tile.SIZE, 0.0), scale - 1.0);
    }

    public static int pixelYToTileY(double pixelY, byte zoomLevel) {
        return (int)Math.min(Math.max(pixelY / (double)Tile.SIZE, 0.0), Math.pow(2.0, zoomLevel) - 1.0);
    }

    public static Point project(GeoPoint p, Point reuse) {
        if (reuse == null) {
            reuse = new Point();
        }
        reuse.x = ((double)p.longitudeE6 / 1000000.0 + 180.0) / 360.0;
        double sinLatitude = Math.sin((double)p.latitudeE6 / 1000000.0 * (Math.PI / 180));
        reuse.y = 0.5 - Math.log((1.0 + sinLatitude) / (1.0 - sinLatitude)) / (Math.PI * 4);
        return reuse;
    }

    public static void project(GeoPoint p, double[] out, int pos) {
        out[pos * 2] = ((double)p.longitudeE6 / 1000000.0 + 180.0) / 360.0;
        double sinLatitude = Math.sin((double)p.latitudeE6 / 1000000.0 * (Math.PI / 180));
        out[pos * 2 + 1] = 0.5 - Math.log((1.0 + sinLatitude) / (1.0 - sinLatitude)) / (Math.PI * 4);
    }

    public static void project(double latitude, double longitude, double[] out, int pos) {
        out[pos * 2] = (longitude + 180.0) / 360.0;
        double sinLatitude = Math.sin(latitude * (Math.PI / 180));
        out[pos * 2 + 1] = 0.5 - Math.log((1.0 + sinLatitude) / (1.0 - sinLatitude)) / (Math.PI * 4);
    }

    public static double scaleToZoomLevel(double scale) {
        return FastMath.log2((int)scale);
    }

    public static long tileToPixel(long tileNumber) {
        return tileNumber * (long)Tile.SIZE;
    }

    public static double tileXToLongitudeWithScale(long tileX, double scale) {
        return MercatorProjection.pixelXToLongitudeWithScale(tileX * (long)Tile.SIZE, scale);
    }

    public static double tileXToLongitude(long tileX, byte zoomLevel) {
        return MercatorProjection.pixelXToLongitude(tileX * (long)Tile.SIZE, MercatorProjection.getMapSize(zoomLevel));
    }

    public static double tileYToLatitudeWithScale(long tileY, double scale) {
        return MercatorProjection.pixelYToLatitudeWithScale(tileY * (long)Tile.SIZE, scale);
    }

    public static double tileYToLatitude(long tileY, byte zoomLevel) {
        return MercatorProjection.pixelYToLatitude(tileY * (long)Tile.SIZE, MercatorProjection.getMapSize(zoomLevel));
    }

    public static long tileYToTMS(long tileY, byte zoomLevel) {
        return (long)(MercatorProjection.zoomLevelToScale(zoomLevel) - (double)tileY - 1.0);
    }

    public static double toLatitude(double y) {
        return 90.0 - 360.0 * Math.atan(Math.exp((y - 0.5) * (Math.PI * 2))) / Math.PI;
    }

    public static double toLongitude(double x) {
        return 360.0 * (x - 0.5);
    }

    public static double wrapLongitude(double longitude) {
        if (longitude < -180.0) {
            return Math.max(Math.min(360.0 + longitude, 180.0), -180.0);
        }
        if (longitude > 180.0) {
            return Math.max(Math.min(longitude - 360.0, 180.0), -180.0);
        }
        return longitude;
    }

    public static double zoomLevelToScale(byte zoomLevel) {
        return 1 << zoomLevel;
    }

    private MercatorProjection() {
    }
}

