/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.layers.marker.utils;

import org.oscim.backend.CanvasAdapter;
import org.oscim.backend.canvas.Bitmap;
import org.oscim.backend.canvas.Canvas;
import org.oscim.backend.canvas.Paint;

public class ScreenUtils {
    public static int getPixels(float dp) {
        return (int)(CanvasAdapter.getScale() * dp);
    }

    public static class ClusterDrawable {
        private Paint mPaintText = CanvasAdapter.newPaint();
        private Paint mPaintCircle = CanvasAdapter.newPaint();
        private Paint mPaintBorder = CanvasAdapter.newPaint();
        private int mSize;
        private String mText;

        public ClusterDrawable(int sizedp, int foregroundColor, int backgroundColor, String text) {
            this.setup(sizedp, foregroundColor, backgroundColor);
            this.setText(text);
        }

        private void setup(int sizedp, int foregroundColor, int backgroundColor) {
            this.mSize = ScreenUtils.getPixels(sizedp);
            this.mPaintText.setTextSize(ScreenUtils.getPixels((int)((double)sizedp * 0.6666666)));
            this.mPaintText.setColor(foregroundColor);
            this.mPaintCircle.setColor(backgroundColor);
            this.mPaintCircle.setStyle(Paint.Style.FILL);
            this.mPaintBorder.setColor(foregroundColor);
            this.mPaintBorder.setStyle(Paint.Style.STROKE);
            this.mPaintBorder.setStrokeWidth(2.0f * CanvasAdapter.getScale());
        }

        private void setText(String text) {
            this.mText = text;
        }

        private void draw(Canvas canvas) {
            int halfsize = this.mSize >> 1;
            int noneClippingRadius = halfsize - ScreenUtils.getPixels(2.0f);
            canvas.drawCircle(halfsize, halfsize, noneClippingRadius, this.mPaintCircle);
            canvas.drawCircle(halfsize, halfsize, noneClippingRadius, this.mPaintBorder);
            canvas.drawText(this.mText, ((float)canvas.getWidth() - this.mPaintText.getTextWidth(this.mText)) * 0.5f, ((float)canvas.getHeight() + this.mPaintText.getTextHeight(this.mText)) * 0.5f, this.mPaintText);
        }

        public Bitmap getBitmap() {
            int width = this.mSize;
            int height = this.mSize;
            width = width > 0 ? width : 1;
            height = height > 0 ? height : 1;
            Bitmap bitmap = CanvasAdapter.newBitmap(width, height, 0);
            Canvas canvas = CanvasAdapter.newCanvas();
            canvas.setBitmap(bitmap);
            this.draw(canvas);
            return bitmap;
        }
    }
}

