/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.layers.tile.buildings;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.oscim.core.MapElement;
import org.oscim.core.Tag;
import org.oscim.layers.Layer;
import org.oscim.layers.tile.MapTile;
import org.oscim.layers.tile.ZoomLimiter;
import org.oscim.layers.tile.buildings.BuildingRenderer;
import org.oscim.layers.tile.vector.VectorTileLayer;
import org.oscim.map.Map;
import org.oscim.renderer.ExtrusionRenderer;
import org.oscim.renderer.OffscreenRenderer;
import org.oscim.renderer.bucket.ExtrusionBuckets;
import org.oscim.renderer.bucket.RenderBuckets;
import org.oscim.renderer.light.ShadowRenderer;
import org.oscim.theme.styles.ExtrusionStyle;
import org.oscim.theme.styles.RenderStyle;
import org.oscim.utils.geom.GeometryUtils;

public class BuildingLayer
extends Layer
implements VectorTileLayer.TileLoaderThemeHook,
ZoomLimiter.IZoomLimiter {
    protected static final int BUILDING_LEVEL_HEIGHT = 280;
    public static final int MIN_ZOOM = 17;
    public static boolean POST_AA = false;
    public static boolean RAW_DATA = false;
    public static boolean TRANSLUCENT = true;
    private static final Object BUILDING_DATA = BuildingLayer.class.getName();
    protected java.util.Map<Integer, List<BuildingElement>> mBuildings = new HashMap<Integer, List<BuildingElement>>();
    protected final ExtrusionRenderer mExtrusionRenderer;
    private final ZoomLimiter mZoomLimiter;
    protected final VectorTileLayer mTileLayer;

    public BuildingLayer(Map map, VectorTileLayer tileLayer) {
        this(map, tileLayer, false, false);
    }

    public BuildingLayer(Map map, VectorTileLayer tileLayer, boolean mesh, boolean shadow) {
        this(map, tileLayer, 17, map.viewport().getMaxZoomLevel(), mesh, shadow);
    }

    public BuildingLayer(Map map, VectorTileLayer tileLayer, int zoomMin, int zoomMax, boolean mesh, boolean shadow) {
        super(map);
        this.mTileLayer = tileLayer;
        this.mTileLayer.addHook(this);
        this.mZoomLimiter = new ZoomLimiter(tileLayer.getManager(), zoomMin, zoomMax, zoomMin);
        this.mExtrusionRenderer = new BuildingRenderer(tileLayer.tileRenderer(), this.mZoomLimiter, mesh, TRANSLUCENT);
        this.mRenderer = this.mExtrusionRenderer;
        if (shadow) {
            this.mRenderer = new ShadowRenderer(this.mExtrusionRenderer);
        } else if (POST_AA) {
            this.mRenderer = new OffscreenRenderer(OffscreenRenderer.Mode.SSAO_FXAA, this.mRenderer);
        }
    }

    @Override
    public void addZoomLimit() {
        this.mZoomLimiter.addZoomLimit();
    }

    @Override
    public void removeZoomLimit() {
        this.mZoomLimiter.removeZoomLimit();
    }

    @Override
    public boolean process(MapTile tile, RenderBuckets buckets, MapElement element, RenderStyle style, int level) {
        if (!(style instanceof ExtrusionStyle)) {
            return false;
        }
        if (tile.zoomLevel > this.mZoomLimiter.getZoomLimit()) {
            return false;
        }
        ExtrusionStyle extrusion = (ExtrusionStyle)style.current();
        if (element.isBuilding() || element.isBuildingPart()) {
            List<BuildingElement> buildingElements = this.mBuildings.get(tile.hashCode());
            if (buildingElements == null) {
                buildingElements = new ArrayList<BuildingElement>();
                this.mBuildings.put(tile.hashCode(), buildingElements);
            }
            element = new MapElement(element);
            if (RAW_DATA && element.isClockwise() < 0.0f) {
                element.reverse();
            }
            buildingElements.add(new BuildingElement(element, extrusion));
            return true;
        }
        this.processElement(element, extrusion, tile);
        return true;
    }

    protected void processElement(MapElement element, ExtrusionStyle extrusion, MapTile tile) {
        String v;
        int height = 0;
        int minHeight = 0;
        Float f = element.getHeight(this.mTileLayer.getTheme());
        if (f != null) {
            height = (int)(f.floatValue() * 100.0f);
        } else {
            v = this.getValue(element, "building:levels");
            if (v != null) {
                height = (int)(Float.parseFloat(v) * 280.0f);
            }
        }
        f = element.getMinHeight(this.mTileLayer.getTheme());
        if (f != null) {
            minHeight = (int)(f.floatValue() * 100.0f);
        } else {
            v = this.getValue(element, "building:min_level");
            if (v != null) {
                minHeight = (int)(Float.parseFloat(v) * 280.0f);
            }
        }
        if (height == 0) {
            height = extrusion.defaultHeight * 100;
        }
        ExtrusionBuckets ebs = BuildingLayer.get(tile);
        ebs.addPolyElement(element, tile.getGroundScale(), extrusion.colors, height, minHeight);
    }

    protected void processElements(MapTile tile) {
        if (!this.mBuildings.containsKey(tile.hashCode())) {
            return;
        }
        List<BuildingElement> tileBuildings = this.mBuildings.get(tile.hashCode());
        HashSet<BuildingElement> rootBuildings = new HashSet<BuildingElement>();
        block0: for (BuildingElement partBuilding : tileBuildings) {
            String refId;
            if (!partBuilding.element.isBuildingPart() || (refId = this.getValue(partBuilding.element, "ref")) == null) continue;
            for (BuildingElement rootBuilding : tileBuildings) {
                float[] center;
                if (rootBuilding.element.isBuildingPart() || (RAW_DATA ? !GeometryUtils.pointInPoly((center = GeometryUtils.center(partBuilding.element.points, 0, partBuilding.element.pointNextPos, null))[0], center[1], rootBuilding.element.points, rootBuilding.element.index[0], 0) : !refId.equals(this.getValue(rootBuilding.element, "id")))) continue;
                rootBuildings.add(rootBuilding);
                continue block0;
            }
        }
        tileBuildings.removeAll(rootBuildings);
        for (BuildingElement buildingElement : tileBuildings) {
            this.processElement(buildingElement.element, buildingElement.style, tile);
        }
        this.mBuildings.remove(tile.hashCode());
    }

    public static ExtrusionBuckets get(MapTile tile) {
        ExtrusionBuckets ebs = (ExtrusionBuckets)tile.getData(BUILDING_DATA);
        if (ebs == null) {
            ebs = new ExtrusionBuckets(tile);
            tile.addData(BUILDING_DATA, ebs);
        }
        return ebs;
    }

    public ExtrusionRenderer getExtrusionRenderer() {
        return this.mExtrusionRenderer;
    }

    protected String getKeyOrDefault(String key) {
        if (this.mTileLayer.getTheme() == null) {
            return key;
        }
        String res = this.mTileLayer.getTheme().transformBackwardKey(key);
        return res != null ? res : key;
    }

    protected String getTransformedValue(MapElement element, String key) {
        if (this.mTileLayer.getTheme() == null) {
            return element.tags.getValue(key);
        }
        Tag tsTag = element.tags.get(key = this.getKeyOrDefault(key));
        if (tsTag == null) {
            return null;
        }
        Tag libTag = this.mTileLayer.getTheme().transformForwardTag(tsTag);
        if (libTag != null) {
            return libTag.value;
        }
        return tsTag.value;
    }

    protected String getValue(MapElement element, String key) {
        return element.tags.getValue(this.getKeyOrDefault(key));
    }

    @Override
    public void complete(MapTile tile, boolean success) {
        if (success) {
            this.processElements(tile);
            BuildingLayer.get(tile).prepare();
        } else {
            BuildingLayer.get(tile).resetBuckets(null);
        }
    }

    class BuildingElement {
        MapElement element;
        ExtrusionStyle style;

        BuildingElement(MapElement element, ExtrusionStyle style) {
            this.element = element;
            this.style = style;
        }
    }
}

