/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.layers.tile.buildings;

import java.util.HashSet;
import org.oscim.layers.tile.MapTile;
import org.oscim.layers.tile.TileDistanceSort;
import org.oscim.layers.tile.TileRenderer;
import org.oscim.layers.tile.TileSet;
import org.oscim.layers.tile.ZoomLimiter;
import org.oscim.layers.tile.buildings.BuildingLayer;
import org.oscim.renderer.ExtrusionRenderer;
import org.oscim.renderer.GLViewport;
import org.oscim.renderer.MapRenderer;
import org.oscim.renderer.bucket.ExtrusionBuckets;
import org.oscim.renderer.bucket.RenderBuckets;
import org.oscim.utils.FastMath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BuildingRenderer
extends ExtrusionRenderer {
    static final Logger log = LoggerFactory.getLogger(BuildingRenderer.class);
    private final TileRenderer mTileRenderer;
    private final TileSet mTileSet;
    private final ZoomLimiter mZoomLimiter;
    private final float mFadeInTime = 250.0f;
    private final float mFadeOutTime = 400.0f;
    private long mAnimTime;
    private boolean mShow;

    public BuildingRenderer(TileRenderer tileRenderer, ZoomLimiter zoomLimiter, boolean mesh, boolean translucent) {
        super(mesh, translucent);
        this.mZoomLimiter = zoomLimiter;
        this.mTileRenderer = tileRenderer;
        this.mTileSet = new TileSet();
    }

    @Override
    public boolean setup() {
        this.mAlpha = 0.0f;
        return super.setup();
    }

    @Override
    public void update(GLViewport v) {
        long now;
        super.update(v);
        int diff = v.pos.zoomLevel - this.mZoomLimiter.getMinZoom();
        if (diff < -1) {
            this.mAlpha = 0.0f;
            this.mShow = false;
            this.setReady(false);
            return;
        }
        if (diff >= 0) {
            if (this.mAlpha < 1.0f) {
                now = System.currentTimeMillis();
                if (!this.mShow) {
                    this.mAnimTime = now - (long)(this.mAlpha * 250.0f);
                }
                this.mShow = true;
                this.mAlpha = FastMath.clamp((float)(now - this.mAnimTime) / 250.0f, 0.0f, 1.0f);
                MapRenderer.animate();
            }
        } else if (this.mAlpha > 0.0f) {
            now = System.currentTimeMillis();
            if (this.mShow) {
                this.mAnimTime = now - (long)((1.0f - this.mAlpha) * 400.0f);
            }
            this.mShow = false;
            this.mAlpha = FastMath.clamp(1.0f - (float)(now - this.mAnimTime) / 400.0f, 0.0f, 1.0f);
            MapRenderer.animate();
        }
        if (this.mAlpha == 0.0f) {
            this.setReady(false);
            return;
        }
        Integer zoom = this.mTileRenderer.getVisibleTiles(this.mTileSet, true);
        if (this.mTileSet.cnt == 0 || zoom == null) {
            this.mTileRenderer.releaseTiles(this.mTileSet);
            this.setReady(false);
            return;
        }
        MapTile[] tiles = this.mTileSet.tiles;
        TileDistanceSort.sort(tiles, 0, this.mTileSet.cnt);
        int maxTiles = this.mTileSet.cnt * 4;
        if (this.mExtrusionBucketSet.length < maxTiles) {
            this.mExtrusionBucketSet = new ExtrusionBuckets[maxTiles];
        }
        boolean compiled = false;
        int activeTiles = 0;
        if (zoom >= this.mZoomLimiter.getMinZoom() && zoom <= this.mZoomLimiter.getZoomLimit()) {
            for (int i = 0; i < this.mTileSet.cnt; ++i) {
                ExtrusionBuckets ebs = BuildingRenderer.getBuckets(tiles[i]);
                if (ebs == null) continue;
                if (ebs.compiled) {
                    this.mExtrusionBucketSet[activeTiles++] = ebs;
                    continue;
                }
                if (compiled || !ebs.compile()) continue;
                this.mExtrusionBucketSet[activeTiles++] = ebs;
                compiled = true;
            }
        } else if (zoom > this.mZoomLimiter.getZoomLimit() && zoom <= this.mZoomLimiter.getMaxZoom()) {
            HashSet<MapTile> hashTiles = new HashSet<MapTile>();
            for (int i = 0; i < this.mTileSet.cnt; ++i) {
                ExtrusionBuckets ebs;
                MapTile t = this.mZoomLimiter.getTile(tiles[i]);
                if (t == null || !hashTiles.add(t) || (ebs = BuildingRenderer.getBuckets(t)) == null) continue;
                if (ebs.compiled) {
                    this.mExtrusionBucketSet[activeTiles++] = ebs;
                    continue;
                }
                if (compiled || !ebs.compile()) continue;
                this.mExtrusionBucketSet[activeTiles++] = ebs;
                compiled = true;
            }
        } else if (zoom == this.mZoomLimiter.getMinZoom() - 1) {
            for (int i = 0; i < this.mTileSet.cnt; ++i) {
                MapTile t = tiles[i];
                for (int j = 0; j < 4; j = (int)((byte)(j + 1))) {
                    MapTile c;
                    ExtrusionBuckets eb;
                    if (!t.hasProxy(1 << j) || (eb = BuildingRenderer.getBuckets(c = (MapTile)t.node.child(j))) == null || !eb.compiled) continue;
                    this.mExtrusionBucketSet[activeTiles++] = eb;
                }
            }
        }
        if (compiled) {
            MapRenderer.animate();
        }
        this.mBucketsCnt = activeTiles;
        if (activeTiles == 0) {
            this.mTileRenderer.releaseTiles(this.mTileSet);
            this.setReady(false);
            return;
        }
        this.setReady(true);
    }

    @Override
    public void render(GLViewport v) {
        super.render(v);
        this.mTileRenderer.releaseTiles(this.mTileSet);
    }

    private static ExtrusionBuckets getBuckets(MapTile t) {
        RenderBuckets buckets = t.getBuckets();
        if (buckets != null && !t.state(12)) {
            return null;
        }
        return BuildingLayer.get(t);
    }
}

