/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.layers.tile.vector.labeling;

import org.oscim.core.Tile;
import org.oscim.layers.tile.vector.labeling.LabelTileData;
import org.oscim.renderer.bucket.SymbolItem;
import org.oscim.renderer.bucket.TextItem;
import org.oscim.theme.styles.SymbolStyle;
import org.oscim.theme.styles.TextStyle;
import org.oscim.utils.geom.GeometryUtils;
import org.oscim.utils.geom.LineClipper;

public final class WayDecorator {
    public static void renderSymbol(LineClipper clipper, float[] coordinates, SymbolStyle symbol, int pos, int len, LabelTileData ld) {
        int skipPixels = (int)symbol.repeatStart;
        float previousX = coordinates[pos + 0];
        float previousY = coordinates[pos + 1];
        float theta = 0.0f;
        for (int i = pos; i < pos + len - 2; i += 2) {
            float currentX = coordinates[i + 2];
            float currentY = coordinates[i + 3];
            float diffX = currentX - previousX;
            float diffY = currentY - previousY;
            double segmentLengthInPixel = Math.sqrt(diffX * diffX + diffY * diffY);
            float segmentLengthRemaining = (float)segmentLengthInPixel;
            while (segmentLengthRemaining - (float)skipPixels > symbol.repeatStart) {
                float segmentSkipPercentage = (float)skipPixels / segmentLengthRemaining;
                float x = previousX += diffX * segmentSkipPercentage;
                float y = previousY += diffY * segmentSkipPercentage;
                if (x >= 0.0f && x <= (float)Tile.SIZE && y >= 0.0f && y <= (float)Tile.SIZE) {
                    SymbolItem s = SymbolItem.pool.get();
                    if (symbol.bitmap != null) {
                        s.set(x, y, symbol.bitmap, 0.0f, true);
                    } else {
                        s.set(x, y, symbol.texture, 0.0f, true);
                    }
                    ld.symbols.push(s);
                }
                if (!symbol.repeat) {
                    return;
                }
                diffX = currentX - previousX;
                diffY = currentY - previousY;
                segmentLengthRemaining -= (float)skipPixels;
                skipPixels = (int)symbol.repeatGap;
            }
            if ((float)(skipPixels = (int)((float)skipPixels - segmentLengthRemaining)) < symbol.repeatStart) {
                skipPixels = (int)symbol.repeatStart;
            }
            previousX = currentX;
            previousY = currentY;
        }
    }

    public static void renderText(LineClipper clipper, float[] coordinates, String label, TextStyle text, int pos, int len, LabelTileData ld) {
        TextItem t = null;
        float labelWidth = -1.0f;
        float minWidth = Tile.SIZE / 10;
        for (int i = pos; i < pos + len - 2; i += 2) {
            TextItem n;
            float y2;
            float x2;
            float y1;
            float x1;
            float prevX = coordinates[i + 0];
            float prevY = coordinates[i + 1];
            int edge = 0;
            float curX = coordinates[i + 2];
            float curY = coordinates[i + 3];
            int last = i;
            float vx = prevX - curX;
            float vy = prevY - curY;
            if (vx == 0.0f && vy == 0.0f) continue;
            float a = (float)Math.sqrt(vx * vx + vy * vy);
            if (edge < 16) {
                vx /= a;
                vy /= a;
                for (int j = i + 4; j < pos + len; j += 2) {
                    float ux;
                    float uy;
                    float diff;
                    float nextX = coordinates[j + 0];
                    float nextY = coordinates[j + 1];
                    float wx = nextX - curX;
                    float wy = nextY - curY;
                    if (wx == 0.0f && wy == 0.0f) continue;
                    float area = GeometryUtils.area(prevX, prevY, curX, curY, nextX, nextY);
                    if (area > 1000.0f) break;
                    a = (float)Math.sqrt(wx * wx + wy * wy);
                    if (area / 2.0f > a * a || (double)(diff = (wx /= a) * (uy = vy + (wy /= a)) - wy * (ux = vx + wx)) > 0.1 || (double)diff < -0.1) break;
                    curX = nextX;
                    curY = nextY;
                    last = j - 2;
                }
                vx = curX - prevX;
                vy = curY - prevY;
                a = (float)Math.sqrt(vx * vx + vy * vy);
            }
            float segmentLength = a;
            if (edge == 0) {
                if (segmentLength < minWidth) continue;
                if (labelWidth < 0.0f) {
                    labelWidth = text.paint.measureText(label);
                }
                if ((double)segmentLength < (double)labelWidth * 0.5) {
                    continue;
                }
            } else if (labelWidth < 0.0f) {
                labelWidth = text.paint.measureText(label);
            }
            if (prevX < curX) {
                x1 = prevX;
                y1 = prevY;
                x2 = curX;
                y2 = curY;
            } else {
                x1 = curX;
                y1 = curY;
                x2 = prevX;
                y2 = prevY;
            }
            t = n = TextItem.pool.get();
            t.x = x1 + (x2 - x1) / 2.0f;
            t.y = y1 + (y2 - y1) / 2.0f;
            t.label = label;
            t.text = text;
            t.width = labelWidth;
            t.x1 = x1;
            t.y1 = y1;
            t.x2 = x2;
            t.y2 = y2;
            t.length = (short)segmentLength;
            t.edges = (byte)edge;
            ld.labels.push(t);
            i = last;
        }
    }

    private WayDecorator() {
        throw new IllegalStateException();
    }
}

