/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.renderer;

import org.oscim.backend.CanvasAdapter;
import org.oscim.backend.canvas.Paint;
import org.oscim.core.GeometryBuffer;
import org.oscim.core.Tile;
import org.oscim.renderer.BucketRenderer;
import org.oscim.renderer.GLViewport;
import org.oscim.renderer.bucket.LineBucket;
import org.oscim.renderer.bucket.TextBucket;
import org.oscim.renderer.bucket.TextItem;
import org.oscim.theme.styles.LineStyle;
import org.oscim.theme.styles.RenderStyle;
import org.oscim.theme.styles.TextStyle;

public class GridRenderer
extends BucketRenderer {
    private final TextBucket mTextBucket;
    private final TextStyle mText;
    private final LineBucket mLineBucket;
    private final GeometryBuffer mLines;
    private final StringBuilder mStringBuffer;
    private int mCurX;
    private int mCurY;
    private int mCurZ;

    public GridRenderer() {
        this(CanvasAdapter.getScale());
    }

    public GridRenderer(float scale) {
        this(1, new LineStyle(-7829368, 1.2f * scale, Paint.Cap.BUTT), ((TextStyle.TextBuilder)((RenderStyle.StyleBuilder)((TextStyle.TextBuilder)TextStyle.builder().fontSize(12.0f * scale)).fontStyle(Paint.FontStyle.BOLD)).color(-65536)).build());
    }

    public GridRenderer(int numLines, LineStyle lineStyle, TextStyle textStyle) {
        int size = Tile.SIZE;
        this.mLines = new GeometryBuffer(32, 16);
        float pos = -size * 4;
        for (int i = 0; i < 8 * numLines; ++i) {
            float x = pos + (float)(i * size / numLines);
            this.mLines.startLine();
            this.mLines.addPoint(x, pos);
            this.mLines.addPoint(x, pos + (float)(size * 8));
        }
        for (int j = 0; j < 8 * numLines; ++j) {
            float y = pos + (float)(j * size / numLines);
            this.mLines.startLine();
            this.mLines.addPoint(pos, y);
            this.mLines.addPoint(pos + (float)(size * 8), y);
        }
        this.mText = textStyle;
        this.mLineBucket = new LineBucket(0);
        this.mLineBucket.line = lineStyle;
        if (this.mText != null) {
            this.mTextBucket = new TextBucket();
            this.mTextBucket.next = this.mLineBucket;
        } else {
            this.mTextBucket = null;
            this.mLineBucket.addLine(this.mLines);
            this.buckets.set(this.mLineBucket);
        }
        this.mStringBuffer = new StringBuilder(32);
    }

    private void addLabels(int x, int y, int z) {
        int s = Tile.SIZE;
        TextBucket tl = this.mTextBucket;
        tl.clear();
        StringBuilder sb = this.mStringBuffer;
        for (int yy = -2; yy < 2; ++yy) {
            for (int xx = -2; xx < 2; ++xx) {
                sb.setLength(0);
                sb.append(z).append(" / ").append(x + xx).append(" / ").append(y + yy);
                TextItem ti = TextItem.pool.get();
                ti.set(s * xx + s / 2, s * yy + s / 2, sb.toString(), this.mText);
                tl.addText(ti);
            }
        }
    }

    @Override
    public void update(GLViewport v) {
        int z = 1 << v.pos.zoomLevel;
        int x = (int)(v.pos.x * (double)z);
        int y = (int)(v.pos.y * (double)z);
        if (x == this.mCurX && y == this.mCurY && z == this.mCurZ) {
            return;
        }
        this.mCurX = x;
        this.mCurY = y;
        this.mCurZ = z;
        this.mMapPosition.copy(v.pos);
        this.mMapPosition.x = (double)x / (double)z;
        this.mMapPosition.y = (double)y / (double)z;
        this.mMapPosition.scale = z;
        if (this.mText != null) {
            this.buckets.set(this.mTextBucket);
            this.addLabels(x, y, v.pos.zoomLevel);
            this.mLineBucket.addLine(this.mLines);
            this.buckets.prepare();
            this.setReady(false);
        }
        if (!this.isReady()) {
            this.compile();
        }
    }
}

