/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.renderer.bucket;

import org.oscim.backend.GLAdapter;
import org.oscim.backend.canvas.Paint;
import org.oscim.core.GeometryBuffer;
import org.oscim.core.MercatorProjection;
import org.oscim.renderer.GLShader;
import org.oscim.renderer.GLState;
import org.oscim.renderer.GLUtils;
import org.oscim.renderer.GLViewport;
import org.oscim.renderer.MapRenderer;
import org.oscim.renderer.bucket.RenderBucket;
import org.oscim.renderer.bucket.RenderBuckets;
import org.oscim.renderer.bucket.VertexData;
import org.oscim.theme.styles.LineStyle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LineBucket
extends RenderBucket {
    static final Logger log = LoggerFactory.getLogger(LineBucket.class);
    public static final float DIR_SCALE = 2048.0f;
    private static final float MIN_DIST = 0.125f;
    private static final float BEVEL_MIN = 0.5f;
    private static final int DIR_MASK = -4;
    public LineBucket outlines;
    public LineStyle line;
    public float scale = 1.0f;
    public boolean roundCap;
    private float mMinDist = 0.125f;
    public float heightOffset;
    private int tmin = Integer.MIN_VALUE;
    private int tmax = Integer.MAX_VALUE;

    public LineBucket(int layer) {
        super((byte)0, false, false);
        this.level = layer;
    }

    LineBucket(byte type, boolean indexed, boolean quads) {
        super(type, indexed, quads);
    }

    public void addOutline(LineBucket link) {
        LineBucket l = this.outlines;
        while (l != null) {
            if (link == l) {
                return;
            }
            l = l.outlines;
        }
        link.outlines = this.outlines;
        this.outlines = link;
    }

    public void setExtents(int min, int max) {
        this.tmin = min;
        this.tmax = max;
    }

    public void setDropDistance(float minDist) {
        this.mMinDist = Math.max(minDist, 0.125f);
    }

    public void addLine(GeometryBuffer geom) {
        if (geom.isPoly()) {
            this.addLine(geom.points, geom.index, -1, true);
        } else if (geom.isLine()) {
            this.addLine(geom.points, geom.index, -1, false);
        } else {
            log.debug("geometry must be LINE or POLYGON");
        }
    }

    public void addLine(float[] points, int numPoints, boolean closed) {
        if (numPoints >= 4) {
            this.addLine(points, null, numPoints, closed);
        }
    }

    void addLine(float[] points, int[] index, int numPoints, boolean closed) {
        int n;
        boolean rounded = false;
        boolean squared = false;
        if (this.line.cap == Paint.Cap.ROUND) {
            rounded = true;
        } else if (this.line.cap == Paint.Cap.SQUARE) {
            squared = true;
        }
        if (rounded && index != null) {
            int cnt = 0;
            int i = 0;
            int n2 = index.length;
            while (i < n2 && index[i] >= 0) {
                if (cnt > 400) {
                    rounded = false;
                    break;
                }
                ++i;
                ++cnt;
            }
        }
        this.roundCap = rounded;
        int length = 0;
        if (index == null) {
            n = 1;
            length = numPoints > 0 ? numPoints : points.length;
        } else {
            n = index.length;
        }
        int pos = 0;
        for (int i = 0; i < n; ++i) {
            if (index != null) {
                length = index[i];
            }
            if (length < 0) break;
            int ipos = pos;
            pos += length;
            if (length < 4 || length == 4 && points[ipos] == points[ipos + 2] && points[ipos + 1] == points[ipos + 3]) continue;
            if (length == 6 && points[ipos] == points[ipos + 4] && points[ipos + 1] == points[ipos + 5]) {
                length -= 2;
            }
            this.addLine(this.vertexItems, points, ipos, length, rounded, squared, closed);
        }
    }

    private void addVertex(VertexData vi, float x, float y, float vNextX, float vNextY, float vPrevX, float vPrevY) {
        float uy = vNextY + vPrevY;
        float ux = vNextX + vPrevX;
        double a = uy * vPrevX - ux * vPrevY;
        if (a < 0.01 && a > -0.01) {
            ux = -vPrevY;
            uy = vPrevX;
        } else {
            ux = (float)((double)ux / a);
            uy = (float)((double)uy / a);
        }
        short ox = (short)(x * MapRenderer.COORD_SCALE);
        short oy = (short)(y * MapRenderer.COORD_SCALE);
        int ddx = (int)(ux * 2048.0f);
        int ddy = (int)(uy * 2048.0f);
        vi.add(ox, oy, (short)(0 | ddx & 0xFFFFFFFC), (short)(1 | ddy & 0xFFFFFFFC));
        vi.add(ox, oy, (short)(2 | -ddx & 0xFFFFFFFC), (short)(1 | -ddy & 0xFFFFFFFC));
    }

    private void addLine(VertexData vertices, float[] points, int start, int length, boolean rounded, boolean squared, boolean closed) {
        short dy;
        short dx;
        int ddy;
        int ddx;
        boolean outside;
        this.numVertices += length + (rounded ? 6 : 2) + (closed ? 2 : 0);
        int ipos = start;
        float curX = points[ipos++];
        float curY = points[ipos++];
        float nextX = points[ipos++];
        float nextY = points[ipos++];
        float vPrevX = nextX - curX;
        float vPrevY = nextY - curY;
        double a = (float)Math.sqrt(vPrevX * vPrevX + vPrevY * vPrevY);
        vPrevX = (float)((double)vPrevX / a);
        vPrevY = (float)((double)vPrevY / a);
        float ux = -vPrevY;
        float uy = vPrevX;
        short ox = (short)(curX * MapRenderer.COORD_SCALE);
        short oy = (short)(curY * MapRenderer.COORD_SCALE);
        boolean bl = outside = curX < (float)this.tmin || curX > (float)this.tmax || curY < (float)this.tmin || curY > (float)this.tmax;
        if (rounded && !outside) {
            ddx = (int)((ux - vPrevX) * 2048.0f);
            ddy = (int)((uy - vPrevY) * 2048.0f);
            dx = (short)(0 | ddx & 0xFFFFFFFC);
            dy = (short)(2 | ddy & 0xFFFFFFFC);
            vertices.add(ox, oy, dx, dy);
            vertices.add(ox, oy, dx, dy);
            ddx = (int)(-(ux + vPrevX) * 2048.0f);
            ddy = (int)(-(uy + vPrevY) * 2048.0f);
            vertices.add(ox, oy, (short)(2 | ddx & 0xFFFFFFFC), (short)(2 | ddy & 0xFFFFFFFC));
            ddx = (int)(ux * 2048.0f);
            ddy = (int)(uy * 2048.0f);
            vertices.add(ox, oy, (short)(0 | ddx & 0xFFFFFFFC), (short)(1 | ddy & 0xFFFFFFFC));
            vertices.add(ox, oy, (short)(2 | -ddx & 0xFFFFFFFC), (short)(1 | -ddy & 0xFFFFFFFC));
        } else {
            float tx = vPrevX;
            float ty = vPrevY;
            if (!rounded && !squared) {
                tx = 0.0f;
                ty = 0.0f;
            } else if (rounded) {
                tx = (float)((double)tx * 0.5);
                ty = (float)((double)ty * 0.5);
            }
            if (rounded) {
                this.numVertices -= 2;
            }
            ddx = (int)((ux - tx) * 2048.0f);
            ddy = (int)((uy - ty) * 2048.0f);
            dx = (short)(0 | ddx & 0xFFFFFFFC);
            dy = (short)(1 | ddy & 0xFFFFFFFC);
            vertices.add(ox, oy, dx, dy);
            vertices.add(ox, oy, dx, dy);
            ddx = (int)(-(ux + tx) * 2048.0f);
            ddy = (int)(-(uy + ty) * 2048.0f);
            vertices.add(ox, oy, (short)(2 | ddx & 0xFFFFFFFC), (short)(1 | ddy & 0xFFFFFFFC));
        }
        curX = nextX;
        curY = nextY;
        vPrevX *= -1.0f;
        vPrevY *= -1.0f;
        int end = start + length;
        while (true) {
            if (ipos < end) {
                nextX = points[ipos++];
                nextY = points[ipos++];
            } else {
                if (!closed || ipos >= end + 2) break;
                nextX = points[start];
                nextY = points[start + 1];
                ipos += 2;
            }
            float vNextX = nextX - curX;
            float vNextY = nextY - curY;
            a = Math.sqrt(vNextX * vNextX + vNextY * vNextY);
            if (a < (double)this.mMinDist) {
                this.numVertices -= 2;
                continue;
            }
            double dotp = (vNextX = (float)((double)vNextX / a)) * vPrevX + (vNextY = (float)((double)vNextY / a)) * vPrevY;
            if (dotp > 0.65) {
                float py;
                float px;
                this.numVertices += 2;
                if (dotp > 0.999) {
                    uy = vPrevY + vNextY;
                    ux = vPrevX + vNextX;
                    a = vNextX * uy - vNextY * ux;
                    if (a < 0.1 && a > -0.1) {
                        ux = -vNextY;
                        uy = vNextX;
                    } else {
                        ux = (float)((double)ux / a);
                        uy = (float)((double)uy / a);
                    }
                    px = curX - ux * 0.5f;
                    py = curY - uy * 0.5f;
                    curX += ux * 0.5f;
                    curY += uy * 0.5f;
                } else {
                    px = curX + vPrevX * 0.5f;
                    py = curY + vPrevY * 0.5f;
                    curX += vNextX * 0.5f;
                    curY += vNextY * 0.5f;
                }
                vNextX = curX - px;
                vNextY = curY - py;
                a = Math.sqrt(vNextX * vNextX + vNextY * vNextY);
                vNextX = (float)((double)vNextX / a);
                vNextY = (float)((double)vNextY / a);
                this.addVertex(vertices, px, py, vPrevX, vPrevY, vNextX, vNextY);
                vPrevX = -vNextX;
                vPrevY = -vNextY;
                vNextX = nextX - curX;
                vNextY = nextY - curY;
                a = Math.sqrt(vNextX * vNextX + vNextY * vNextY);
                vNextX = (float)((double)vNextX / a);
                vNextY = (float)((double)vNextY / a);
            }
            this.addVertex(vertices, curX, curY, vPrevX, vPrevY, vNextX, vNextY);
            curX = nextX;
            curY = nextY;
            vPrevX = -vNextX;
            vPrevY = -vNextY;
        }
        ux = vPrevY;
        uy = -vPrevX;
        outside = curX < (float)this.tmin || curX > (float)this.tmax || curY < (float)this.tmin || curY > (float)this.tmax;
        ox = (short)(curX * MapRenderer.COORD_SCALE);
        oy = (short)(curY * MapRenderer.COORD_SCALE);
        if (rounded && !outside) {
            ddx = (int)(ux * 2048.0f);
            ddy = (int)(uy * 2048.0f);
            vertices.add(ox, oy, (short)(0 | ddx & 0xFFFFFFFC), (short)(1 | ddy & 0xFFFFFFFC));
            vertices.add(ox, oy, (short)(2 | -ddx & 0xFFFFFFFC), (short)(1 | -ddy & 0xFFFFFFFC));
            ddx = (int)((ux - vPrevX) * 2048.0f);
            ddy = (int)((uy - vPrevY) * 2048.0f);
            vertices.add(ox, oy, (short)(0 | ddx & 0xFFFFFFFC), (short)(0 | ddy & 0xFFFFFFFC));
            ddx = (int)(-(ux + vPrevX) * 2048.0f);
            ddy = (int)(-(uy + vPrevY) * 2048.0f);
            dx = (short)(2 | ddx & 0xFFFFFFFC);
            dy = (short)(0 | ddy & 0xFFFFFFFC);
        } else {
            if (!rounded && !squared) {
                vPrevX = 0.0f;
                vPrevY = 0.0f;
            } else if (rounded) {
                vPrevX = (float)((double)vPrevX * 0.5);
                vPrevY = (float)((double)vPrevY * 0.5);
            }
            if (rounded) {
                this.numVertices -= 2;
            }
            ddx = (int)((ux - vPrevX) * 2048.0f);
            ddy = (int)((uy - vPrevY) * 2048.0f);
            vertices.add(ox, oy, (short)(0 | ddx & 0xFFFFFFFC), (short)(1 | ddy & 0xFFFFFFFC));
            ddx = (int)(-(ux + vPrevX) * 2048.0f);
            ddy = (int)(-(uy + vPrevY) * 2048.0f);
            dx = (short)(2 | ddx & 0xFFFFFFFC);
            dy = (short)(1 | ddy & 0xFFFFFFFC);
        }
        vertices.add(ox, oy, dx, dy);
        vertices.add(ox, oy, dx, dy);
    }

    public static final class Renderer {
        private static final float COORD_SCALE_BY_DIR_SCALE = MapRenderer.COORD_SCALE / 2048.0f;
        private static final int CAP_THIN = 0;
        private static final int CAP_BUTT = 1;
        private static final int CAP_ROUND = 2;
        private static final int SHADER_FLAT = 1;
        private static final int SHADER_PROJ = 0;
        public static int mTexID;
        private static Shader[] shaders;

        static boolean init() {
            Renderer.shaders[0] = new Shader("line_aa_proj");
            Renderer.shaders[1] = new Shader("line_aa");
            byte[] pixel = new byte[16384];
            for (int x = 0; x < 128; ++x) {
                float xx = x * x;
                for (int y = 0; y < 128; ++y) {
                    float yy = y * y;
                    int color = (int)(Math.sqrt(xx + yy) * 2.0);
                    if (color > 255) {
                        color = 255;
                    }
                    pixel[x + y * 128] = (byte)color;
                }
            }
            mTexID = GLUtils.loadTexture(pixel, 128, 128, 6406, 9728, 9728, 33648, 33648);
            return true;
        }

        public static RenderBucket draw(RenderBucket b, GLViewport v, float scale, RenderBuckets buckets) {
            int mode = v.pos.tilt < 1.0f ? 1 : 0;
            Shader s = shaders[mode];
            s.useProgram();
            GLState.blend(true);
            if (!GLAdapter.GDX_DESKTOP_QUIRKS) {
                GLState.bindTex2D(mTexID);
            }
            int uLineFade = s.uFade;
            int uLineMode = s.uMode;
            int uLineColor = s.uColor;
            int uLineWidth = s.uWidth;
            int uLineHeight = s.uHeight;
            GLAdapter.gl.vertexAttribPointer(s.aPos, 4, 5122, false, 0, buckets.offset[0]);
            v.mvp.setAsUniform(s.uMVP);
            double variableScale = Math.sqrt(scale);
            double pixel = mode == 0 ? 1.0E-4 : 1.5 / (double)scale;
            GLAdapter.gl.uniform1f(uLineFade, (float)pixel);
            int capMode = 0;
            GLAdapter.gl.uniform1i(uLineMode, capMode);
            boolean blur = false;
            float heightOffset = 0.0f;
            GLAdapter.gl.uniform1f(uLineHeight, heightOffset);
            while (b != null && b.type == 0) {
                block30: {
                    double width;
                    LineStyle line;
                    LineBucket lb;
                    block29: {
                        block28: {
                            lb = (LineBucket)b;
                            line = lb.line.current();
                            if (line.heightOffset != lb.heightOffset) {
                                lb.heightOffset = line.heightOffset;
                            }
                            if (lb.heightOffset != heightOffset) {
                                heightOffset = lb.heightOffset;
                                GLAdapter.gl.uniform1f(uLineHeight, heightOffset / MercatorProjection.groundResolution(v.pos));
                            }
                            if (line.fadeScale >= v.pos.zoomLevel) break block28;
                            GLUtils.setColor(uLineColor, line.color, 1.0f);
                            break block29;
                        }
                        if (line.fadeScale > v.pos.zoomLevel) break block30;
                        float alpha = (float)((double)scale > 1.2 ? (double)scale : 1.2) - 1.0f;
                        GLUtils.setColor(uLineColor, line.color, alpha);
                    }
                    if (mode == 0 && blur && line.blur == 0.0f) {
                        GLAdapter.gl.uniform1f(uLineFade, (float)pixel);
                        blur = false;
                    }
                    if (!line.outline) {
                        width = line.fixed ? (double)(Math.max(line.width, 1.0f) / scale) : (double)(lb.scale * line.width) / variableScale;
                        GLAdapter.gl.uniform1f(uLineWidth, (float)(width * (double)COORD_SCALE_BY_DIR_SCALE));
                        if (line.blur > 0.0f) {
                            GLAdapter.gl.uniform1f(uLineFade, line.blur);
                            blur = true;
                        } else if (mode == 1) {
                            GLAdapter.gl.uniform1f(uLineFade, (float)(pixel / width));
                        }
                        if ((double)lb.scale < 1.5) {
                            if (capMode != 0) {
                                capMode = 0;
                                GLAdapter.gl.uniform1i(uLineMode, capMode);
                            }
                        } else if (lb.roundCap) {
                            if (capMode != 2) {
                                capMode = 2;
                                GLAdapter.gl.uniform1i(uLineMode, capMode);
                            }
                        } else if (capMode != 1) {
                            capMode = 1;
                            GLAdapter.gl.uniform1i(uLineMode, capMode);
                        }
                        GLAdapter.gl.drawArrays(5, b.vertexOffset, b.numVertices);
                    } else {
                        LineBucket ref = lb.outlines;
                        while (ref != null) {
                            LineStyle core = ref.line.current();
                            width = core.fixed ? (double)(Math.max(core.width, 1.0f) / scale) : (double)(ref.scale * core.width) / variableScale;
                            width = line.fixed ? (width += (double)(line.width / scale)) : (width += (double)(lb.scale * line.width) / variableScale);
                            GLAdapter.gl.uniform1f(uLineWidth, (float)(width * (double)COORD_SCALE_BY_DIR_SCALE));
                            if (line.blur > 0.0f) {
                                GLAdapter.gl.uniform1f(uLineFade, line.blur);
                                blur = true;
                            } else if (mode == 1) {
                                GLAdapter.gl.uniform1f(uLineFade, (float)(pixel / width));
                            }
                            if (ref.roundCap) {
                                if (capMode != 2) {
                                    capMode = 2;
                                    GLAdapter.gl.uniform1i(uLineMode, capMode);
                                }
                            } else if (capMode != 1) {
                                capMode = 1;
                                GLAdapter.gl.uniform1i(uLineMode, capMode);
                            }
                            GLAdapter.gl.drawArrays(5, ref.vertexOffset, ref.numVertices);
                            ref = ref.outlines;
                        }
                    }
                }
                b = (RenderBucket)b.next;
            }
            return b;
        }

        static {
            shaders = new Shader[]{null, null};
        }
    }

    static class Shader
    extends GLShader {
        int uMVP;
        int uFade;
        int uWidth;
        int uColor;
        int uMode;
        int uHeight;
        int aPos;

        Shader(String shaderFile) {
            if (!this.create(shaderFile)) {
                return;
            }
            this.uMVP = this.getUniform("u_mvp");
            this.uFade = this.getUniform("u_fade");
            this.uWidth = this.getUniform("u_width");
            this.uColor = this.getUniform("u_color");
            this.uMode = this.getUniform("u_mode");
            this.uHeight = this.getUniform("u_height");
            this.aPos = this.getAttrib("a_pos");
        }

        @Override
        public boolean useProgram() {
            if (super.useProgram()) {
                GLState.enableVertexArrays(this.aPos, -1);
                return true;
            }
            return false;
        }
    }
}

