/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.renderer.light;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.oscim.backend.DateTimeAdapter;
import org.oscim.backend.canvas.Color;
import org.oscim.utils.ColorUtil;
import org.oscim.utils.geom.GeometryUtils;
import org.oscim.utils.math.MathUtils;

public class Sun {
    public static float SHADOW_ALPHA = 0.3f;
    private static final DateTimeAdapter date = DateTimeAdapter.instance;
    private float mSunrise;
    private float mSunset;
    private float mLatitude;
    private float mLongitude;
    private int mDayOfYear;
    private float mProgress;
    private float[] mSunPos = new float[3];
    private int mLightColor;
    private Map<Float, Integer> mColorMap;

    public Sun() {
        this.mDayOfYear = date.getDayOfYear();
        this.setCoordinates(0.0f, 0.0f);
        this.mLightColor = Color.get(SHADOW_ALPHA, 255, 255, 255);
        this.setProgress(0.4f);
        this.updatePosition();
    }

    private float declination() {
        return (float)(0.4095 * Math.sin(0.016906 * ((double)this.mDayOfYear - 80.086)));
    }

    private float discrepancyMeanTime() {
        return (float)(-0.171 * Math.sin(0.0337 * (double)this.mDayOfYear + 0.465) - 0.1299 * Math.sin(0.01787 * (double)this.mDayOfYear - 0.168));
    }

    public int getColor() {
        return this.mLightColor;
    }

    public Map<Float, Integer> getColorMap() {
        return this.mColorMap;
    }

    public float getLatitude() {
        return this.mLatitude;
    }

    public float getLongitude() {
        return this.mLongitude;
    }

    public float[] getPosition() {
        return this.mSunPos;
    }

    public float getProgress() {
        return this.mProgress;
    }

    public float getSunrise() {
        return this.mSunrise;
    }

    public float getSunset() {
        return this.mSunset;
    }

    private void initDefaultColorMap() {
        this.mColorMap = new HashMap<Float, Integer>();
        this.mColorMap.put(Float.valueOf(0.0f), Color.get((int)(255.0f * SHADOW_ALPHA), 150, 120, 140));
        this.mColorMap.put(Float.valueOf(0.04f), Color.get((int)(255.0f * SHADOW_ALPHA), 205, 170, 160));
        this.mColorMap.put(Float.valueOf(0.1f), Color.get((int)(255.0f * SHADOW_ALPHA), 245, 240, 215));
        this.mColorMap.put(Float.valueOf(0.2f), Color.get((int)(255.0f * SHADOW_ALPHA), 255, 255, 255));
        this.mColorMap.put(Float.valueOf(0.8f), Color.get((int)(255.0f * SHADOW_ALPHA), 255, 255, 255));
        this.mColorMap.put(Float.valueOf(0.99f), Color.get((int)(255.0f * SHADOW_ALPHA), 255, 220, 230));
        this.mColorMap.put(Float.valueOf(1.0f), Color.get((int)(255.0f * SHADOW_ALPHA), 100, 100, 130));
        this.mColorMap.put(Float.valueOf(1.9f), Color.get((int)(255.0f * SHADOW_ALPHA), 100, 100, 130));
    }

    public void setColor(int color) {
        this.mLightColor = color;
    }

    public void setColorMap(Map<Float, Integer> colorMap) {
        this.mColorMap = colorMap;
    }

    public void setCoordinates(float latitude, float longitude) {
        this.mLatitude = latitude;
        this.mLongitude = longitude;
        this.updateToDay();
    }

    public void setDayOfYear(int day) {
        this.mDayOfYear = day;
    }

    public void setPosition(float x, float y, float z) {
        this.mSunPos[0] = x;
        this.mSunPos[1] = y;
        this.mSunPos[2] = z;
        this.mSunPos = GeometryUtils.normalize(this.mSunPos);
    }

    public void setProgress(float progress) {
        this.mProgress = progress;
    }

    public float setProgress(int hour, int minute, int second) {
        float time = hour;
        time += (float)minute / 60.0f;
        float progress = ((time += (float)second / 3600.0f) - this.mSunrise) / (this.mSunset - this.mSunrise);
        if (progress > 1.0f || progress < 0.0f) {
            progress = (time + 24.0f - this.mSunset) % 24.0f / (this.mSunrise + 24.0f - this.mSunset);
            progress += 1.0f;
        }
        this.mProgress = MathUtils.clamp(progress, 0.0f, 2.0f);
        return this.mProgress;
    }

    private float timeDiff(float h) {
        float lat = this.mLatitude * ((float)Math.PI / 180);
        float declination = this.declination();
        return (float)(12.0 * Math.acos((Math.sin(h) - Math.sin(lat) * Math.sin(declination)) / (Math.cos(lat) * Math.cos(declination))) / Math.PI);
    }

    public void update() {
        this.updateProgress();
        this.updatePosition();
        this.updateColor();
    }

    public int updateColor() {
        float progressEnd;
        if (this.mColorMap == null) {
            this.initDefaultColorMap();
        }
        Iterator<Float> prIter = this.mColorMap.keySet().iterator();
        float progressStart = progressEnd = prIter.next().floatValue();
        while (prIter.hasNext()) {
            float progress = prIter.next().floatValue();
            if ((this.mProgress + 2.0f - progress) % 2.0f < (this.mProgress + 2.0f - progressStart) % 2.0f) {
                progressStart = progress;
                continue;
            }
            if (!((progress + 2.0f - this.mProgress) % 2.0f < (progressEnd + 2.0f - this.mProgress) % 2.0f)) continue;
            progressEnd = progress;
        }
        if (progressStart == progressEnd) {
            this.mLightColor = this.mColorMap.get(Float.valueOf(progressStart));
            return this.mLightColor;
        }
        float fraction = (this.mProgress + 2.0f - progressStart) % 2.0f / ((progressEnd + 2.0f - progressStart) % 2.0f);
        int colorStart = this.mColorMap.get(Float.valueOf(progressStart));
        int colorEnd = this.mColorMap.get(Float.valueOf(progressEnd));
        this.mLightColor = ColorUtil.blend(colorStart, colorEnd, fraction);
        return this.mLightColor;
    }

    public float[] updatePosition() {
        this.mSunPos[0] = (float)Math.cos((double)this.mProgress * Math.PI);
        this.mSunPos[1] = (float)Math.sin((double)this.mProgress * Math.PI);
        this.mSunPos[2] = 3.0f * this.mSunPos[1];
        this.mSunPos = GeometryUtils.normalize(this.mSunPos);
        return this.mSunPos;
    }

    public float updateProgress() {
        return this.setProgress(date.getHour(), date.getMinute(), date.getSecond());
    }

    public void updateToDay() {
        float h = -0.0145f;
        float diff = this.timeDiff(h);
        float discp = this.discrepancyMeanTime();
        float calc = 12.0f - discp - this.mLongitude / 15.0f + (float)date.getTimeZoneOffset() / 3600000.0f;
        this.mSunrise = calc - diff;
        this.mSunset = calc + diff;
    }
}

