/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.tiling;

import org.oscim.backend.CanvasAdapter;
import org.oscim.backend.canvas.Bitmap;
import org.oscim.core.MapElement;
import org.oscim.core.Tile;
import org.oscim.tiling.ITileDataSink;
import org.oscim.tiling.QueryResult;
import org.oscim.utils.geom.TileClipper;
import org.oscim.utils.geom.TileSeparator;

class OverzoomDataSink
implements ITileDataSink {
    private final ITileDataSink sink;
    private final TileClipper clipper;
    private final TileSeparator separator;
    private final float dx;
    private final float dy;
    private final float scale;

    OverzoomDataSink(ITileDataSink sink, Tile overzoomTile, Tile tile) {
        this.sink = sink;
        int diff = tile.zoomLevel - overzoomTile.zoomLevel;
        this.dx = (tile.tileX - (overzoomTile.tileX << diff)) * Tile.SIZE;
        this.dy = (tile.tileY - (overzoomTile.tileY << diff)) * Tile.SIZE;
        this.scale = 1 << diff;
        float buffer = 32.0f * CanvasAdapter.getScale();
        this.clipper = new TileClipper((this.dx - buffer) / this.scale, (this.dy - buffer) / this.scale, (this.dx + (float)Tile.SIZE + buffer) / this.scale, (this.dy + (float)Tile.SIZE + buffer) / this.scale);
        this.separator = new TileSeparator(this.dx / this.scale, this.dy / this.scale, (this.dx + (float)Tile.SIZE) / this.scale, (this.dy + (float)Tile.SIZE) / this.scale);
    }

    @Override
    public void process(MapElement element) {
        if (element.isBuilding() || element.isBuildingPart() || element.isPoint() ? !this.separator.separate(element) : !this.clipper.clip(element)) {
            return;
        }
        element.scale(this.scale, this.scale);
        element.translate(-this.dx, -this.dy);
        this.sink.process(element);
    }

    @Override
    public void setTileImage(Bitmap bitmap) {
        this.sink.setTileImage(bitmap);
    }

    @Override
    public void completed(QueryResult result) {
        this.sink.completed(result);
    }
}

