/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.tiling;

import org.oscim.layers.tile.MapTile;
import org.oscim.tiling.ITileDataSink;
import org.oscim.tiling.ITileDataSource;
import org.oscim.tiling.OverzoomDataSink;

public class OverzoomTileDataSource
implements ITileDataSource {
    private final ITileDataSource tileDataSource;
    private final int overZoom;

    public OverzoomTileDataSource(ITileDataSource tileDataSource, int overZoom) {
        this.tileDataSource = tileDataSource;
        this.overZoom = overZoom;
    }

    public ITileDataSource getDataSource() {
        return this.tileDataSource;
    }

    @Override
    public void query(MapTile tile, ITileDataSink sink) {
        MapTile mapTile = tile;
        ITileDataSink dataSink = sink;
        int diff = tile.zoomLevel - this.overZoom;
        if (diff > 0) {
            mapTile = new MapTile(tile.node, tile.tileX >> diff, tile.tileY >> diff, this.overZoom);
            dataSink = new OverzoomDataSink(sink, mapTile, tile);
        }
        this.tileDataSource.query(mapTile, dataSink);
    }

    @Override
    public void dispose() {
        this.tileDataSource.dispose();
    }

    @Override
    public void cancel() {
        this.tileDataSource.cancel();
    }
}

