/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.tiling.source.mapfile;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.oscim.core.BoundingBox;
import org.oscim.tiling.ITileDataSource;
import org.oscim.tiling.OverzoomTileDataSource;
import org.oscim.tiling.TileSource;
import org.oscim.tiling.source.mapfile.IMapFileTileSource;
import org.oscim.tiling.source.mapfile.MapDatabase;
import org.oscim.tiling.source.mapfile.MapFileTileSource;
import org.oscim.tiling.source.mapfile.MultiMapDatabase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiMapFileTileSource
extends TileSource
implements IMapFileTileSource {
    private static final Logger log = LoggerFactory.getLogger(MultiMapFileTileSource.class);
    private final List<MapFileTileSource> mapFileTileSources = new ArrayList<MapFileTileSource>();
    private final Map<MapFileTileSource, int[]> zoomsByTileSource = new HashMap<MapFileTileSource, int[]>();

    public MultiMapFileTileSource() {
        this(2, 20);
    }

    public MultiMapFileTileSource(int zoomMin, int zoomMax) {
        this(zoomMin, zoomMax, 17);
    }

    public MultiMapFileTileSource(int zoomMin, int zoomMax, int overZoom) {
        super(zoomMin, zoomMax, overZoom);
    }

    public boolean add(MapFileTileSource mapFileTileSource) {
        if (this.mapFileTileSources.contains(mapFileTileSource)) {
            throw new IllegalArgumentException("Duplicate map file tile source");
        }
        return this.mapFileTileSources.add(mapFileTileSource);
    }

    public boolean add(MapFileTileSource mapFileTileSource, int zoomMin, int zoomMax) {
        boolean result = this.add(mapFileTileSource);
        if (result) {
            this.zoomsByTileSource.put(mapFileTileSource, new int[]{zoomMin, zoomMax});
        }
        return result;
    }

    public BoundingBox getBoundingBox() {
        BoundingBox boundingBox = null;
        for (MapFileTileSource mapFileTileSource : this.mapFileTileSources) {
            boundingBox = boundingBox == null ? mapFileTileSource.getMapInfo().boundingBox : boundingBox.extendBoundingBox(mapFileTileSource.getMapInfo().boundingBox);
        }
        return boundingBox;
    }

    @Override
    public ITileDataSource getDataSource() {
        MultiMapDatabase multiMapDatabase = new MultiMapDatabase();
        for (MapFileTileSource mapFileTileSource : this.mapFileTileSources) {
            try {
                MapDatabase mapDatabase = new MapDatabase(mapFileTileSource);
                int[] zoomLevels = this.zoomsByTileSource.get(mapFileTileSource);
                if (zoomLevels != null) {
                    mapDatabase.restrictToZoomRange(zoomLevels[0], zoomLevels[1]);
                }
                multiMapDatabase.add(mapDatabase);
            }
            catch (IOException e) {
                log.debug(e.getMessage());
            }
        }
        return new OverzoomTileDataSource(multiMapDatabase, this.mOverZoom);
    }

    @Override
    public TileSource.OpenResult open() {
        TileSource.OpenResult openResult = TileSource.OpenResult.SUCCESS;
        for (MapFileTileSource mapFileTileSource : this.mapFileTileSources) {
            TileSource.OpenResult result = mapFileTileSource.open();
            if (result == TileSource.OpenResult.SUCCESS) continue;
            openResult = result;
        }
        return openResult;
    }

    @Override
    public void close() {
        for (MapFileTileSource mapFileTileSource : this.mapFileTileSources) {
            mapFileTileSource.close();
        }
    }

    @Override
    public void setCallback(MapFileTileSource.Callback callback) {
        for (MapFileTileSource mapFileTileSource : this.mapFileTileSources) {
            mapFileTileSource.setCallback(callback);
        }
    }

    @Override
    public void setPreferredLanguage(String preferredLanguage) {
        for (MapFileTileSource mapFileTileSource : this.mapFileTileSources) {
            mapFileTileSource.setPreferredLanguage(preferredLanguage);
        }
    }
}

