/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.utils.geom;

import org.oscim.core.GeometryBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TileSeparator {
    private static final Logger log = LoggerFactory.getLogger(TileSeparator.class);
    private float xmin;
    private float xmax;
    private float ymin;
    private float ymax;

    public TileSeparator(float xmin, float ymin, float xmax, float ymax) {
        this.xmin = xmin;
        this.ymin = ymin;
        this.xmax = xmax;
        this.ymax = ymax;
    }

    private boolean isInside(float cx, float cy) {
        return cx >= this.xmin && cx < this.xmax && cy >= this.ymin && cy < this.ymax;
    }

    public void setRect(float xmin, float ymin, float xmax, float ymax) {
        this.xmin = xmin;
        this.ymin = ymin;
        this.xmax = xmax;
        this.ymax = ymax;
    }

    public boolean separate(GeometryBuffer geom) {
        if (geom.isPoint()) {
            if (geom.index.length > 1 && geom.index[0] == 2) {
                float cx = geom.points[0];
                float cy = geom.points[1];
                if (this.isInside(cx, cy)) {
                    return true;
                }
            } else {
                log.warn("Geometry (Point) has wrong format: " + geom.toString());
            }
        } else if (geom.isPoly()) {
            int pointPos = 0;
            for (int len : geom.index) {
                if (len < 0) break;
                if (len < 6) {
                    pointPos += len;
                    continue;
                }
                int end = pointPos + len;
                int i = pointPos;
                while (i < end) {
                    float cy;
                    float cx;
                    if (!this.isInside(cx = geom.points[i++], cy = geom.points[i++])) continue;
                    return true;
                }
                pointPos += len;
            }
        }
        return false;
    }
}

