/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.layers.marker;

import org.oscim.backend.canvas.Bitmap;
import org.oscim.core.MercatorProjection;
import org.oscim.core.PointF;
import org.oscim.core.Tile;
import org.oscim.layers.marker.InternalItem;
import org.oscim.layers.marker.MarkerItem;
import org.oscim.layers.marker.MarkerLayer;
import org.oscim.layers.marker.MarkerRenderer;
import org.oscim.layers.marker.MarkerRendererFactory;
import org.oscim.layers.marker.MarkerSymbol;
import org.oscim.layers.marker.utils.ScreenUtils;
import org.oscim.layers.marker.utils.SparseIntArray;
import org.oscim.renderer.GLViewport;
import org.oscim.renderer.bucket.SymbolItem;
import org.oscim.utils.FastMath;
import org.oscim.utils.geom.GeometryUtils;

public class ClusterMarkerRenderer
extends MarkerRenderer {
    protected static final int CLUSTER_MAXSIZE = 10;
    private static int CLUSTER_COLORTEXT = -8388416;
    private static final int CLUSTER_COLORBACK = -1;
    protected static final int MAP_MARKER_CLUSTER_SIZE_DP = 64;
    private static final int MAP_GRID_SIZE_DP = 64;
    protected static Bitmap[] mClusterBitmaps = new Bitmap[11];
    protected int mStyleBackground = -1;
    protected int mStyleForeground = CLUSTER_COLORTEXT;
    private int mScalePow = 0;
    private double mClusterScale = 0.0;
    private SparseIntArray mGridMap = new SparseIntArray(200);
    private boolean mClusteringEnabled = false;

    public ClusterMarkerRenderer(MarkerLayer markerLayer, MarkerSymbol defaultSymbol, ClusterStyle style) {
        super(markerLayer, defaultSymbol);
        boolean bl = this.mClusteringEnabled = style != null;
        if (this.mClusteringEnabled) {
            this.setClusterStyle(style.foreground, style.background);
            for (int k = 0; k <= 10; ++k) {
                this.getClusterBitmap(k);
            }
        }
    }

    private void setClusterStyle(int foregroundColor, int backgroundColor) {
        this.mStyleBackground = backgroundColor;
        this.mStyleForeground = foregroundColor;
    }

    @Override
    protected void populate(int size) {
        this.repopulateCluster(size, this.mClusterScale);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void repopulateCluster(int size, double scale) {
        int GRIDSIZE = ScreenUtils.getPixels(64.0f);
        double factor = scale / (double)GRIDSIZE;
        InternalItem.Clustered[] tmp = new InternalItem.Clustered[size];
        this.mGridMap.clear();
        for (int i = 0; i < size; ++i) {
            InternalItem.Clustered it = tmp[i] = new InternalItem.Clustered();
            it.item = this.mMarkerLayer.createItem(i);
            MercatorProjection.project(it.item.getPoint(), this.mMapPoint);
            it.px = this.mMapPoint.x;
            it.py = this.mMapPoint.y;
            if (it.item instanceof MarkerItem.NonClusterable) continue;
            int absposx = (int)(it.px * factor);
            int absposy = (int)(it.py * factor);
            int maxcols = (int)factor;
            int itemGridIndex = absposx + absposy * maxcols;
            int storedIndexInGridSlot = this.mGridMap.get(itemGridIndex, -1);
            if (storedIndexInGridSlot == -1) {
                this.mGridMap.put(itemGridIndex, i);
                continue;
            }
            it.clusteredOut = true;
            ++tmp[storedIndexInGridSlot].clusterSize;
        }
        ClusterMarkerRenderer clusterMarkerRenderer = this;
        synchronized (clusterMarkerRenderer) {
            this.mUpdate = true;
            this.mItems = tmp;
        }
    }

    @Override
    public synchronized void update(GLViewport v) {
        InternalItem.Clustered it;
        int scalePow;
        final double scale = (double)Tile.SIZE * v.pos.scale;
        if (this.mClusteringEnabled && (scalePow = FastMath.log2((int)scale)) != this.mScalePow) {
            this.mScalePow = scalePow;
            this.mClusterScale = scale;
            this.mMarkerLayer.map().post(new Runnable(){

                @Override
                public void run() {
                    ClusterMarkerRenderer.this.repopulateCluster(ClusterMarkerRenderer.this.mItems.length, scale);
                }
            });
            return;
        }
        if (!v.changed() && !this.mUpdate) {
            return;
        }
        this.mUpdate = false;
        double mx = v.pos.x;
        double my = v.pos.y;
        int numVisible = 0;
        this.mMarkerLayer.map().viewport().getMapExtents(this.mBox, Tile.SIZE / 2);
        long flip = (long)((double)Tile.SIZE * v.pos.scale) >> 1;
        if (this.mItems == null) {
            if (this.buckets.get() != null) {
                this.buckets.clear();
                this.compile();
            }
            return;
        }
        double angle = Math.toRadians(v.pos.bearing);
        float cos = (float)Math.cos(angle);
        float sin = (float)Math.sin(angle);
        for (InternalItem itm : this.mItems) {
            it = (InternalItem.Clustered)itm;
            it.changes = false;
            it.x = (float)((it.px - mx) * scale);
            it.y = (float)((it.py - my) * scale);
            if (it.x > (float)flip) {
                it.x -= (float)(flip << 1);
            } else if (it.x < (float)(-flip)) {
                it.x += (float)(flip << 1);
            }
            if (it.clusteredOut || !GeometryUtils.pointInPoly(it.x, it.y, this.mBox, 8, 0)) {
                if (!it.visible || it.clusteredOut) continue;
                it.changes = true;
                continue;
            }
            it.dy = sin * it.x + cos * it.y;
            if (!it.visible) {
                it.visible = true;
            }
            ++numVisible;
        }
        this.buckets.clear();
        if (numVisible == 0) {
            this.compile();
            return;
        }
        this.mMapPosition.copy(v.pos);
        this.mMapPosition.bearing = -this.mMapPosition.bearing;
        this.sort(this.mItems, 0, this.mItems.length);
        for (InternalItem itm : this.mItems) {
            it = (InternalItem.Clustered)itm;
            if (!it.visible || it.clusteredOut) continue;
            if (it.changes) {
                it.visible = false;
                continue;
            }
            SymbolItem s = SymbolItem.pool.get();
            if (it.clusterSize > 0) {
                Bitmap bitmap = this.getClusterBitmap(it.clusterSize + 1);
                s.set(it.x, it.y, bitmap, true);
                s.offset = new PointF(0.5f, 0.5f);
                s.billboard = true;
            } else {
                MarkerSymbol symbol = it.item.getMarker();
                if (symbol == null) {
                    symbol = this.mDefaultMarker;
                }
                s.set(it.x, it.y, symbol.getBitmap(), true);
                s.offset = symbol.getHotspot();
                s.billboard = symbol.isBillboard();
            }
            this.mSymbolLayer.pushSymbol(s);
        }
        this.buckets.set(this.mSymbolLayer);
        this.buckets.prepare();
        this.compile();
    }

    protected Bitmap getClusterBitmap(int size) {
        String strValue;
        if (size >= 10) {
            size = 10;
            strValue = "+";
        } else {
            strValue = String.valueOf(size);
        }
        if (mClusterBitmaps[size] != null) {
            return mClusterBitmaps[size];
        }
        ScreenUtils.ClusterDrawable drawable = new ScreenUtils.ClusterDrawable(54 + size, this.mStyleForeground, this.mStyleBackground, strValue);
        ClusterMarkerRenderer.mClusterBitmaps[size] = drawable.getBitmap();
        return mClusterBitmaps[size];
    }

    public static MarkerRendererFactory factory(final MarkerSymbol defaultSymbol, final ClusterStyle style) {
        return new MarkerRendererFactory(){

            @Override
            public MarkerRenderer create(MarkerLayer markerLayer) {
                return new ClusterMarkerRenderer(markerLayer, defaultSymbol, style);
            }
        };
    }

    public static class ClusterStyle {
        final int background;
        final int foreground;

        public ClusterStyle(int fore, int back) {
            this.foreground = fore;
            this.background = back;
        }
    }
}

