/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.layers.tile;

import org.oscim.layers.tile.MapTile;
import org.oscim.layers.tile.TileManager;

public class ZoomLimiter {
    private final int mMinZoom;
    private final int mMaxZoom;
    private final TileManager mTileManager;
    private final int mZoomLimit;

    public ZoomLimiter(TileManager tileManager, int minZoom, int maxZoom, int zoomLimit) {
        if (zoomLimit < minZoom || zoomLimit > maxZoom) {
            throw new IllegalArgumentException("Zoom limit is out of range");
        }
        this.mTileManager = tileManager;
        this.mMinZoom = minZoom;
        this.mMaxZoom = maxZoom;
        this.mZoomLimit = zoomLimit;
    }

    public void addZoomLimit() {
        if (this.mZoomLimit < this.mMaxZoom) {
            this.mTileManager.addZoomLimit(this.mZoomLimit);
        }
    }

    public int getMaxZoom() {
        return this.mMaxZoom;
    }

    public int getMinZoom() {
        return this.mMinZoom;
    }

    public MapTile getTile(MapTile t) {
        if (t.zoomLevel > this.mZoomLimit && t.zoomLevel <= this.mMaxZoom) {
            int diff = t.zoomLevel - this.mZoomLimit;
            return this.mTileManager.getTile(t.tileX >> diff, t.tileY >> diff, this.mZoomLimit);
        }
        return t;
    }

    public TileManager getTileManager() {
        return this.mTileManager;
    }

    public int getZoomLimit() {
        return this.mZoomLimit;
    }

    public void removeZoomLimit() {
        if (this.mZoomLimit < this.mMaxZoom) {
            this.mTileManager.removeZoomLimit(this.mZoomLimit);
        }
    }

    public static interface IZoomLimiter {
        public void addZoomLimit();

        public void removeZoomLimit();
    }
}

