/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.layers.tile.buildings;

import java.util.HashSet;
import java.util.List;
import org.oscim.backend.canvas.Color;
import org.oscim.core.Box;
import org.oscim.core.GeometryBuffer;
import org.oscim.core.MapElement;
import org.oscim.core.Tag;
import org.oscim.core.TagSet;
import org.oscim.core.Tile;
import org.oscim.layers.tile.MapTile;
import org.oscim.layers.tile.buildings.BuildingLayer;
import org.oscim.layers.tile.buildings.S3DBUtils;
import org.oscim.layers.tile.vector.VectorTileLayer;
import org.oscim.map.Map;
import org.oscim.renderer.MapRenderer;
import org.oscim.theme.styles.ExtrusionStyle;
import org.oscim.utils.ExtrusionUtils;
import org.oscim.utils.geom.GeometryUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class S3DBLayer
extends BuildingLayer {
    private static final Logger log = LoggerFactory.getLogger(S3DBLayer.class);
    private final float TILE_SCALE = 4096.0f / ((float)Tile.SIZE * MapRenderer.COORD_SCALE);
    private boolean mColored = true;
    private boolean mTransparent = true;

    public S3DBLayer(Map map, VectorTileLayer tileLayer) {
        this(map, tileLayer, false);
    }

    public S3DBLayer(Map map, VectorTileLayer tileLayer, boolean shadow) {
        this(map, tileLayer, 17, map.viewport().getMaxZoomLevel(), shadow);
    }

    public S3DBLayer(Map map, VectorTileLayer tileLayer, int zoomMin, int zoomMax, boolean shadow) {
        super(map, tileLayer, zoomMin, zoomMax, true, shadow);
    }

    public boolean isColored() {
        return this.mColored;
    }

    public void setColored(boolean colored) {
        this.mColored = colored;
    }

    public boolean isTransparent() {
        return this.mTransparent;
    }

    public void setTransparent(boolean transparent) {
        this.mTransparent = transparent;
    }

    @Override
    public void complete(MapTile tile, boolean success) {
        super.complete(tile, success);
    }

    @Override
    public void processElement(MapElement element, ExtrusionStyle extrusion, MapTile tile) {
        float groundScale = tile.getGroundScale();
        int maxHeight = 0;
        int minHeight = 0;
        int roofHeight = 0;
        String v = this.getValue(element, "roof:height");
        if (v != null) {
            roofHeight = (int)(Float.parseFloat(v) * 100.0f);
        } else {
            v = this.getValue(element, "roof:levels");
            if (v != null) {
                roofHeight = (int)(Float.parseFloat(v) * 280.0f);
            } else {
                v = this.getValue(element, "roof:angle");
                if (v != null) {
                    Box bb = null;
                    for (int k = 0; k < element.index[0]; k += 2) {
                        float p1 = element.points[k];
                        float p2 = element.points[k + 1];
                        if (bb == null) {
                            bb = new Box(p1, p2);
                            continue;
                        }
                        bb.add(p1, p2);
                    }
                    if (bb != null) {
                        float minSize = (float)((int)Math.min(bb.getHeight(), bb.getWidth())) * groundScale;
                        roofHeight = (int)(Float.parseFloat(v) / 45.0f * (minSize * 40.0f));
                    }
                } else {
                    v = this.getValue(element, "roof:shape");
                    if (v != null && !v.equals("flat")) {
                        roofHeight = 560;
                    }
                }
            }
        }
        v = this.getValue(element, "height");
        if (v != null) {
            maxHeight = (int)(Float.parseFloat(v) * 100.0f);
        } else {
            v = this.getValue(element, "building:levels");
            if (v != null) {
                maxHeight = (int)(Float.parseFloat(v) * 280.0f);
                maxHeight += roofHeight;
            }
        }
        if (maxHeight == 0) {
            maxHeight = extrusion.defaultHeight * 100;
        }
        if ((v = this.getValue(element, "min_height")) != null) {
            minHeight = (int)(Float.parseFloat(v) * 100.0f);
        } else {
            v = this.getValue(element, "building:min_level");
            if (v != null) {
                minHeight = (int)(Float.parseFloat(v) * 280.0f);
            }
        }
        Integer bColor = null;
        if (this.mColored) {
            v = this.getTransformedValue(element, "building:colour");
            if (v != null) {
                bColor = S3DBUtils.getColor(v, extrusion.hsv, false);
            } else {
                v = this.getTransformedValue(element, "building:material");
                if (v != null) {
                    bColor = S3DBUtils.getMaterialColor(v, extrusion.hsv, false);
                }
            }
        }
        if (bColor == null) {
            bColor = extrusion.colorSide;
        } else if (this.mTransparent) {
            bColor = ExtrusionStyle.blendAlpha(bColor, Color.aToFloat(extrusion.colorSide));
        }
        ExtrusionUtils.mapPolyCoordScale(element);
        float minHeightS = ExtrusionUtils.mapGroundScale(minHeight, groundScale) * this.TILE_SCALE;
        float maxHeightS = ExtrusionUtils.mapGroundScale(maxHeight, groundScale) * this.TILE_SCALE;
        float minRoofHeightS = ExtrusionUtils.mapGroundScale(maxHeight - roofHeight, groundScale) * this.TILE_SCALE;
        this.processRoof(element, tile, minRoofHeightS, maxHeightS, bColor, extrusion);
        if (S3DBUtils.calcOutlines(element, minHeightS, minRoofHeightS)) {
            S3DBLayer.get(tile).addMeshElement(element, groundScale, bColor);
        }
    }

    @Override
    protected void processElements(MapTile tile) {
        if (!this.mBuildings.containsKey(tile.hashCode())) {
            return;
        }
        List tileBuildings = (List)this.mBuildings.get(tile.hashCode());
        HashSet<BuildingLayer.BuildingElement> rootBuildings = new HashSet<BuildingLayer.BuildingElement>();
        block0: for (BuildingLayer.BuildingElement partBuilding : tileBuildings) {
            if (!partBuilding.element.isBuildingPart()) continue;
            String refId = this.getValue(partBuilding.element, "ref");
            if (!RAW_DATA && refId == null) continue;
            TagSet partTags = partBuilding.element.tags;
            for (BuildingLayer.BuildingElement rootBuilding : tileBuildings) {
                float[] center;
                if (rootBuilding.element.isBuildingPart() || (!RAW_DATA ? !refId.equals(rootBuilding.element.tags.getValue("id")) : !GeometryUtils.pointInPoly((center = GeometryUtils.center(partBuilding.element.points, 0, partBuilding.element.pointNextPos, null))[0], center[1], rootBuilding.element.points, rootBuilding.element.index[0], 0))) continue;
                if (this.getValue(rootBuilding.element, "roof:shape") != null && this.getValue(partBuilding.element, "roof:shape") == null) {
                    partBuilding.element.tags.add(rootBuilding.element.tags.get(this.getKeyOrDefault("roof:shape")));
                }
                if (this.mColored) {
                    TagSet rootTags = rootBuilding.element.tags;
                    for (int i = 0; i < rootTags.size(); ++i) {
                        Tag rTag = rootTags.get(i);
                        if ((!rTag.key.equals(this.getKeyOrDefault("building:colour")) || partTags.containsKey(this.getKeyOrDefault("building:material"))) && (!rTag.key.equals(this.getKeyOrDefault("roof:colour")) || partTags.containsKey(this.getKeyOrDefault("roof:material"))) || partTags.containsKey(rTag.key)) continue;
                        partTags.add(rTag);
                    }
                }
                rootBuildings.add(rootBuilding);
                continue block0;
            }
        }
        tileBuildings.removeAll(rootBuildings);
        for (BuildingLayer.BuildingElement buildingElement : tileBuildings) {
            this.processElement(buildingElement.element, buildingElement.style, tile);
        }
        this.mBuildings.remove(tile.hashCode());
    }

    private void processRoof(MapElement element, MapTile tile, float minHeight, float maxHeight, int buildingColor, ExtrusionStyle extrusion) {
        boolean success;
        String v;
        int roofColor = extrusion.colorTop;
        if (this.mColored) {
            v = this.getTransformedValue(element, "roof:colour");
            if (v != null) {
                roofColor = S3DBUtils.getColor(v, extrusion.hsv, false);
            } else {
                v = this.getTransformedValue(element, "roof:material");
                if (v != null) {
                    roofColor = S3DBUtils.getMaterialColor(v, extrusion.hsv, false);
                }
            }
        }
        boolean roofOrientationAcross = false;
        v = this.getValue(element, "roof:orientation");
        if (v != null && v.equals("across")) {
            roofOrientationAcross = true;
        }
        if ((v = this.getValue(element, "roof:shape")) == null) {
            v = "flat";
        }
        float groundScale = tile.getGroundScale();
        GeometryBuffer gElement = new GeometryBuffer(element);
        GeometryBuffer specialParts = null;
        if (this.mTransparent) {
            roofColor = ExtrusionStyle.blendAlpha(roofColor, Color.aToFloat(extrusion.colorTop));
        }
        switch (v) {
            case "dome": 
            case "onion": {
                success = S3DBUtils.calcCircleMesh(gElement, minHeight, maxHeight, v);
                break;
            }
            case "round": 
            case "saltbox": 
            case "gabled": 
            case "gambrel": {
                specialParts = new GeometryBuffer(0, 0);
                success = S3DBUtils.calcRidgeMesh(gElement, minHeight, maxHeight, roofOrientationAcross, v, specialParts);
                break;
            }
            case "mansard": 
            case "half_hipped": 
            case "hipped": {
                success = S3DBUtils.calcRidgeMesh(gElement, minHeight, maxHeight, roofOrientationAcross, v, null);
                break;
            }
            case "skillion": {
                String roofDirection = element.tags.getValue("roof:direction");
                float roofDegree = 0.0f;
                if (roofDirection != null) {
                    roofDegree = Float.parseFloat(roofDirection);
                }
                specialParts = new GeometryBuffer(element);
                success = S3DBUtils.calcSkillionMesh(gElement, minHeight, maxHeight, roofDegree, specialParts);
                break;
            }
            case "pyramidal": {
                success = S3DBUtils.calcPyramidalMesh(gElement, minHeight, maxHeight);
                break;
            }
            default: {
                success = S3DBUtils.calcFlatMesh(gElement, minHeight);
            }
        }
        if (success) {
            S3DBLayer.get(tile).addMeshElement(gElement, groundScale, roofColor);
            if (specialParts != null) {
                S3DBLayer.get(tile).addMeshElement(specialParts, groundScale, buildingColor);
            }
        } else {
            log.debug("Roof calculation failed: " + element.toString());
        }
    }
}

