/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.layers.tile.vector;

import org.oscim.core.MapElement;
import org.oscim.layers.tile.MapTile;
import org.oscim.layers.tile.TileLayer;
import org.oscim.layers.tile.TileLoader;
import org.oscim.layers.tile.TileManager;
import org.oscim.layers.tile.VectorTileRenderer;
import org.oscim.layers.tile.vector.VectorTileLoader;
import org.oscim.map.Map;
import org.oscim.renderer.bucket.RenderBuckets;
import org.oscim.theme.IRenderTheme;
import org.oscim.theme.styles.RenderStyle;
import org.oscim.tiling.TileSource;
import org.oscim.utils.pool.Inlist;
import org.oscim.utils.pool.LList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VectorTileLayer
extends TileLayer {
    static final Logger log = LoggerFactory.getLogger(VectorTileLayer.class);
    protected TileSource mTileSource;
    private IRenderTheme mTheme;
    private Inlist.List<LList<TileLoaderProcessHook>> mLoaderProcessHooks = new Inlist.List();
    private Inlist.List<LList<TileLoaderThemeHook>> mLoaderThemeHooks = new Inlist.List();

    public VectorTileLayer(Map map, TileSource tileSource) {
        this(map, new TileManager(map, 100), new VectorTileRenderer());
        this.setTileSource(tileSource);
    }

    public VectorTileLayer(Map map, int cacheLimit) {
        this(map, new TileManager(map, cacheLimit), new VectorTileRenderer());
    }

    public VectorTileLayer(Map map, TileManager tileManager, VectorTileRenderer renderer) {
        super(map, tileManager, renderer);
        this.initLoader(this.getNumLoaders());
    }

    @Override
    protected TileLoader createLoader() {
        return new VectorTileLoader(this);
    }

    public boolean setTileSource(TileSource tileSource) {
        TileSource.OpenResult msg;
        this.pauseLoaders(true);
        this.mTileManager.clearJobs();
        if (this.mTileSource != null) {
            this.mTileSource.close();
            this.mTileSource = null;
        }
        if ((msg = tileSource.open()) != TileSource.OpenResult.SUCCESS) {
            log.debug(msg.getErrorMessage());
            return false;
        }
        this.mTileSource = tileSource;
        this.mTileManager.setZoomLevel(tileSource.getZoomLevelMin(), tileSource.getZoomLevelMax());
        for (TileLoader l : this.mTileLoader) {
            ((VectorTileLoader)l).setDataSource(tileSource.getDataSource());
        }
        this.mMap.clearMap();
        this.resumeLoaders();
        return true;
    }

    public TileSource getTileSource() {
        return this.mTileSource;
    }

    public void setRenderTheme(IRenderTheme theme) {
        this.pauseLoaders(true);
        this.mTileManager.clearJobs();
        this.mTheme = theme;
        this.tileRenderer().setOverdrawColor(theme.getMapBackground());
        this.resumeLoaders();
    }

    public IRenderTheme getTheme() {
        return this.mTheme;
    }

    public void addHook(TileLoaderProcessHook h) {
        this.mLoaderProcessHooks.append(new LList<TileLoaderProcessHook>(h));
    }

    public void addHook(TileLoaderThemeHook h) {
        this.mLoaderThemeHooks.append(new LList<TileLoaderThemeHook>(h));
    }

    @Override
    public void onDetach() {
        super.onDetach();
        if (this.mTileSource != null) {
            this.mTileSource.close();
        }
    }

    public void callThemeHooks(MapTile tile, RenderBuckets layers, MapElement element, RenderStyle style, int level) {
        LList th = this.mLoaderThemeHooks.head();
        while (th != null) {
            if (((TileLoaderThemeHook)th.data).process(tile, layers, element, style, level)) {
                return;
            }
            th = (LList)th.next;
        }
    }

    public boolean callProcessHooks(MapTile tile, RenderBuckets layers, MapElement element) {
        LList ph = this.mLoaderProcessHooks.head();
        while (ph != null) {
            if (((TileLoaderProcessHook)ph.data).process(tile, layers, element)) {
                return true;
            }
            ph = (LList)ph.next;
        }
        return false;
    }

    public void callHooksComplete(MapTile tile, boolean success) {
        LList th = this.mLoaderThemeHooks.head();
        while (th != null) {
            ((TileLoaderThemeHook)th.data).complete(tile, success);
            th = (LList)th.next;
        }
        LList ph = this.mLoaderProcessHooks.head();
        while (ph != null) {
            ((TileLoaderProcessHook)ph.data).complete(tile, success);
            ph = (LList)ph.next;
        }
    }

    public static interface TileLoaderThemeHook {
        public boolean process(MapTile var1, RenderBuckets var2, MapElement var3, RenderStyle var4, int var5);

        public void complete(MapTile var1, boolean var2);
    }

    public static interface TileLoaderProcessHook {
        public boolean process(MapTile var1, RenderBuckets var2, MapElement var3);

        public void complete(MapTile var1, boolean var2);
    }
}

