/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.layers.tile.vector.labeling;

import org.oscim.core.GeometryBuffer;
import org.oscim.core.MapElement;
import org.oscim.core.PointF;
import org.oscim.core.Tile;
import org.oscim.layers.tile.MapTile;
import org.oscim.layers.tile.vector.VectorTileLayer;
import org.oscim.layers.tile.vector.labeling.LabelLayer;
import org.oscim.layers.tile.vector.labeling.LabelTileData;
import org.oscim.layers.tile.vector.labeling.WayDecorator;
import org.oscim.renderer.bucket.RenderBuckets;
import org.oscim.renderer.bucket.SymbolItem;
import org.oscim.renderer.bucket.TextItem;
import org.oscim.theme.styles.RenderStyle;
import org.oscim.theme.styles.SymbolStyle;
import org.oscim.theme.styles.TextStyle;
import org.oscim.utils.Parameters;
import org.oscim.utils.geom.PolyLabel;

public class LabelTileLoaderHook
implements VectorTileLayer.TileLoaderThemeHook {
    private LabelTileData get(MapTile tile) {
        LabelTileData ld = (LabelTileData)tile.getData(LabelLayer.LABEL_DATA);
        if (ld == null) {
            ld = new LabelTileData();
            tile.addData(LabelLayer.LABEL_DATA, ld);
        }
        return ld;
    }

    @Override
    public boolean process(MapTile tile, RenderBuckets buckets, MapElement element, RenderStyle style, int level) {
        block34: {
            block32: {
                LabelTileData ld;
                String value;
                TextStyle text;
                block35: {
                    float area;
                    float ratio;
                    block33: {
                        if (!(style instanceof TextStyle)) break block32;
                        text = (TextStyle)style.current();
                        value = element.tags.getValue(text.textKey);
                        if (value == null || value.length() == 0) {
                            return false;
                        }
                        ld = this.get(tile);
                        if (element.type != GeometryBuffer.GeometryType.LINE) break block33;
                        int offset = 0;
                        for (int length : element.index) {
                            if (length < 4) break;
                            WayDecorator.renderText(null, element.points, value, text, offset, length, ld);
                            offset += length;
                        }
                        break block34;
                    }
                    if (element.type != GeometryBuffer.GeometryType.POLY) break block35;
                    PointF label = element.labelPosition;
                    if (label == null) {
                        label = element.centroidPosition;
                    }
                    if (label != null && (label.x < 0.0f || label.x > (float)Tile.SIZE || label.y < 0.0f || label.y > (float)Tile.SIZE)) {
                        return false;
                    }
                    if (text.areaSize > 0.0f && (ratio = (area = element.area()) / (float)(Tile.SIZE * Tile.SIZE)) < text.areaSize) {
                        return false;
                    }
                    float x = 0.0f;
                    float y = 0.0f;
                    if (label == null) {
                        if (Parameters.POLY_LABEL) {
                            label = PolyLabel.get(element);
                            x = label.x;
                            y = label.y;
                        } else {
                            int n = element.index[0];
                            int i = 0;
                            while (i < n) {
                                x += element.points[i++];
                                y += element.points[i++];
                            }
                            x /= (float)(n / 2);
                            y /= (float)(n / 2);
                        }
                    } else {
                        x = label.x;
                        y = label.y;
                    }
                    ld.labels.push(TextItem.pool.get().set(x, y, value, text));
                    break block34;
                }
                if (element.type != GeometryBuffer.GeometryType.POINT) break block34;
                int n = element.getNumPoints();
                for (int i = 0; i < n; ++i) {
                    PointF p = element.getPoint(i);
                    ld.labels.push(TextItem.pool.get().set(p.x, p.y, value, text));
                }
                break block34;
            }
            if (style instanceof SymbolStyle) {
                SymbolStyle symbol = (SymbolStyle)style.current();
                if (symbol.bitmap == null && symbol.texture == null) {
                    return false;
                }
                LabelTileData ld = this.get(tile);
                if (element.type == GeometryBuffer.GeometryType.LINE) {
                    int offset = 0;
                    for (int length : element.index) {
                        if (length < 4) break;
                        WayDecorator.renderSymbol(null, element.points, symbol, offset, length, ld);
                        offset += length;
                    }
                } else if (element.type == GeometryBuffer.GeometryType.POLY) {
                    PointF centroid = element.labelPosition;
                    if (centroid == null) {
                        centroid = element.centroidPosition;
                    }
                    if (!Parameters.POLY_SYMBOL && centroid == null) {
                        return false;
                    }
                    if (centroid != null && (centroid.x < 0.0f || centroid.x > (float)Tile.SIZE || centroid.y < 0.0f || centroid.y > (float)Tile.SIZE)) {
                        return false;
                    }
                    float x = 0.0f;
                    float y = 0.0f;
                    if (centroid == null) {
                        if (Parameters.POLY_LABEL) {
                            centroid = PolyLabel.get(element);
                            x = centroid.x;
                            y = centroid.y;
                        } else {
                            int n = element.index[0];
                            int i = 0;
                            while (i < n) {
                                x += element.points[i++];
                                y += element.points[i++];
                            }
                            x /= (float)(n / 2);
                            y /= (float)(n / 2);
                        }
                    } else {
                        x = centroid.x;
                        y = centroid.y;
                    }
                    SymbolItem it = SymbolItem.pool.get();
                    if (symbol.bitmap != null) {
                        it.set(x, y, symbol.bitmap, true);
                    } else {
                        it.set(x, y, symbol.texture, true);
                    }
                    ld.symbols.push(it);
                } else if (element.type == GeometryBuffer.GeometryType.POINT) {
                    int n = element.getNumPoints();
                    for (int i = 0; i < n; ++i) {
                        PointF p = element.getPoint(i);
                        SymbolItem it = SymbolItem.pool.get();
                        if (symbol.bitmap != null) {
                            it.set(p.x, p.y, symbol.bitmap, true);
                        } else {
                            it.set(p.x, p.y, symbol.texture, true);
                        }
                        ld.symbols.push(it);
                    }
                }
            }
        }
        return false;
    }

    @Override
    public void complete(MapTile tile, boolean success) {
    }
}

