/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.layers.tile.vector.labeling;

import org.oscim.layers.tile.vector.labeling.LabelLayer;
import org.oscim.layers.tile.vector.labeling.LabelTask;
import org.oscim.renderer.BucketRenderer;
import org.oscim.renderer.GLState;
import org.oscim.renderer.GLViewport;
import org.oscim.renderer.bucket.RenderBucket;
import org.oscim.renderer.bucket.TextureBucket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TextRenderer
extends BucketRenderer {
    static final Logger log = LoggerFactory.getLogger(TextRenderer.class);
    static final boolean dbg = false;
    private final LabelLayer.Worker mWorker;
    long lastDraw = 0L;

    public TextRenderer(LabelLayer.Worker worker) {
        this.mWorker = worker;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void update(GLViewport v) {
        LabelTask t;
        LabelLayer.Worker worker = this.mWorker;
        synchronized (worker) {
            t = (LabelTask)this.mWorker.poll();
            if (t == null) {
                if (!this.mWorker.isRunning()) {
                    this.mWorker.submit(50L);
                }
                return;
            }
            this.buckets.clear();
        }
        this.buckets.set(t.layers);
        this.mMapPosition = t.pos;
        this.compile();
    }

    @Override
    public synchronized void render(GLViewport v) {
        GLState.test(false, false);
        this.buckets.vbo.bind();
        float scale = (float)(v.pos.scale / this.mMapPosition.scale);
        this.setMatrix(v, false);
        RenderBucket l = this.buckets.get();
        while (l != null) {
            l = TextureBucket.Renderer.draw(l, v, scale);
        }
    }
}

