/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.layers.vector;

import org.oscim.core.Box;
import org.oscim.core.GeometryBuffer;
import org.oscim.core.MapPosition;
import org.oscim.event.Event;
import org.oscim.layers.Layer;
import org.oscim.map.Map;
import org.oscim.map.Viewport;
import org.oscim.renderer.BucketRenderer;
import org.oscim.renderer.GLViewport;
import org.oscim.renderer.MapRenderer;
import org.oscim.renderer.bucket.RenderBuckets;
import org.oscim.utils.async.SimpleWorker;
import org.oscim.utils.geom.TileClipper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractVectorLayer<T>
extends Layer
implements Map.UpdateListener {
    public static final Logger log = LoggerFactory.getLogger(AbstractVectorLayer.class);
    protected static final double UNSCALE_COORD = 4.0;
    private static final int MAX_CLIP = (int)(32767.0f / MapRenderer.COORD_SCALE);
    protected final GeometryBuffer mGeom = new GeometryBuffer(128, 4);
    protected final TileClipper mClipper = new TileClipper(-MAX_CLIP, -MAX_CLIP, MAX_CLIP, MAX_CLIP);
    protected final Worker mWorker = new Worker(this.mMap);
    protected long mUpdateDelay = 50L;
    protected boolean mUpdate = true;

    public AbstractVectorLayer(Map map) {
        super(map);
        this.mRenderer = new Renderer();
    }

    @Override
    public void onDetach() {
        super.onDetach();
        this.mWorker.cancel(true);
    }

    @Override
    public void onMapEvent(Event e, MapPosition pos) {
        if (this.mUpdate) {
            this.mUpdate = false;
            this.mWorker.submit(0L);
        } else if (e == Map.POSITION_EVENT || e == Map.CLEAR_EVENT) {
            this.mWorker.submit(this.mUpdateDelay);
        }
    }

    public void update() {
        this.mWorker.submit(0L);
    }

    protected abstract void processFeatures(Task var1, Box var2);

    public class Renderer
    extends BucketRenderer {
        MapPosition mTmpPos = new MapPosition();

        public Renderer() {
            this.mFlipOnDateLine = true;
        }

        @Override
        public void update(GLViewport v) {
            Task t = (Task)AbstractVectorLayer.this.mWorker.poll();
            if (t == null) {
                return;
            }
            this.mMapPosition.copy(t.position);
            this.mMapPosition.setScale(this.mMapPosition.scale / 4.0);
            this.buckets.setFrom(t.buckets);
            this.compile();
        }
    }

    protected class Worker
    extends SimpleWorker<Task> {
        public Worker(Map map) {
            super(map, 50L, new Task(), new Task());
        }

        @Override
        public void cleanup(Task t) {
            if (t.buckets != null) {
                t.buckets.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean doWork(Task t) {
            Box bbox;
            Viewport v;
            float[] box = new float[8];
            Viewport viewport = v = this.mMap.viewport().getSyncViewport();
            synchronized (viewport) {
                bbox = v.getBBox(null, 0);
                v.getMapExtents(box, 0.0f);
                v.getMapPosition(t.position);
            }
            bbox.map2mercator();
            AbstractVectorLayer.this.processFeatures(t, bbox);
            t.buckets.prepare();
            this.mMap.render();
            return true;
        }
    }

    protected static class Task {
        public final RenderBuckets buckets = new RenderBuckets();
        public final MapPosition position = new MapPosition();

        protected Task() {
        }
    }
}

