/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.map;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.oscim.event.Gesture;
import org.oscim.event.GestureListener;
import org.oscim.event.MotionEvent;
import org.oscim.layers.GroupLayer;
import org.oscim.layers.Layer;
import org.oscim.layers.tile.ZoomLimiter;
import org.oscim.map.Map;
import org.oscim.renderer.LayerRenderer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Layers
extends AbstractList<Layer> {
    private static final Logger log = LoggerFactory.getLogger(Layers.class);
    private final Map mMap;
    private final Layer.EnableHandler mEnableHandler;
    private final List<Layer> mLayerList = new CopyOnWriteArrayList<Layer>();
    private final List<Integer> mGroupList = new ArrayList<Integer>();
    private final java.util.Map<Integer, Integer> mGroupIndex = new HashMap<Integer, Integer>();
    private boolean mDirtyLayers;
    private LayerRenderer[] mLayerRenderer;
    private Layer[] mLayers;

    Layers(Map map) {
        this.mMap = map;
        this.mEnableHandler = new Layer.EnableHandler(){

            @Override
            public void changed(boolean enabled) {
                Layers.this.mDirtyLayers = true;
            }
        };
    }

    @Override
    public synchronized Layer get(int index) {
        return this.mLayerList.get(index);
    }

    @Override
    public synchronized int size() {
        return this.mLayerList.size();
    }

    @Override
    public synchronized void add(int index, Layer layer) {
        if (this.mLayerList.contains(layer)) {
            throw new IllegalArgumentException("layer added twice");
        }
        if (layer instanceof Map.UpdateListener) {
            this.mMap.events.bind((Map.UpdateListener)((Object)layer));
        }
        if (layer instanceof Map.InputListener) {
            this.mMap.input.bind((Map.InputListener)((Object)layer));
        }
        if (layer instanceof ZoomLimiter.IZoomLimiter) {
            ((ZoomLimiter.IZoomLimiter)((Object)layer)).addZoomLimit();
        }
        if (layer instanceof GroupLayer) {
            GroupLayer groupLayer = (GroupLayer)layer;
            for (Layer gl : groupLayer.layers) {
                if (gl instanceof Map.UpdateListener) {
                    this.mMap.events.bind((Map.UpdateListener)((Object)gl));
                }
                if (gl instanceof Map.InputListener) {
                    this.mMap.input.bind((Map.InputListener)((Object)gl));
                }
                if (!(gl instanceof ZoomLimiter.IZoomLimiter)) continue;
                ((ZoomLimiter.IZoomLimiter)((Object)gl)).addZoomLimit();
            }
        }
        layer.setEnableHandler(this.mEnableHandler);
        this.mLayerList.add(index, layer);
        this.mDirtyLayers = true;
    }

    public synchronized void add(Layer layer, int group) {
        int index = this.mGroupList.indexOf(group);
        if (index < 0) {
            throw new IllegalArgumentException("unknown layer group");
        }
        if (this.mLayerList.contains(layer)) {
            throw new IllegalArgumentException("layer added twice");
        }
        if (++index == this.mGroupList.size()) {
            this.add(layer);
        } else {
            this.add((int)this.mGroupIndex.get(this.mGroupList.get(index)), layer);
            for (int i = index; i < this.mGroupList.size(); ++i) {
                group = this.mGroupList.get(i);
                this.mGroupIndex.put(group, this.mGroupIndex.get(group) + 1);
            }
        }
    }

    @Override
    public synchronized Layer remove(int index) {
        this.mDirtyLayers = true;
        Layer remove = this.mLayerList.remove(index);
        if (remove instanceof Map.UpdateListener) {
            this.mMap.events.unbind((Map.UpdateListener)((Object)remove));
        }
        if (remove instanceof Map.InputListener) {
            this.mMap.input.unbind((Map.InputListener)((Object)remove));
        }
        if (remove instanceof ZoomLimiter.IZoomLimiter) {
            ((ZoomLimiter.IZoomLimiter)((Object)remove)).removeZoomLimit();
        }
        if (remove instanceof GroupLayer) {
            GroupLayer groupLayer = (GroupLayer)remove;
            for (Layer gl : groupLayer.layers) {
                if (gl instanceof Map.UpdateListener) {
                    this.mMap.events.unbind((Map.UpdateListener)((Object)gl));
                }
                if (gl instanceof Map.InputListener) {
                    this.mMap.input.unbind((Map.InputListener)((Object)gl));
                }
                if (!(gl instanceof ZoomLimiter.IZoomLimiter)) continue;
                ((ZoomLimiter.IZoomLimiter)((Object)gl)).removeZoomLimit();
            }
        }
        for (Integer group : this.mGroupIndex.keySet()) {
            int pointer = this.mGroupIndex.get(group);
            if (pointer <= index) continue;
            this.mGroupIndex.put(group, pointer - 1);
        }
        remove.setEnableHandler(null);
        return remove;
    }

    @Override
    public synchronized Layer set(int index, Layer layer) {
        if (this.mLayerList.contains(layer)) {
            throw new IllegalArgumentException("layer added twice");
        }
        this.mDirtyLayers = true;
        Layer remove = this.mLayerList.set(index, layer);
        if (remove instanceof Map.UpdateListener) {
            this.mMap.events.unbind((Map.UpdateListener)((Object)remove));
        }
        if (remove instanceof Map.InputListener) {
            this.mMap.input.unbind((Map.InputListener)((Object)remove));
        }
        if (remove instanceof ZoomLimiter.IZoomLimiter) {
            ((ZoomLimiter.IZoomLimiter)((Object)remove)).removeZoomLimit();
        }
        if (remove instanceof GroupLayer) {
            GroupLayer groupLayer = (GroupLayer)remove;
            for (Layer gl : groupLayer.layers) {
                if (gl instanceof Map.UpdateListener) {
                    this.mMap.events.unbind((Map.UpdateListener)((Object)gl));
                }
                if (gl instanceof Map.InputListener) {
                    this.mMap.input.unbind((Map.InputListener)((Object)gl));
                }
                if (!(gl instanceof ZoomLimiter.IZoomLimiter)) continue;
                ((ZoomLimiter.IZoomLimiter)((Object)gl)).removeZoomLimit();
            }
        }
        remove.setEnableHandler(null);
        return remove;
    }

    public synchronized void addGroup(int group) {
        if (this.mGroupList.contains(group)) {
            throw new IllegalArgumentException("group added twice");
        }
        this.mGroupList.add(group);
        this.mGroupIndex.put(group, this.mLayerList.size());
    }

    public synchronized LayerRenderer[] getLayerRenderer() {
        if (this.mDirtyLayers) {
            this.updateLayers();
        }
        return this.mLayerRenderer;
    }

    synchronized void destroy() {
        if (this.mDirtyLayers) {
            this.updateLayers();
        }
        for (Layer o : this.mLayers) {
            o.onDetach();
        }
    }

    synchronized boolean handleGesture(Gesture g, MotionEvent e) {
        if (this.mDirtyLayers) {
            this.updateLayers();
        }
        for (Layer o : this.mLayers) {
            if (o instanceof GestureListener && ((GestureListener)((Object)o)).onGesture(g, e)) {
                return true;
            }
            if (!(o instanceof GroupLayer)) continue;
            GroupLayer groupLayer = (GroupLayer)o;
            for (Layer gl : groupLayer.layers) {
                if (!(gl instanceof GestureListener) || !((GestureListener)((Object)gl)).onGesture(g, e)) continue;
                return true;
            }
        }
        return false;
    }

    public synchronized void updateLayers() {
        try {
            int i;
            this.mLayers = new Layer[this.mLayerList.size()];
            int numRenderLayers = 0;
            int n = this.mLayerList.size();
            for (i = 0; i < n; ++i) {
                Layer o = this.mLayerList.get(i);
                if (o.isEnabled() && o.getRenderer() != null) {
                    ++numRenderLayers;
                }
                if (o instanceof GroupLayer) {
                    GroupLayer groupLayer = (GroupLayer)o;
                    for (Layer gl : groupLayer.layers) {
                        if (!gl.isEnabled() || gl.getRenderer() == null) continue;
                        ++numRenderLayers;
                    }
                }
                this.mLayers[n - i - 1] = o;
            }
            this.mLayerRenderer = new LayerRenderer[numRenderLayers];
            int cnt = 0;
            int n2 = this.mLayerList.size();
            for (i = 0; i < n2; ++i) {
                Layer o = this.mLayerList.get(i);
                LayerRenderer l = o.getRenderer();
                if (o.isEnabled() && l != null) {
                    this.mLayerRenderer[cnt++] = l;
                }
                if (!(o instanceof GroupLayer)) continue;
                GroupLayer groupLayer = (GroupLayer)o;
                for (Layer gl : groupLayer.layers) {
                    l = gl.getRenderer();
                    if (!gl.isEnabled() || l == null) continue;
                    this.mLayerRenderer[cnt++] = l;
                }
            }
            this.mDirtyLayers = false;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }
}

