/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.renderer;

import org.oscim.backend.CanvasAdapter;
import org.oscim.backend.GLAdapter;
import org.oscim.core.Box;
import org.oscim.core.MapPosition;
import org.oscim.core.Point;
import org.oscim.core.Tile;
import org.oscim.layers.Layer;
import org.oscim.map.Map;
import org.oscim.renderer.GLShader;
import org.oscim.renderer.GLState;
import org.oscim.renderer.GLUtils;
import org.oscim.renderer.GLViewport;
import org.oscim.renderer.LayerRenderer;
import org.oscim.renderer.LocationCallback;
import org.oscim.renderer.MapRenderer;
import org.oscim.utils.FastMath;
import org.oscim.utils.math.Interpolation;

public class LocationRenderer
extends LayerRenderer {
    private static final long ANIM_RATE = 50L;
    private static final long INTERVAL = 2000L;
    public static float CIRCLE_SIZE = 30.0f;
    private static final int COLOR = -13421620;
    private static final int SHOW_ACCURACY_ZOOM = 16;
    private final Map mMap;
    private final Layer mLayer;
    protected final float mScale;
    protected MapPosition mMapPosition;
    private String mShaderFile;
    protected int mShaderProgram;
    private int hVertexPosition;
    private int hMatrixPosition;
    private int hScale;
    private int hPhase;
    private int hDirection;
    private int uColor;
    private int uMode;
    private final Point mIndicatorPosition = new Point();
    private final Point mScreenPoint = new Point();
    private final Box mBBox = new Box();
    private boolean mInitialized;
    private boolean mLocationIsVisible;
    private boolean mRunAnim;
    private boolean mAnimate = true;
    private long mAnimStart;
    private boolean mCenter;
    private LocationCallback mCallback;
    private int mColor = -13421620;
    private final Point mLocation = new Point(Double.NaN, Double.NaN);
    private double mRadius;
    private int mShowAccuracyZoom = 16;

    public LocationRenderer(Map map, Layer layer) {
        this(map, layer, CanvasAdapter.getScale());
    }

    public LocationRenderer(Map map, Layer layer, float scale) {
        this.mMap = map;
        this.mLayer = layer;
        this.mScale = scale;
        this.mMapPosition = new MapPosition();
    }

    public void setAnimate(boolean animate) {
        this.mAnimate = animate;
    }

    public void setCallback(LocationCallback callback) {
        this.mCallback = callback;
    }

    public void setCenter(boolean center) {
        this.mCenter = center;
    }

    public void setColor(int color) {
        this.mColor = color;
    }

    public void setLocation(double x, double y, double radius) {
        this.mLocation.x = x;
        this.mLocation.y = y;
        this.mRadius = radius;
    }

    public void setShader(String shaderFile) {
        this.mShaderFile = shaderFile;
        this.mInitialized = false;
    }

    public void setShowAccuracyZoom(int showAccuracyZoom) {
        this.mShowAccuracyZoom = showAccuracyZoom;
    }

    public void animate(boolean enable) {
        if (this.mRunAnim == enable) {
            return;
        }
        this.mRunAnim = enable;
        if (!enable) {
            return;
        }
        if (!this.mAnimate) {
            return;
        }
        Runnable action = new Runnable(){
            private long lastRun;

            @Override
            public void run() {
                if (!LocationRenderer.this.mRunAnim) {
                    return;
                }
                if (!LocationRenderer.this.mAnimate) {
                    return;
                }
                long diff = System.currentTimeMillis() - this.lastRun;
                LocationRenderer.this.mMap.postDelayed(this, Math.min(50L, diff));
                LocationRenderer.this.mMap.render();
                this.lastRun = System.currentTimeMillis();
            }
        };
        this.mAnimStart = System.currentTimeMillis();
        this.mMap.postDelayed(action, 50L);
    }

    private float animPhase() {
        return (float)((MapRenderer.frametime - this.mAnimStart) % 2000L) / 2000.0f;
    }

    @Override
    public void update(GLViewport v) {
        double y;
        double x;
        if (!this.mInitialized) {
            this.init();
            this.mInitialized = true;
        }
        if (!this.mLayer.isEnabled()) {
            this.setReady(false);
            return;
        }
        this.setReady(true);
        int width = this.mMap.getWidth();
        int height = this.mMap.getHeight();
        if (this.mCenter) {
            x = (float)(width >> 1) + (float)width * this.mMap.viewport().getMapViewCenterX();
            y = (float)(height >> 1) + (float)height * this.mMap.viewport().getMapViewCenterY();
        } else {
            v.getBBox(this.mBBox, 0);
            x = this.mLocation.x;
            y = this.mLocation.y;
            if (!this.mBBox.contains(this.mLocation)) {
                x = FastMath.clamp(x, this.mBBox.xmin, this.mBBox.xmax);
                y = FastMath.clamp(y, this.mBBox.ymin, this.mBBox.ymax);
            }
            v.toScreenPoint(x, y, this.mScreenPoint);
            x = this.mScreenPoint.x + (double)(width >> 1);
            y = this.mScreenPoint.y + (double)(height >> 1);
        }
        int visible = 0;
        if (x > (double)(width - 5)) {
            x = width;
        } else if (x < 5.0) {
            x = 0.0;
        } else {
            ++visible;
        }
        if (y > (double)(height - 5)) {
            y = height;
        } else if (y < 5.0) {
            y = 0.0;
        } else {
            ++visible;
        }
        this.mLocationIsVisible = visible == 2;
        v.fromScreenPoint(x, y, this.mIndicatorPosition);
        this.mMapPosition.copy(v.pos);
        this.mMapPosition.bearing = -this.mMapPosition.bearing;
    }

    @Override
    public void render(GLViewport v) {
        GLState.useProgram(this.mShaderProgram);
        GLState.blend(true);
        GLState.test(false, false);
        GLState.enableVertexArrays(this.hVertexPosition, -1);
        MapRenderer.bindQuadVertexVBO(this.hVertexPosition);
        float radius = CIRCLE_SIZE * this.mScale;
        boolean viewShed = false;
        if (!this.mLocationIsVisible) {
            this.animate(true);
        } else {
            if (v.pos.zoomLevel >= this.mShowAccuracyZoom) {
                radius = (float)(this.mRadius * v.pos.scale);
            }
            radius = Math.max(CIRCLE_SIZE * this.mScale, radius);
            viewShed = true;
            this.animate(false);
        }
        GLAdapter.gl.uniform1f(this.hScale, radius);
        double x = this.mIndicatorPosition.x - v.pos.x;
        double y = this.mIndicatorPosition.y - v.pos.y;
        double tileScale = (double)Tile.SIZE * v.pos.scale;
        v.mvp.setTransScale((float)(x * tileScale), (float)(y * tileScale), 1.0f);
        v.mvp.multiplyMM(v.viewproj, v.mvp);
        v.mvp.setAsUniform(this.hMatrixPosition);
        if (!viewShed && this.mAnimate) {
            float phase = Math.abs(this.animPhase() - 0.5f) * 2.0f;
            phase = Interpolation.swing.apply(phase);
            GLAdapter.gl.uniform1f(this.hPhase, 0.8f + phase * 0.2f);
        } else {
            GLAdapter.gl.uniform1f(this.hPhase, 1.0f);
        }
        if (viewShed && this.mLocationIsVisible) {
            if (this.mCallback != null && this.mCallback.hasRotation()) {
                float rotation = this.mCallback.getRotation();
                GLAdapter.gl.uniform2f(this.hDirection, (float)Math.cos(Math.toRadians(rotation -= 90.0f)), (float)Math.sin(Math.toRadians(rotation)));
                GLAdapter.gl.uniform1i(this.uMode, 1);
            } else {
                GLAdapter.gl.uniform2f(this.hDirection, 0.0f, 0.0f);
                GLAdapter.gl.uniform1i(this.uMode, 0);
            }
        } else {
            GLAdapter.gl.uniform1i(this.uMode, -1);
        }
        GLUtils.setColor(this.uColor, this.mColor);
        GLAdapter.gl.drawArrays(5, 0, 4);
    }

    protected boolean init() {
        int program = GLShader.loadShader(this.mShaderFile != null ? this.mShaderFile : "location_1");
        if (program == 0) {
            return false;
        }
        this.mShaderProgram = program;
        this.hVertexPosition = GLAdapter.gl.getAttribLocation(program, "a_pos");
        this.hMatrixPosition = GLAdapter.gl.getUniformLocation(program, "u_mvp");
        this.hPhase = GLAdapter.gl.getUniformLocation(program, "u_phase");
        this.hScale = GLAdapter.gl.getUniformLocation(program, "u_scale");
        this.hDirection = GLAdapter.gl.getUniformLocation(program, "u_dir");
        this.uColor = GLAdapter.gl.getUniformLocation(program, "u_color");
        this.uMode = GLAdapter.gl.getUniformLocation(program, "u_mode");
        return true;
    }
}

