/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.renderer.bucket;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.ShortBuffer;
import org.oscim.backend.GLAdapter;
import org.oscim.core.GeometryBuffer;
import org.oscim.renderer.GLShader;
import org.oscim.renderer.GLState;
import org.oscim.renderer.GLUtils;
import org.oscim.renderer.GLViewport;
import org.oscim.renderer.MapRenderer;
import org.oscim.renderer.bucket.LineBucket;
import org.oscim.renderer.bucket.RenderBucket;
import org.oscim.renderer.bucket.RenderBuckets;
import org.oscim.renderer.bucket.VertexData;
import org.oscim.theme.styles.LineStyle;
import org.oscim.utils.FastMath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LineTexBucket
extends LineBucket {
    static final Logger log = LoggerFactory.getLogger(LineTexBucket.class);
    public int evenQuads;
    public int oddQuads;
    private boolean evenSegment = true;

    LineTexBucket(int level) {
        super((byte)1, false, true);
        this.level = level;
        this.evenSegment = true;
    }

    @Override
    public void addLine(GeometryBuffer geom) {
        this.addLine(geom.points, geom.index, -1, false);
    }

    @Override
    void addLine(float[] points, int[] index, int numPoints, boolean closed) {
        int n;
        if (this.vertexItems.empty()) {
            this.numVertices = 1;
        }
        VertexData vi = this.vertexItems;
        if (!this.evenSegment) {
            vi.seek(-12);
        }
        int length = 0;
        if (index == null) {
            n = 1;
            length = numPoints;
        } else {
            n = index.length;
        }
        int pos = 0;
        for (int i = 0; i < n; ++i) {
            float lineLength;
            if (index != null) {
                length = index[i];
            }
            if (length < 0) break;
            if (length < 4) {
                pos += length;
                continue;
            }
            int end = pos + length;
            float x = points[pos++] * MapRenderer.COORD_SCALE;
            float y = points[pos++] * MapRenderer.COORD_SCALE;
            float f = lineLength = this.line.randomOffset ? (x * x + y * y) % 80.0f : 0.0f;
            while (pos < end) {
                float nx = points[pos++] * MapRenderer.COORD_SCALE;
                float ny = points[pos++] * MapRenderer.COORD_SCALE;
                float vx = nx - x;
                float vy = ny - y;
                double dist = Math.sqrt(vx * vx + vy * vy);
                short dx = (short)((double)(-vy) / dist * 2048.0);
                short dy = (short)((double)vx / dist * 2048.0);
                if ((double)lineLength + dist > 32767.0) {
                    lineLength = -32768.0f;
                }
                if (dist > 65535.0) {
                    float ix = x + vx / 2.0f;
                    float iy = y + vy / 2.0f;
                    this.addShortVertex(vi, (short)x, (short)y, (short)ix, (short)iy, dx, dy, (short)lineLength, (int)(dist / 2.0));
                    this.addShortVertex(vi, (short)ix, (short)iy, (short)nx, (short)ny, dx, dy, (short)lineLength, (int)(dist / 2.0));
                } else {
                    this.addShortVertex(vi, (short)x, (short)y, (short)nx, (short)ny, dx, dy, (short)lineLength, (int)dist);
                    lineLength = (float)((double)lineLength + dist);
                }
                x = nx;
                y = ny;
            }
        }
        if (!this.evenSegment) {
            vi.seek(12);
        }
    }

    private void addShortVertex(VertexData vi, short x, short y, short nx, short ny, short dx, short dy, short lineLength, int dist) {
        vi.add(x, y, dx, dy, lineLength, (short)0);
        vi.seek(6);
        vi.add(nx, ny, dx, dy, (short)(lineLength + dist), (short)0);
        if (this.evenSegment) {
            vi.seek(-12);
            this.evenSegment = false;
            this.numVertices += 3;
            ++this.evenQuads;
        } else {
            this.evenSegment = true;
            ++this.numVertices;
            ++this.oddQuads;
        }
    }

    @Override
    protected void clear() {
        this.evenSegment = true;
        this.evenQuads = 0;
        this.oddQuads = 0;
        super.clear();
    }

    @Override
    protected void compile(ShortBuffer vboData, ShortBuffer iboData) {
        this.compileVertexItems(vboData);
        vboData.position(vboData.position() + 6);
    }

    public static final class Renderer {
        private static Shader shader;
        private static final float COORD_SCALE_BY_DIR_SCALE;
        private static int mVertexFlipID;
        private static final int STRIDE = 12;
        private static final int LEN_OFFSET = 8;

        public static void init() {
            shader = new Shader("linetex_layer_tex");
            int[] vboIds = GLUtils.glGenBuffers(1);
            mVertexFlipID = vboIds[0];
            byte[] flip = new byte[2048];
            for (int i = 0; i < flip.length; ++i) {
                flip[i] = (byte)(i % 2);
            }
            ByteBuffer buf = ByteBuffer.allocateDirect(flip.length).order(ByteOrder.nativeOrder());
            buf.put(flip);
            buf.flip();
            ShortBuffer sbuf = buf.asShortBuffer();
            GLState.bindVertexBuffer(mVertexFlipID);
            GLAdapter.gl.bufferData(34962, flip.length, sbuf, 35044);
            GLState.bindVertexBuffer(0);
        }

        public static int loadStippleTexture(byte[] stipple) {
            int sum = 0;
            for (byte flip : stipple) {
                sum += flip;
            }
            byte[] pixel = new byte[sum];
            boolean on = true;
            int pos = 0;
            for (int n : stipple) {
                float max = n;
                for (int s = 0; s < n; ++s) {
                    float alpha = Math.abs((float)s / (max - 1.0f) - 0.5f);
                    alpha = on ? 255.0f * (1.0f - alpha) : 255.0f * alpha;
                    pixel[pos + s] = FastMath.clampToByte((int)alpha);
                }
                on = !on;
                pos += n;
            }
            return GLUtils.loadTexture(pixel, sum, 1, 6406, 9729, 9729, 10497, 10497);
        }

        public static RenderBucket draw(RenderBucket b, GLViewport v, float div, RenderBuckets buckets) {
            GLState.blend(true);
            shader.useProgram();
            GLState.enableVertexArrays(-1, -1);
            int aLen0 = Renderer.shader.aLen0;
            int aLen1 = Renderer.shader.aLen1;
            int aPos0 = Renderer.shader.aPos0;
            int aPos1 = Renderer.shader.aPos1;
            int aFlip = Renderer.shader.aFlip;
            GLAdapter.gl.enableVertexAttribArray(aPos0);
            GLAdapter.gl.enableVertexAttribArray(aPos1);
            GLAdapter.gl.enableVertexAttribArray(aLen0);
            GLAdapter.gl.enableVertexAttribArray(aLen1);
            GLAdapter.gl.enableVertexAttribArray(aFlip);
            v.mvp.setAsUniform(Renderer.shader.uMVP);
            MapRenderer.bindQuadIndicesVBO();
            GLState.bindVertexBuffer(mVertexFlipID);
            GLAdapter.gl.vertexAttribPointer(Renderer.shader.aFlip, 1, 5120, false, 0, 0);
            buckets.vbo.bind();
            float scale = (float)v.pos.getZoomScale();
            float s = scale / div;
            while (b != null && b.type == 1) {
                int add;
                int numIndices;
                int i;
                float cnt;
                float pScale;
                LineTexBucket lb = (LineTexBucket)b;
                LineStyle line = lb.line.current();
                GLAdapter.gl.uniform1i(Renderer.shader.uMode, line.dashArray != null ? 2 : (line.texture != null ? 1 : 0));
                if (line.texture != null) {
                    line.texture.bind();
                }
                GLUtils.setColor(Renderer.shader.uColor, line.stippleColor, 1.0f);
                GLUtils.setColor(Renderer.shader.uBgColor, line.color, 1.0f);
                if (s >= 1.0f) {
                    pScale = (float)line.stipple * s;
                    cnt = pScale / (float)line.stipple;
                    pScale = (float)line.stipple / (cnt + 1.0f);
                } else {
                    pScale = (float)line.stipple / s;
                    cnt = pScale / (float)line.stipple;
                    pScale = (float)line.stipple * cnt;
                }
                GLAdapter.gl.uniform1f(Renderer.shader.uPatternScale, MapRenderer.COORD_SCALE * pScale);
                GLAdapter.gl.uniform1f(Renderer.shader.uPatternWidth, line.stippleWidth);
                GLAdapter.gl.uniform1f(Renderer.shader.uWidth, lb.scale * line.width / s * COORD_SCALE_BY_DIR_SCALE);
                int vOffset = -12;
                int allIndices = lb.evenQuads * 6;
                for (i = 0; i < allIndices; i += 3072) {
                    numIndices = allIndices - i;
                    if (numIndices > 3072) {
                        numIndices = 3072;
                    }
                    add = b.vertexOffset + i * 4 * 2 + vOffset;
                    GLAdapter.gl.vertexAttribPointer(aPos0, 4, 5122, false, 12, add + 12);
                    GLAdapter.gl.vertexAttribPointer(aLen0, 2, 5122, false, 12, add + 12 + 8);
                    GLAdapter.gl.vertexAttribPointer(aPos1, 4, 5122, false, 12, add);
                    GLAdapter.gl.vertexAttribPointer(aLen1, 2, 5122, false, 12, add + 8);
                    GLAdapter.gl.drawElements(4, numIndices, 5123, 0);
                }
                allIndices = lb.oddQuads * 6;
                for (i = 0; i < allIndices; i += 3072) {
                    numIndices = allIndices - i;
                    if (numIndices > 3072) {
                        numIndices = 3072;
                    }
                    add = b.vertexOffset + i * 4 * 2 + vOffset;
                    GLAdapter.gl.vertexAttribPointer(aPos0, 4, 5122, false, 12, add + 24);
                    GLAdapter.gl.vertexAttribPointer(aLen0, 2, 5122, false, 12, add + 24 + 8);
                    GLAdapter.gl.vertexAttribPointer(aPos1, 4, 5122, false, 12, add + 12);
                    GLAdapter.gl.vertexAttribPointer(aLen1, 2, 5122, false, 12, add + 12 + 8);
                    GLAdapter.gl.drawElements(4, numIndices, 5123, 0);
                }
                b = (RenderBucket)b.next;
            }
            GLAdapter.gl.disableVertexAttribArray(aPos0);
            GLAdapter.gl.disableVertexAttribArray(aPos1);
            GLAdapter.gl.disableVertexAttribArray(aLen0);
            GLAdapter.gl.disableVertexAttribArray(aLen1);
            GLAdapter.gl.disableVertexAttribArray(aFlip);
            return b;
        }

        static {
            COORD_SCALE_BY_DIR_SCALE = MapRenderer.COORD_SCALE / 2048.0f;
        }
    }

    static class Shader
    extends GLShader {
        int uMVP;
        int uColor;
        int uWidth;
        int uBgColor;
        int uMode;
        int uPatternWidth;
        int uPatternScale;
        int aPos0;
        int aPos1;
        int aLen0;
        int aLen1;
        int aFlip;

        Shader(String shaderFile) {
            if (!this.create(shaderFile)) {
                return;
            }
            this.uMVP = this.getUniform("u_mvp");
            this.uColor = this.getUniform("u_color");
            this.uWidth = this.getUniform("u_width");
            this.uBgColor = this.getUniform("u_bgcolor");
            this.uMode = this.getUniform("u_mode");
            this.uPatternWidth = this.getUniform("u_pwidth");
            this.uPatternScale = this.getUniform("u_pscale");
            this.aPos0 = this.getAttrib("a_pos0");
            this.aPos1 = this.getAttrib("a_pos1");
            this.aLen0 = this.getAttrib("a_len0");
            this.aLen1 = this.getAttrib("a_len1");
            this.aFlip = this.getAttrib("a_flip");
        }
    }
}

