/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.scalebar;

import org.oscim.backend.CanvasAdapter;
import org.oscim.backend.canvas.Bitmap;
import org.oscim.backend.canvas.Canvas;
import org.oscim.core.MapPosition;
import org.oscim.core.MercatorProjection;
import org.oscim.map.Map;
import org.oscim.scalebar.DistanceUnitAdapter;
import org.oscim.scalebar.MetricUnitAdapter;

public abstract class MapScaleBar {
    private static final ScaleBarPosition DEFAULT_SCALE_BAR_POSITION = ScaleBarPosition.BOTTOM_LEFT;
    private static final double LATITUDE_REDRAW_THRESHOLD = 0.2;
    private final MapPosition currentMapPosition = new MapPosition();
    protected DistanceUnitAdapter distanceUnitAdapter;
    protected final Map map;
    protected Bitmap mapScaleBitmap;
    protected Canvas mapScaleCanvas;
    private int marginHorizontal;
    private int marginVertical;
    protected final MapPosition prevMapPosition = new MapPosition();
    protected boolean redrawNeeded;
    protected final float scale;
    protected ScaleBarPosition scaleBarPosition;
    private boolean visible;

    public MapScaleBar(Map map, int width, int height, float scale) {
        this.map = map;
        this.mapScaleBitmap = CanvasAdapter.newBitmap(width, height, 0);
        this.scale = scale;
        this.scaleBarPosition = DEFAULT_SCALE_BAR_POSITION;
        this.mapScaleCanvas = CanvasAdapter.newCanvas();
        this.mapScaleCanvas.setBitmap(this.mapScaleBitmap);
        this.distanceUnitAdapter = MetricUnitAdapter.INSTANCE;
        this.visible = true;
        this.redrawNeeded = true;
    }

    public void destroy() {
        this.mapScaleBitmap.recycle();
        this.mapScaleBitmap = null;
        this.mapScaleCanvas = null;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public DistanceUnitAdapter getDistanceUnitAdapter() {
        return this.distanceUnitAdapter;
    }

    public void setDistanceUnitAdapter(DistanceUnitAdapter distanceUnitAdapter) {
        if (distanceUnitAdapter == null) {
            throw new IllegalArgumentException("adapter must not be null");
        }
        this.distanceUnitAdapter = distanceUnitAdapter;
        this.redrawNeeded = true;
    }

    public int getMarginHorizontal() {
        return this.marginHorizontal;
    }

    public void setMarginHorizontal(int marginHorizontal) {
        if (this.marginHorizontal != marginHorizontal) {
            this.marginHorizontal = marginHorizontal;
            this.redrawNeeded = true;
        }
    }

    public int getMarginVertical() {
        return this.marginVertical;
    }

    public void setMarginVertical(int marginVertical) {
        if (this.marginVertical != marginVertical) {
            this.marginVertical = marginVertical;
            this.redrawNeeded = true;
        }
    }

    public ScaleBarPosition getScaleBarPosition() {
        return this.scaleBarPosition;
    }

    public void setScaleBarPosition(ScaleBarPosition scaleBarPosition) {
        if (this.scaleBarPosition != scaleBarPosition) {
            this.scaleBarPosition = scaleBarPosition;
            this.redrawNeeded = true;
        }
    }

    private int calculatePositionLeft(int left, int right, int width) {
        switch (this.scaleBarPosition) {
            case BOTTOM_LEFT: 
            case TOP_LEFT: {
                return this.marginHorizontal;
            }
            case BOTTOM_CENTER: 
            case TOP_CENTER: {
                return (right - left - width) / 2;
            }
            case BOTTOM_RIGHT: 
            case TOP_RIGHT: {
                return right - left - width - this.marginHorizontal;
            }
        }
        throw new IllegalArgumentException("unknown horizontal position: " + (Object)((Object)this.scaleBarPosition));
    }

    private int calculatePositionTop(int top, int bottom, int height) {
        switch (this.scaleBarPosition) {
            case TOP_LEFT: 
            case TOP_CENTER: 
            case TOP_RIGHT: {
                return this.marginVertical;
            }
            case BOTTOM_LEFT: 
            case BOTTOM_CENTER: 
            case BOTTOM_RIGHT: {
                return bottom - top - height - this.marginVertical;
            }
        }
        throw new IllegalArgumentException("unknown vertical position: " + (Object)((Object)this.scaleBarPosition));
    }

    protected ScaleBarLengthAndValue calculateScaleBarLengthAndValue(DistanceUnitAdapter unitAdapter) {
        int scaleBarValue;
        this.map.getMapPosition(this.prevMapPosition);
        double groundResolution = MercatorProjection.groundResolution(this.prevMapPosition);
        groundResolution /= unitAdapter.getMeterRatio();
        int[] scaleBarValues = unitAdapter.getScaleBarValues();
        int scaleBarLength = 0;
        int mapScaleValue = 0;
        int[] nArray = scaleBarValues;
        int n = nArray.length;
        for (int i = 0; i < n && !((float)(scaleBarLength = (int)((double)(mapScaleValue = (scaleBarValue = nArray[i])) / groundResolution)) < (float)this.mapScaleBitmap.getWidth() - 10.0f * this.scale); ++i) {
        }
        return new ScaleBarLengthAndValue(scaleBarLength, mapScaleValue);
    }

    protected ScaleBarLengthAndValue calculateScaleBarLengthAndValue() {
        return this.calculateScaleBarLengthAndValue(this.distanceUnitAdapter);
    }

    public void draw(Canvas canvas) {
        if (!this.visible) {
            return;
        }
        if (this.map.getHeight() == 0) {
            return;
        }
        if (this.isRedrawNecessary()) {
            this.redraw(this.mapScaleCanvas);
            this.redrawNeeded = false;
        }
        int positionLeft = this.calculatePositionLeft(0, this.map.getWidth(), this.mapScaleBitmap.getWidth());
        int positionTop = this.calculatePositionTop(0, this.map.getHeight(), this.mapScaleBitmap.getHeight());
        canvas.drawBitmap(this.mapScaleBitmap, positionLeft, positionTop);
    }

    public void drawScaleBar() {
        this.draw(this.mapScaleCanvas);
    }

    public void redrawScaleBar() {
        this.redrawNeeded = true;
    }

    protected boolean isRedrawNecessary() {
        if (this.redrawNeeded) {
            return true;
        }
        this.map.getMapPosition(this.currentMapPosition);
        if (this.currentMapPosition.getScale() != this.prevMapPosition.getScale()) {
            return true;
        }
        double latitudeDiff = Math.abs(this.currentMapPosition.getLatitude() - this.prevMapPosition.getLatitude());
        return latitudeDiff > 0.2;
    }

    protected abstract void redraw(Canvas var1);

    protected static class ScaleBarLengthAndValue {
        public int scaleBarLength;
        public int scaleBarValue;

        public ScaleBarLengthAndValue(int scaleBarLength, int scaleBarValue) {
            this.scaleBarLength = scaleBarLength;
            this.scaleBarValue = scaleBarValue;
        }
    }

    public static enum ScaleBarPosition {
        BOTTOM_CENTER,
        BOTTOM_LEFT,
        BOTTOM_RIGHT,
        TOP_CENTER,
        TOP_LEFT,
        TOP_RIGHT;

    }
}

