/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.theme;

import org.oscim.backend.CanvasAdapter;
import org.oscim.theme.ExternalRenderTheme;
import org.oscim.theme.IRenderTheme;
import org.oscim.theme.ThemeCallback;
import org.oscim.theme.ThemeFile;
import org.oscim.theme.XmlAtlasThemeBuilder;
import org.oscim.theme.XmlRenderThemeMenuCallback;
import org.oscim.theme.XmlThemeBuilder;
import org.oscim.utils.Parameters;

public class ThemeLoader {
    public static IRenderTheme load(String renderThemePath) throws IRenderTheme.ThemeException {
        return ThemeLoader.load(new ExternalRenderTheme(renderThemePath));
    }

    public static IRenderTheme load(String renderThemePath, XmlRenderThemeMenuCallback menuCallback) throws IRenderTheme.ThemeException {
        return ThemeLoader.load(new ExternalRenderTheme(renderThemePath, menuCallback));
    }

    public static IRenderTheme load(String renderThemePath, ThemeCallback themeCallback) throws IRenderTheme.ThemeException {
        return ThemeLoader.load(new ExternalRenderTheme(renderThemePath), themeCallback);
    }

    public static IRenderTheme load(String renderThemePath, XmlRenderThemeMenuCallback menuCallback, ThemeCallback themeCallback) throws IRenderTheme.ThemeException {
        return ThemeLoader.load(new ExternalRenderTheme(renderThemePath, menuCallback), themeCallback);
    }

    public static IRenderTheme load(ThemeFile theme) throws IRenderTheme.ThemeException {
        return ThemeLoader.load(theme, null);
    }

    public static IRenderTheme load(ThemeFile theme, ThemeCallback themeCallback) throws IRenderTheme.ThemeException {
        IRenderTheme t;
        IRenderTheme iRenderTheme = t = Parameters.TEXTURE_ATLAS ? XmlAtlasThemeBuilder.read(theme, themeCallback) : XmlThemeBuilder.read(theme, themeCallback);
        if (t != null) {
            t.scaleTextSize(CanvasAdapter.getScale() * CanvasAdapter.textScale);
        }
        return t;
    }
}

