/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.tiling.source.mapfile;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.oscim.backend.CanvasAdapter;
import org.oscim.core.BoundingBox;
import org.oscim.core.GeoPoint;
import org.oscim.core.GeometryBuffer;
import org.oscim.core.MapElement;
import org.oscim.core.MercatorProjection;
import org.oscim.core.Tag;
import org.oscim.core.Tile;
import org.oscim.layers.tile.MapTile;
import org.oscim.tiling.ITileDataSink;
import org.oscim.tiling.ITileDataSource;
import org.oscim.tiling.QueryResult;
import org.oscim.tiling.source.mapfile.MapFileTileSource;
import org.oscim.tiling.source.mapfile.MapReadResult;
import org.oscim.tiling.source.mapfile.OSMUtils;
import org.oscim.tiling.source.mapfile.PoiWayBundle;
import org.oscim.tiling.source.mapfile.PointOfInterest;
import org.oscim.tiling.source.mapfile.Projection;
import org.oscim.tiling.source.mapfile.QueryCalculations;
import org.oscim.tiling.source.mapfile.QueryParameters;
import org.oscim.tiling.source.mapfile.ReadBuffer;
import org.oscim.tiling.source.mapfile.Way;
import org.oscim.tiling.source.mapfile.header.SubFileParameter;
import org.oscim.utils.Parameters;
import org.oscim.utils.geom.TileClipper;
import org.oscim.utils.geom.TileSeparator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapDatabase
implements ITileDataSource {
    private static final long BITMASK_INDEX_OFFSET = 0x7FFFFFFFFFL;
    private static final long BITMASK_INDEX_WATER = 0x8000000000L;
    private static final String DEBUG_SIGNATURE_BLOCK = "block signature: ";
    private static final String DEBUG_SIGNATURE_WAY = "way signature: ";
    private static final String INVALID_FIRST_WAY_OFFSET = "invalid first way offset: ";
    static final Logger log = LoggerFactory.getLogger(MapDatabase.class);
    private static final int POI_FEATURE_ELEVATION = 32;
    private static final int POI_FEATURE_HOUSE_NUMBER = 64;
    private static final int POI_FEATURE_NAME = 128;
    private static final int POI_LAYER_BITMASK = 240;
    private static final int POI_LAYER_SHIFT = 4;
    private static final int POI_NUMBER_OF_TAGS_BITMASK = 15;
    private static final byte SIGNATURE_LENGTH_BLOCK = 32;
    private static final byte SIGNATURE_LENGTH_POI = 32;
    private static final byte SIGNATURE_LENGTH_WAY = 32;
    private static final int WAY_FEATURE_DATA_BLOCKS_BYTE = 8;
    private static final int WAY_FEATURE_DOUBLE_DELTA_ENCODING = 4;
    private static final int WAY_FEATURE_HOUSE_NUMBER = 64;
    private static final int WAY_FEATURE_LABEL_POSITION = 16;
    private static final int WAY_FEATURE_NAME = 128;
    private static final int WAY_FEATURE_REF = 32;
    private static final int WAY_LAYER_BITMASK = 240;
    private static final int WAY_LAYER_SHIFT = 4;
    private static final int WAY_NUMBER_OF_TAGS_BITMASK = 15;
    public static boolean wayFilterEnabled = true;
    public static int wayFilterDistance = 20;
    public static int SIMPLIFICATION_MIN_ZOOM = 8;
    public static int SIMPLIFICATION_MAX_ZOOM = 11;
    private static final Tag TAG_ISSEA = new Tag("natural", "issea");
    private static final Tag TAG_NOSEA = new Tag("natural", "nosea");
    private static final Tag TAG_SEA = new Tag("natural", "sea");
    private long mFileSize;
    private boolean mDebugFile;
    private RandomAccessFile mInputFile;
    private ReadBuffer mReadBuffer;
    private String mSignatureBlock;
    private String mSignaturePoi;
    private String mSignatureWay;
    private int mTileLatitude;
    private int mTileLongitude;
    private int[] mIntBuffer;
    private final MapElement mElem = new MapElement();
    private int minDeltaLat;
    private int minDeltaLon;
    private final TileProjection mTileProjection;
    private final TileClipper mTileClipper;
    private final TileSeparator mTileSeparator;
    private final MapFileTileSource mTileSource;
    private int zoomLevelMin = 0;
    private int zoomLevelMax = 127;
    private int stringOffset = -1;

    public MapDatabase(MapFileTileSource tileSource) throws IOException {
        this.mTileSource = tileSource;
        try {
            this.mInputFile = new RandomAccessFile(tileSource.mapFile, "r");
            this.mFileSize = this.mInputFile.length();
            this.mReadBuffer = new ReadBuffer(this.mInputFile);
        }
        catch (IOException e) {
            log.error(e.getMessage());
            this.dispose();
            throw new IOException();
        }
        this.mTileProjection = new TileProjection();
        this.mTileClipper = new TileClipper(0.0f, 0.0f, 0.0f, 0.0f);
        this.mTileSeparator = new TileSeparator(0.0f, 0.0f, 0.0f, 0.0f);
    }

    public MapFileTileSource getTileSource() {
        return this.mTileSource;
    }

    @Override
    public void query(MapTile tile, ITileDataSink sink) {
        if (this.mTileSource.fileHeader == null) {
            sink.completed(QueryResult.FAILED);
            return;
        }
        if (this.mIntBuffer == null) {
            this.mIntBuffer = new int[65534];
        }
        try {
            this.mTileProjection.setTile(tile);
            if (Parameters.SIMPLIFICATION_TOLERANCE > 0 && tile.zoomLevel >= SIMPLIFICATION_MIN_ZOOM && tile.zoomLevel <= SIMPLIFICATION_MAX_ZOOM) {
                double size = 1.0 / (double)(1 << tile.zoomLevel);
                int pixel = Parameters.SIMPLIFICATION_TOLERANCE;
                int simplify = Tile.SIZE / pixel;
                this.minDeltaLat = (int)(Math.abs(MercatorProjection.toLatitude(tile.y + size) - MercatorProjection.toLatitude(tile.y)) * 1000000.0) / simplify;
                this.minDeltaLon = (int)(Math.abs(MercatorProjection.toLongitude(tile.x + size) - MercatorProjection.toLongitude(tile.x)) * 1000000.0) / simplify;
            } else {
                this.minDeltaLat = 0;
                this.minDeltaLon = 0;
            }
            QueryParameters queryParameters = new QueryParameters();
            queryParameters.queryZoomLevel = this.mTileSource.fileHeader.getQueryZoomLevel(tile.zoomLevel);
            SubFileParameter subFileParameter = this.mTileSource.fileHeader.getSubFileParameter(queryParameters.queryZoomLevel);
            if (subFileParameter == null) {
                log.warn("no sub-file for zoom level: " + queryParameters.queryZoomLevel);
                sink.completed(QueryResult.FAILED);
                return;
            }
            QueryCalculations.calculateBaseTiles(queryParameters, tile, subFileParameter);
            QueryCalculations.calculateBlocks(queryParameters, subFileParameter);
            this.processBlocks(sink, queryParameters, subFileParameter);
        }
        catch (IOException e) {
            log.error(e.getMessage());
            sink.completed(QueryResult.FAILED);
            return;
        }
        sink.completed(QueryResult.SUCCESS);
    }

    @Override
    public void dispose() {
        this.mReadBuffer = null;
        if (this.mInputFile != null) {
            try {
                this.mInputFile.close();
                this.mInputFile = null;
            }
            catch (IOException e) {
                log.error(e.getMessage());
            }
        }
    }

    @Override
    public void cancel() {
    }

    private void logDebugSignatures() {
        if (this.mDebugFile) {
            log.warn(DEBUG_SIGNATURE_WAY + this.mSignatureWay);
            log.warn(DEBUG_SIGNATURE_BLOCK + this.mSignatureBlock);
        }
    }

    private void processBlock(QueryParameters queryParameters, SubFileParameter subFileParameter, ITileDataSink mapDataSink, BoundingBox boundingBox, Selector selector, MapReadResult mapReadResult) {
        if (!this.processBlockSignature()) {
            return;
        }
        int[][] zoomTable = this.readZoomTable(subFileParameter);
        if (zoomTable == null) {
            return;
        }
        int zoomTableRow = queryParameters.queryZoomLevel - subFileParameter.zoomLevelMin;
        int poisOnQueryZoomLevel = zoomTable[zoomTableRow][0];
        int waysOnQueryZoomLevel = zoomTable[zoomTableRow][1];
        int firstWayOffset = this.mReadBuffer.readUnsignedInt();
        if (firstWayOffset < 0) {
            log.warn(INVALID_FIRST_WAY_OFFSET + firstWayOffset);
            if (this.mDebugFile) {
                log.warn(DEBUG_SIGNATURE_BLOCK + this.mSignatureBlock);
            }
            return;
        }
        if ((firstWayOffset += this.mReadBuffer.getBufferPosition()) > this.mReadBuffer.getBufferSize()) {
            log.warn(INVALID_FIRST_WAY_OFFSET + firstWayOffset);
            if (this.mDebugFile) {
                log.warn(DEBUG_SIGNATURE_BLOCK + this.mSignatureBlock);
            }
            return;
        }
        boolean filterRequired = queryParameters.queryZoomLevel > subFileParameter.baseZoomLevel;
        ArrayList<PointOfInterest> pois = null;
        if (mapReadResult != null) {
            pois = new ArrayList<PointOfInterest>();
        }
        if (!this.processPOIs(mapDataSink, poisOnQueryZoomLevel, boundingBox, filterRequired, pois)) {
            return;
        }
        if (this.mReadBuffer.getBufferPosition() > firstWayOffset) {
            log.warn("invalid buffer position: " + this.mReadBuffer.getBufferPosition());
            if (this.mDebugFile) {
                log.warn(DEBUG_SIGNATURE_BLOCK + this.mSignatureBlock);
            }
            return;
        }
        this.mReadBuffer.setBufferPosition(firstWayOffset);
        List<Way> ways = null;
        if (mapReadResult != null && Selector.POIS != selector) {
            ways = new ArrayList<Way>();
        }
        if (!this.processWays(queryParameters, mapDataSink, waysOnQueryZoomLevel, boundingBox, filterRequired, selector, ways)) {
            return;
        }
        if (mapReadResult != null) {
            if (Selector.POIS == selector) {
                ways = Collections.emptyList();
            }
            mapReadResult.add(new PoiWayBundle(pois, ways));
        }
    }

    private void setTileClipping(QueryParameters queryParameters, SubFileParameter subFileParameter, long currentRow, long currentCol) {
        long numRows = queryParameters.toBlockY - queryParameters.fromBlockY;
        long numCols = queryParameters.toBlockX - queryParameters.fromBlockX;
        int buffer = queryParameters.queryZoomLevel > 17 ? Tile.SIZE / 2 : (int)(16.0f * CanvasAdapter.getScale() + 0.5f);
        int xmin = -buffer;
        int ymin = -buffer;
        int xmax = Tile.SIZE + buffer;
        int ymax = Tile.SIZE + buffer;
        int xSmin = 0;
        int ySmin = 0;
        int xSmax = Tile.SIZE;
        int ySmax = Tile.SIZE;
        if (numRows > 0L) {
            boolean isTopBorder = queryParameters.fromBaseTileY < subFileParameter.boundaryTileTop;
            boolean isLeftBorder = queryParameters.fromBaseTileX < subFileParameter.boundaryTileLeft;
            long numSubX = queryParameters.toBaseTileX - queryParameters.fromBaseTileX;
            long numSubY = queryParameters.toBaseTileY - queryParameters.fromBaseTileY;
            long numDifX = numSubX - numCols;
            long numDifY = numSubY - numRows;
            int w = (int)((long)Tile.SIZE / (numSubX + 1L));
            int h = (int)((long)Tile.SIZE / (numSubY + 1L));
            if (currentCol > 0L) {
                xSmin = xmin = (int)((currentCol + (isLeftBorder ? numDifX : 0L)) * (long)w);
            }
            if (currentCol < numCols) {
                xSmax = xmax = (int)((currentCol + (isLeftBorder ? numDifX : 0L)) * (long)w + (long)w);
            }
            if (currentRow > 0L) {
                ySmin = ymin = (int)((currentRow + (isTopBorder ? numDifY : 0L)) * (long)h);
            }
            if (currentRow < numRows) {
                ySmax = ymax = (int)((currentRow + (isTopBorder ? numDifY : 0L)) * (long)h + (long)h);
            }
        }
        this.mTileClipper.setRect(xmin, ymin, xmax, ymax);
        this.mTileSeparator.setRect(xSmin, ySmin, xSmax, ySmax);
    }

    private void processBlocks(ITileDataSink mapDataSink, QueryParameters queryParams, SubFileParameter subFileParameter) throws IOException {
        this.processBlocks(mapDataSink, queryParams, subFileParameter, null, null, null);
    }

    private void processBlocks(QueryParameters queryParams, SubFileParameter subFileParameter, BoundingBox boundingBox, Selector selector, MapReadResult mapReadResult) throws IOException {
        this.processBlocks(null, queryParams, subFileParameter, boundingBox, selector, mapReadResult);
    }

    private void processBlocks(ITileDataSink mapDataSink, QueryParameters queryParams, SubFileParameter subFileParameter, BoundingBox boundingBox, Selector selector, MapReadResult mapReadResult) throws IOException {
        for (long row = queryParams.fromBlockY; row <= queryParams.toBlockY; ++row) {
            for (long column = queryParams.fromBlockX; column <= queryParams.toBlockX; ++column) {
                long nextBlockPointer;
                long blockPointer;
                this.setTileClipping(queryParams, subFileParameter, row - queryParams.fromBlockY, column - queryParams.fromBlockX);
                long blockNumber = row * subFileParameter.blocksWidth + column;
                long blockIndexEntry = this.mTileSource.databaseIndexCache.getIndexEntry(subFileParameter, blockNumber);
                if ((blockIndexEntry & 0x8000000000L) != 0L) {
                    // empty if block
                }
                if ((blockPointer = blockIndexEntry & 0x7FFFFFFFFFL) < 1L || blockPointer > subFileParameter.subFileSize) {
                    log.warn("invalid current block pointer: " + blockPointer);
                    log.warn("subFileSize: " + subFileParameter.subFileSize);
                    return;
                }
                if (blockNumber + 1L == subFileParameter.numberOfBlocks) {
                    nextBlockPointer = subFileParameter.subFileSize;
                } else {
                    nextBlockPointer = this.mTileSource.databaseIndexCache.getIndexEntry(subFileParameter, blockNumber + 1L);
                    if ((nextBlockPointer &= 0x7FFFFFFFFFL) < 1L || nextBlockPointer > subFileParameter.subFileSize) {
                        log.warn("invalid next block pointer: " + nextBlockPointer);
                        log.warn("sub-file size: " + subFileParameter.subFileSize);
                        return;
                    }
                }
                int blockSize = (int)(nextBlockPointer - blockPointer);
                if (blockSize < 0) {
                    log.warn("current block size must not be negative: " + blockSize);
                    return;
                }
                if (blockSize == 0) continue;
                if (blockSize > Parameters.MAXIMUM_BUFFER_SIZE) {
                    log.warn("current block size too large: " + blockSize);
                    continue;
                }
                if (blockPointer + (long)blockSize > this.mFileSize) {
                    log.warn("current block larger than file size: " + blockSize);
                    return;
                }
                this.mInputFile.seek(subFileParameter.startAddress + blockPointer);
                if (!this.mReadBuffer.readFromFile(blockSize)) {
                    log.warn("reading current block has failed: " + blockSize);
                    return;
                }
                double tileLatitudeDeg = Projection.tileYToLatitude(subFileParameter.boundaryTileTop + row, subFileParameter.baseZoomLevel);
                double tileLongitudeDeg = Projection.tileXToLongitude(subFileParameter.boundaryTileLeft + column, subFileParameter.baseZoomLevel);
                this.mTileLatitude = (int)(tileLatitudeDeg * 1000000.0);
                this.mTileLongitude = (int)(tileLongitudeDeg * 1000000.0);
                this.processBlock(queryParams, subFileParameter, mapDataSink, boundingBox, selector, mapReadResult);
            }
        }
    }

    private boolean processBlockSignature() {
        if (this.mDebugFile) {
            this.mSignatureBlock = this.mReadBuffer.readUTF8EncodedString(32);
            if (!this.mSignatureBlock.startsWith("###TileStart")) {
                log.warn("invalid block signature: " + this.mSignatureBlock);
                return false;
            }
        }
        return true;
    }

    private boolean processPOIs(ITileDataSink mapDataSink, int numberOfPois, BoundingBox boundingBox, boolean filterRequired, List<PointOfInterest> pois) {
        Tag[] poiTags = this.mTileSource.fileInfo.poiTags;
        MapElement e = this.mElem;
        for (int elementCounter = numberOfPois; elementCounter != 0; --elementCounter) {
            String str;
            e.tags.clear();
            if (this.mDebugFile) {
                this.mSignaturePoi = this.mReadBuffer.readUTF8EncodedString(32);
                if (!this.mSignaturePoi.startsWith("***POIStart")) {
                    log.warn("invalid POI signature: " + this.mSignaturePoi);
                    log.warn(DEBUG_SIGNATURE_BLOCK + this.mSignatureBlock);
                    return false;
                }
            }
            int latitude = this.mTileLatitude + this.mReadBuffer.readSignedInt();
            int longitude = this.mTileLongitude + this.mReadBuffer.readSignedInt();
            byte specialByte = this.mReadBuffer.readByte();
            byte layer = (byte)((specialByte & 0xF0) >>> 4);
            byte numberOfTags = (byte)(specialByte & 0xF);
            if (numberOfTags != 0 && !this.mReadBuffer.readTags(e.tags, poiTags, numberOfTags)) {
                return false;
            }
            byte featureByte = this.mReadBuffer.readByte();
            if ((featureByte & 0x80) != 0) {
                str = this.mTileSource.extractLocalized(this.mReadBuffer.readUTF8EncodedString());
                e.tags.add(new Tag("name", str, false));
            }
            if ((featureByte & 0x40) != 0) {
                str = this.mReadBuffer.readUTF8EncodedString();
                e.tags.add(new Tag("addr:housenumber", str, false));
            }
            if ((featureByte & 0x20) != 0) {
                str = Integer.toString(this.mReadBuffer.readSignedInt());
                e.tags.add(new Tag("ele", str, false));
            }
            this.mTileProjection.projectPoint(latitude, longitude, e);
            if (!this.mTileSeparator.separate(e)) continue;
            e.setLayer(layer);
            if (pois != null) {
                ArrayList<Tag> tags = new ArrayList<Tag>();
                for (int i = 0; i < e.tags.size(); ++i) {
                    tags.add(e.tags.get(i));
                }
                GeoPoint position = new GeoPoint(latitude, longitude);
                if (!filterRequired || boundingBox.contains(position)) {
                    pois.add(new PointOfInterest(layer, tags, position));
                }
            }
            if (mapDataSink == null) continue;
            mapDataSink.process(e);
        }
        return true;
    }

    private boolean processWayDataBlock(MapElement e, boolean doubleDeltaEncoding, boolean isLine, List<GeoPoint[]> wayCoordinates, int[] labelPosition) {
        int numBlocks = this.mReadBuffer.readUnsignedInt();
        if (numBlocks < 1 || numBlocks > Short.MAX_VALUE) {
            log.warn("invalid number of way coordinate blocks: " + numBlocks);
            return false;
        }
        int[] wayLengths = e.ensureIndexSize(numBlocks, false);
        if (wayLengths.length > numBlocks) {
            wayLengths[numBlocks] = -1;
        }
        for (int coordinateBlock = 0; coordinateBlock < numBlocks; ++coordinateBlock) {
            int numWayNodes = this.mReadBuffer.readUnsignedInt();
            if (numWayNodes < 2 || numWayNodes > Short.MAX_VALUE) {
                log.warn("invalid number of way nodes: " + numWayNodes);
                this.logDebugSignatures();
                return false;
            }
            int len = numWayNodes * 2;
            GeoPoint[] waySegment = null;
            if (wayCoordinates != null) {
                waySegment = new GeoPoint[numWayNodes];
            }
            wayLengths[coordinateBlock] = this.decodeWayNodes(doubleDeltaEncoding, e, len, isLine, (int[])(coordinateBlock == 0 ? labelPosition : null), waySegment);
            if (wayCoordinates == null) continue;
            wayCoordinates.add(waySegment);
        }
        return true;
    }

    private int decodeWayNodes(boolean doubleDelta, MapElement e, int length, boolean isLine, int[] labelPosition, GeoPoint[] waySegment) {
        float pLon;
        float pLat;
        int[] buffer = this.mIntBuffer;
        this.mReadBuffer.readSignedInt(buffer, length);
        float[] outBuffer = e.ensurePointSize(e.pointNextPos + length, true);
        int outPos = e.pointNextPos;
        int rawLat = this.mTileLatitude + buffer[0];
        int rawLon = this.mTileLongitude + buffer[1];
        float firstLat = pLat = this.mTileProjection.projectLat(rawLat);
        float firstLon = pLon = this.mTileProjection.projectLon(rawLon);
        outBuffer[outPos++] = pLon;
        outBuffer[outPos++] = pLat;
        int cnt = 2;
        if (labelPosition != null) {
            labelPosition[1] = rawLat + labelPosition[1];
            labelPosition[0] = rawLon + labelPosition[0];
        }
        if (waySegment != null) {
            waySegment[0] = new GeoPoint((double)rawLat / 1000000.0, (double)rawLon / 1000000.0);
        }
        int deltaLat = 0;
        int deltaLon = 0;
        for (int pos = 2; pos < length; pos += 2) {
            if (doubleDelta) {
                deltaLat = buffer[pos] + deltaLat;
                deltaLon = buffer[pos + 1] + deltaLon;
            } else {
                deltaLat = buffer[pos];
                deltaLon = buffer[pos + 1];
            }
            rawLat += deltaLat;
            rawLon += deltaLon;
            if (waySegment != null) {
                waySegment[pos / 2] = new GeoPoint((double)rawLat / 1000000.0, (double)rawLon / 1000000.0);
            }
            float lat = this.mTileProjection.projectLat(rawLat);
            float lon = this.mTileProjection.projectLon(rawLon);
            if (pos == length - 2) {
                boolean line;
                boolean bl = line = isLine || lon != firstLon || lat != firstLat;
                if (line) {
                    outBuffer[outPos++] = lon;
                    outBuffer[outPos++] = lat;
                    cnt += 2;
                }
                if (e.type != GeometryBuffer.GeometryType.NONE) continue;
                e.type = line ? GeometryBuffer.GeometryType.LINE : GeometryBuffer.GeometryType.POLY;
                continue;
            }
            if (lat == pLat && lon == pLon || Parameters.SIMPLIFICATION_TOLERANCE != 0 && !isLine && !e.tags.contains(TAG_ISSEA) && !e.tags.contains(TAG_SEA) && !e.tags.contains(TAG_NOSEA) && deltaLon <= this.minDeltaLon && deltaLon >= -this.minDeltaLon && deltaLat <= this.minDeltaLat && deltaLat >= -this.minDeltaLat) continue;
            outBuffer[outPos++] = pLon = lon;
            outBuffer[outPos++] = pLat = lat;
            cnt += 2;
        }
        e.pointNextPos = outPos;
        return cnt;
    }

    private boolean processWays(QueryParameters queryParameters, ITileDataSink mapDataSink, int numberOfWays, BoundingBox boundingBox, boolean filterRequired, Selector selector, List<Way> ways) {
        Tag[] wayTags = this.mTileSource.fileInfo.wayTags;
        MapElement e = this.mElem;
        int stringsSize = 0;
        this.stringOffset = 0;
        if (this.mTileSource.experimental) {
            stringsSize = this.mReadBuffer.readUnsignedInt();
            this.stringOffset = this.mReadBuffer.getBufferPosition();
            this.mReadBuffer.skipBytes(stringsSize);
        }
        for (int elementCounter = numberOfWays; elementCounter != 0; --elementCounter) {
            int wayDataBlocks;
            boolean hasRef;
            e.tags.clear();
            if (this.mDebugFile) {
                this.mSignatureWay = this.mReadBuffer.readUTF8EncodedString(32);
                if (!this.mSignatureWay.startsWith("---WayStart")) {
                    log.warn("invalid way signature: " + this.mSignatureWay);
                    log.warn(DEBUG_SIGNATURE_BLOCK + this.mSignatureBlock);
                    return false;
                }
            }
            if (queryParameters.useTileBitmask) {
                if ((elementCounter = this.mReadBuffer.skipWays(queryParameters.queryTileBitmask, elementCounter)) == 0) {
                    return true;
                }
                if (elementCounter < 0) {
                    return false;
                }
                if (this.mTileSource.experimental && this.mReadBuffer.lastTagPosition > 0) {
                    int pos = this.mReadBuffer.getBufferPosition();
                    this.mReadBuffer.setBufferPosition(this.mReadBuffer.lastTagPosition);
                    byte numberOfTags = (byte)(this.mReadBuffer.readByte() & 0xF);
                    if (!this.mReadBuffer.readTags(e.tags, wayTags, numberOfTags)) {
                        return false;
                    }
                    this.mReadBuffer.setBufferPosition(pos);
                }
            } else {
                int wayDataSize = this.mReadBuffer.readUnsignedInt();
                if (wayDataSize < 0) {
                    log.warn("invalid way data size: " + wayDataSize);
                    if (this.mDebugFile) {
                        log.warn(DEBUG_SIGNATURE_BLOCK + this.mSignatureBlock);
                    }
                    log.error("BUG way 2");
                    return false;
                }
                this.mReadBuffer.skipBytes(2);
            }
            byte specialByte = this.mReadBuffer.readByte();
            byte layer = (byte)((specialByte & 0xF0) >>> 4);
            byte numberOfTags = (byte)(specialByte & 0xF);
            if (numberOfTags != 0 && !this.mReadBuffer.readTags(e.tags, wayTags, numberOfTags)) {
                return false;
            }
            byte featureByte = this.mReadBuffer.readByte();
            boolean featureWayDoubleDeltaEncoding = (featureByte & 4) != 0;
            boolean hasName = (featureByte & 0x80) != 0;
            boolean hasHouseNr = (featureByte & 0x40) != 0;
            boolean bl = hasRef = (featureByte & 0x20) != 0;
            if (this.mTileSource.experimental) {
                String str;
                int textPos;
                if (hasName) {
                    textPos = this.mReadBuffer.readUnsignedInt();
                    str = this.mTileSource.extractLocalized(this.mReadBuffer.readUTF8EncodedStringAt(this.stringOffset + textPos));
                    e.tags.add(new Tag("name", str, false));
                }
                if (hasHouseNr) {
                    textPos = this.mReadBuffer.readUnsignedInt();
                    str = this.mReadBuffer.readUTF8EncodedStringAt(this.stringOffset + textPos);
                    e.tags.add(new Tag("addr:housenumber", str, false));
                }
                if (hasRef) {
                    textPos = this.mReadBuffer.readUnsignedInt();
                    str = this.mReadBuffer.readUTF8EncodedStringAt(this.stringOffset + textPos);
                    e.tags.add(new Tag("ref", str, false));
                }
            } else {
                String str;
                if (hasName) {
                    str = this.mTileSource.extractLocalized(this.mReadBuffer.readUTF8EncodedString());
                    e.tags.add(new Tag("name", str, false));
                }
                if (hasHouseNr) {
                    str = this.mReadBuffer.readUTF8EncodedString();
                    e.tags.add(new Tag("addr:housenumber", str, false));
                }
                if (hasRef) {
                    str = this.mReadBuffer.readUTF8EncodedString();
                    e.tags.add(new Tag("ref", str, false));
                }
            }
            int[] labelPosition = null;
            if ((featureByte & 0x10) != 0) {
                labelPosition = this.readOptionalLabelPosition();
            }
            if ((featureByte & 8) != 0) {
                wayDataBlocks = this.mReadBuffer.readUnsignedInt();
                if (wayDataBlocks < 1) {
                    log.warn("invalid number of way data blocks: " + wayDataBlocks);
                    this.logDebugSignatures();
                    return false;
                }
            } else {
                wayDataBlocks = 1;
            }
            boolean linearFeature = !OSMUtils.isArea(e);
            for (int wayDataBlock = 0; wayDataBlock < wayDataBlocks; ++wayDataBlock) {
                int i;
                e.clear();
                ArrayList<GeoPoint[]> wayNodes = null;
                if (ways != null) {
                    wayNodes = new ArrayList<GeoPoint[]>();
                }
                if (!this.processWayDataBlock(e, featureWayDoubleDeltaEncoding, linearFeature, wayNodes, labelPosition)) {
                    return false;
                }
                if (e.isPoly() && e.index[0] < 6) continue;
                if (labelPosition != null && wayDataBlock == 0) {
                    e.setLabelPosition(this.mTileProjection.projectLon(labelPosition[0]), this.mTileProjection.projectLat(labelPosition[1]));
                } else {
                    e.labelPosition = null;
                }
                if (Parameters.POLY_CENTROID && e.labelPosition == null) {
                    float x = 0.0f;
                    float y = 0.0f;
                    int n = e.index[0];
                    i = 0;
                    while (i < n) {
                        x += e.points[i++];
                        y += e.points[i++];
                    }
                    e.setCentroidPosition(x /= (float)(n / 2), y /= (float)(n / 2));
                }
                if (!e.tags.containsKey("building") && !e.tags.containsKey("building:part") ? !this.mTileClipper.clip(e) : queryParameters.queryZoomLevel >= 17 && !this.mTileSeparator.separate(e)) continue;
                e.simplify(1.0f, true);
                e.setLayer(layer);
                if (ways != null) {
                    BoundingBox wayFilterBbox = boundingBox.extendMeters(wayFilterDistance);
                    GeoPoint[][] wayNodesArray = (GeoPoint[][])wayNodes.toArray((T[])new GeoPoint[wayNodes.size()][]);
                    if (!filterRequired || !wayFilterEnabled || wayFilterBbox.intersectsArea(wayNodesArray)) {
                        ArrayList<Tag> tags = new ArrayList<Tag>();
                        for (i = 0; i < e.tags.size(); ++i) {
                            tags.add(e.tags.get(i));
                        }
                        if (Selector.ALL == selector || hasName || hasHouseNr || hasRef || this.wayAsLabelTagFilter(tags)) {
                            GeoPoint labelPos = labelPosition != null ? new GeoPoint((double)labelPosition[1] / 1000000.0, (double)labelPosition[0] / 1000000.0) : null;
                            ways.add(new Way(layer, tags, wayNodesArray, labelPos, e.type));
                        }
                    }
                }
                if (mapDataSink == null) continue;
                mapDataSink.process(e);
            }
        }
        return true;
    }

    public MapReadResult readLabels(Tile tile) {
        return this.readMapData(tile, tile, Selector.LABELS);
    }

    public MapReadResult readLabels(Tile upperLeft, Tile lowerRight) {
        return this.readMapData(upperLeft, lowerRight, Selector.LABELS);
    }

    public MapReadResult readMapData(Tile tile) {
        return this.readMapData(tile, tile, Selector.ALL);
    }

    public MapReadResult readMapData(Tile upperLeft, Tile lowerRight) {
        return this.readMapData(upperLeft, lowerRight, Selector.ALL);
    }

    private MapReadResult readMapData(Tile upperLeft, Tile lowerRight, Selector selector) {
        if (this.mTileSource.fileHeader == null) {
            return null;
        }
        MapReadResult mapReadResult = new MapReadResult();
        if (this.mIntBuffer == null) {
            this.mIntBuffer = new int[65534];
        }
        try {
            this.mTileProjection.setTile(upperLeft);
            QueryParameters queryParameters = new QueryParameters();
            queryParameters.queryZoomLevel = this.mTileSource.fileHeader.getQueryZoomLevel(upperLeft.zoomLevel);
            SubFileParameter subFileParameter = this.mTileSource.fileHeader.getSubFileParameter(queryParameters.queryZoomLevel);
            if (subFileParameter == null) {
                log.warn("no sub-file for zoom level: " + queryParameters.queryZoomLevel);
                return null;
            }
            QueryCalculations.calculateBaseTiles(queryParameters, upperLeft, lowerRight, subFileParameter);
            QueryCalculations.calculateBlocks(queryParameters, subFileParameter);
            this.processBlocks(queryParameters, subFileParameter, Tile.getBoundingBox(upperLeft, lowerRight), selector, mapReadResult);
        }
        catch (IOException e) {
            log.error(e.getMessage());
            return null;
        }
        return mapReadResult;
    }

    private int[] readOptionalLabelPosition() {
        int[] labelPosition = new int[2];
        labelPosition[1] = this.mReadBuffer.readSignedInt();
        labelPosition[0] = this.mReadBuffer.readSignedInt();
        return labelPosition;
    }

    public MapReadResult readPoiData(Tile tile) {
        return this.readMapData(tile, tile, Selector.POIS);
    }

    public MapReadResult readPoiData(Tile upperLeft, Tile lowerRight) {
        return this.readMapData(upperLeft, lowerRight, Selector.POIS);
    }

    private int[][] readZoomTable(SubFileParameter subFileParameter) {
        int rows = subFileParameter.zoomLevelMax - subFileParameter.zoomLevelMin + 1;
        int[][] zoomTable = new int[rows][2];
        int cumulatedNumberOfPois = 0;
        int cumulatedNumberOfWays = 0;
        for (int row = 0; row < rows; ++row) {
            zoomTable[row][0] = cumulatedNumberOfPois += this.mReadBuffer.readUnsignedInt();
            zoomTable[row][1] = cumulatedNumberOfWays += this.mReadBuffer.readUnsignedInt();
        }
        return zoomTable;
    }

    public void restrictToZoomRange(int minZoom, int maxZoom) {
        this.zoomLevelMax = maxZoom;
        this.zoomLevelMin = minZoom;
    }

    public boolean supportsTile(Tile tile) {
        return tile.getBoundingBox().intersects(this.mTileSource.getMapInfo().boundingBox) && tile.zoomLevel >= this.zoomLevelMin && tile.zoomLevel <= this.zoomLevelMax;
    }

    public boolean wayAsLabelTagFilter(List<Tag> tags) {
        return false;
    }

    static class TileProjection {
        private static final double COORD_SCALE = 1000000.0;
        long dx;
        long dy;
        double divx;
        double divy;

        TileProjection() {
        }

        void setTile(Tile tile) {
            long x = tile.tileX * Tile.SIZE;
            long y = tile.tileY * Tile.SIZE + Tile.SIZE;
            long mapExtents = Tile.SIZE << tile.zoomLevel;
            this.dx = x - (mapExtents >> 1);
            this.dy = y - (mapExtents >> 1);
            this.divx = 1.8E8 / (double)(mapExtents >> 1);
            this.divy = Math.PI * 2 / (double)(mapExtents >> 1);
        }

        public void projectPoint(int lat, int lon, MapElement out) {
            out.clear();
            out.startPoints();
            out.addPoint(this.projectLon(lon), this.projectLat(lat));
        }

        public float projectLat(double lat) {
            double s = Math.sin(lat * 1.7453292519943295E-8);
            double r = Math.log((1.0 + s) / (1.0 - s));
            return (float)Tile.SIZE - (float)(r / this.divy + (double)this.dy);
        }

        public float projectLon(double lon) {
            return (float)(lon / this.divx - (double)this.dx);
        }

        void project(MapElement e) {
            float[] coords = e.points;
            int[] indices = e.index;
            int inPos = 0;
            int outPos = 0;
            boolean isPoly = e.isPoly();
            for (int len : indices) {
                if (len == 0) continue;
                if (len < 0) break;
                float pLon = 0.0f;
                float pLat = 0.0f;
                int cnt = 0;
                int first = outPos;
                int end = inPos + len;
                while (inPos < end) {
                    float lon = this.projectLon(coords[inPos]);
                    float lat = this.projectLat(coords[inPos + 1]);
                    if (cnt == 0 || lat != pLat || lon != pLon) {
                        coords[outPos++] = pLon = lon;
                        coords[outPos++] = pLat = lat;
                        cnt += 2;
                    }
                    inPos += 2;
                }
                if (isPoly && coords[first] == pLon && coords[first + 1] == pLat) {
                    indices[idx] = (short)(cnt - 2);
                    outPos -= 2;
                    continue;
                }
                indices[idx] = (short)cnt;
            }
            if (e.labelPosition != null) {
                e.labelPosition.x = this.projectLon(e.labelPosition.x);
                e.labelPosition.y = this.projectLat(e.labelPosition.y);
            }
            if (e.centroidPosition != null) {
                e.centroidPosition.x = this.projectLon(e.centroidPosition.x);
                e.centroidPosition.y = this.projectLat(e.centroidPosition.y);
            }
        }
    }

    private static enum Selector {
        ALL,
        POIS,
        LABELS;

    }
}

