/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.tiling.source.mapfile.header;

import org.oscim.core.GeoPoint;
import org.oscim.tiling.TileSource;
import org.oscim.tiling.source.mapfile.ReadBuffer;
import org.oscim.tiling.source.mapfile.header.MapFileInfoBuilder;

final class OptionalFields {
    private static final int HEADER_BITMASK_COMMENT = 8;
    private static final int HEADER_BITMASK_CREATED_BY = 4;
    private static final int HEADER_BITMASK_DEBUG = 128;
    private static final int HEADER_BITMASK_LANGUAGES_PREFERENCE = 16;
    private static final int HEADER_BITMASK_START_POSITION = 64;
    private static final int HEADER_BITMASK_START_ZOOM_LEVEL = 32;
    private static final int START_ZOOM_LEVEL_MAX = 22;
    String comment;
    String createdBy;
    final boolean hasComment;
    final boolean hasCreatedBy;
    final boolean hasLanguagesPreference;
    final boolean hasStartPosition;
    final boolean hasStartZoomLevel;
    final boolean isDebugFile;
    String languagesPreference;
    GeoPoint startPosition;
    Byte startZoomLevel;

    static TileSource.OpenResult readOptionalFields(ReadBuffer readBuffer, MapFileInfoBuilder mapFileInfoBuilder) {
        OptionalFields optionalFields;
        mapFileInfoBuilder.optionalFields = optionalFields = new OptionalFields(readBuffer.readByte());
        TileSource.OpenResult openResult = optionalFields.readOptionalFields(readBuffer);
        if (!openResult.isSuccess()) {
            return openResult;
        }
        return TileSource.OpenResult.SUCCESS;
    }

    private OptionalFields(byte flags) {
        this.isDebugFile = (flags & 0x80) != 0;
        this.hasStartPosition = (flags & 0x40) != 0;
        this.hasStartZoomLevel = (flags & 0x20) != 0;
        this.hasLanguagesPreference = (flags & 0x10) != 0;
        this.hasComment = (flags & 8) != 0;
        this.hasCreatedBy = (flags & 4) != 0;
    }

    private TileSource.OpenResult readLanguagesPreference(ReadBuffer readBuffer) {
        if (this.hasLanguagesPreference) {
            this.languagesPreference = readBuffer.readUTF8EncodedString();
        }
        return TileSource.OpenResult.SUCCESS;
    }

    private TileSource.OpenResult readMapStartPosition(ReadBuffer readBuffer) {
        if (this.hasStartPosition) {
            int mapStartLatitude = readBuffer.readInt();
            if (mapStartLatitude < -90000000 || mapStartLatitude > 90000000) {
                return new TileSource.OpenResult("invalid map start latitude: " + mapStartLatitude);
            }
            int mapStartLongitude = readBuffer.readInt();
            if (mapStartLongitude < -180000000 || mapStartLongitude > 180000000) {
                return new TileSource.OpenResult("invalid map start longitude: " + mapStartLongitude);
            }
            this.startPosition = new GeoPoint(mapStartLatitude, mapStartLongitude);
        }
        return TileSource.OpenResult.SUCCESS;
    }

    private TileSource.OpenResult readMapStartZoomLevel(ReadBuffer readBuffer) {
        if (this.hasStartZoomLevel) {
            byte mapStartZoomLevel = readBuffer.readByte();
            if (mapStartZoomLevel < 0 || mapStartZoomLevel > 22) {
                return new TileSource.OpenResult("invalid map start zoom level: " + mapStartZoomLevel);
            }
            this.startZoomLevel = mapStartZoomLevel;
        }
        return TileSource.OpenResult.SUCCESS;
    }

    private TileSource.OpenResult readOptionalFields(ReadBuffer readBuffer) {
        TileSource.OpenResult openResult = this.readMapStartPosition(readBuffer);
        if (!openResult.isSuccess()) {
            return openResult;
        }
        openResult = this.readMapStartZoomLevel(readBuffer);
        if (!openResult.isSuccess()) {
            return openResult;
        }
        openResult = this.readLanguagesPreference(readBuffer);
        if (!openResult.isSuccess()) {
            return openResult;
        }
        if (this.hasComment) {
            this.comment = readBuffer.readUTF8EncodedString();
        }
        if (this.hasCreatedBy) {
            this.createdBy = readBuffer.readUTF8EncodedString();
        }
        return TileSource.OpenResult.SUCCESS;
    }
}

