/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.PriorityQueue;
import org.oscim.core.Box;
import org.oscim.core.Point;
import org.oscim.utils.Partition;
import org.oscim.utils.SpatialIndex;
import org.oscim.utils.pool.Inlist;
import org.oscim.utils.pool.SyncPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RTree<T>
implements SpatialIndex<T>,
Iterable<T> {
    static final Logger log = LoggerFactory.getLogger(RTree.class);
    static final int MAXNODES = 8;
    static final int MINNODES = 4;
    static final int NUMDIMS = 2;
    static final boolean DEBUG = true;
    protected Node mRoot;
    private final Partition mLocalVars = new Partition(8, 4);
    private Rect mTmpRect = new Rect();
    public int nodesAlloc;
    public int nodesFree;
    private final ArrayList<Node> mReinsertNodes = new ArrayList();
    static final int MAX_STACK = 32;
    SyncPool<Stack> stackPool = new SyncPool<Stack>(10){

        @Override
        protected Stack createItem() {
            return new Stack();
        }

        @Override
        protected boolean clearItem(Stack item) {
            if (item.tos != 0) {
                item.tos = 0;
                Arrays.fill(item.nodes, null);
            }
            return true;
        }
    };

    private Rect getRect() {
        if (this.mTmpRect == null) {
            return new Rect();
        }
        Rect r = this.mTmpRect;
        this.mTmpRect = null;
        return r;
    }

    private void releaseRect(Rect r) {
        this.mTmpRect = r;
    }

    public RTree() {
        this.mRoot = this.allocNode();
        this.mRoot.level = 0;
    }

    public void insert(double[] min, double[] max, T item) {
        Rect r = this.getRect();
        r.set(min, max);
        this.insertRect(r, item, 0);
        this.releaseRect(r);
    }

    @Override
    public void insert(Box box, T item) {
        Rect r = this.getRect();
        r.set(box);
        this.insertRect(r, item, 0);
        this.releaseRect(r);
    }

    public boolean remove(double[] min, double[] max, T item) {
        Rect r = this.getRect();
        r.set(min, max);
        boolean removed = this.removeRect(r, item);
        this.releaseRect(r);
        return removed;
    }

    @Override
    public boolean remove(Box box, T item) {
        Rect r = this.getRect();
        r.set(box);
        boolean removed = this.removeRect(r, item);
        this.releaseRect(r);
        return removed;
    }

    public boolean search(double[] min, double[] max, SpatialIndex.SearchCb<T> cb, Object context) {
        Rect r = this.getRect();
        r.set(min, max);
        this.searchStack(r, cb, context);
        this.releaseRect(r);
        return true;
    }

    @Override
    public boolean search(Box bbox, SpatialIndex.SearchCb<T> cb, Object context) {
        Rect r = this.getRect();
        r.set(bbox);
        this.searchStack(r, cb, context);
        this.releaseRect(r);
        return true;
    }

    @Override
    public List<T> search(Box bbox, List<T> results) {
        if (results == null) {
            results = new ArrayList<T>(16);
        }
        Rect r = this.getRect();
        r.set(bbox);
        this.searchStack(r, results);
        this.releaseRect(r);
        return results;
    }

    @Override
    public List<T> searchKNearestNeighbors(Point center, int k, double maxDistance, List<T> results) {
        if (results == null) {
            results = new ArrayList<T>(16);
        }
        PriorityQueue<KnnItem> queue = new PriorityQueue<KnnItem>();
        double maxSquareDistance = maxDistance * maxDistance;
        Node node = this.mRoot;
        while (node != null) {
            for (int idx = 0; idx < node.count; ++idx) {
                Branch<?>[] branch = node.branch;
                double squareDistance = branch[idx].squareDistance(center);
                if (!(squareDistance <= maxSquareDistance)) continue;
                KnnItem knnItem = new KnnItem();
                knnItem.branch = branch[idx];
                knnItem.isLeaf = node.level == 0;
                knnItem.squareDistance = squareDistance;
                queue.add(knnItem);
            }
            while (!queue.isEmpty() && ((KnnItem)queue.peek()).isLeaf) {
                KnnItem knnItem = (KnnItem)queue.poll();
                results.add(knnItem.branch.node);
                if (results.size() != k) continue;
                return results;
            }
            KnnItem knnItem = (KnnItem)queue.poll();
            if (knnItem != null) {
                node = (Node)knnItem.branch.node;
                continue;
            }
            node = null;
        }
        return results;
    }

    @Override
    public void searchKNearestNeighbors(Point center, int k, double maxDistance, SpatialIndex.SearchCb<T> cb, Object context) {
        List<T> results = this.searchKNearestNeighbors(center, k, maxDistance, null);
        for (T result : results) {
            cb.call(result, context);
        }
    }

    @Override
    public int size() {
        int[] count = new int[]{0};
        this.countRec(this.mRoot, count);
        return count[0];
    }

    private void countRec(Node node, int[] count) {
        if (node.isLeaf()) {
            count[0] = count[0] + node.count;
            return;
        }
        Branch<Node>[] children = node.children();
        for (int idx = 0; idx < node.count; ++idx) {
            this.countRec((Node)children[idx].node, count);
        }
    }

    @Override
    public void clear() {
        this.reset();
        this.mRoot = this.allocNode();
        this.mRoot.level = 0;
    }

    void reset() {
        this.removeAllRec(this.mRoot);
    }

    void removeAllRec(Node node) {
        assert (node != null);
        assert (node.level >= 0);
        if (!node.isLeaf()) {
            Branch<Node>[] children = node.children();
            for (int idx = 0; idx < node.count; ++idx) {
                this.removeAllRec((Node)children[idx].node);
            }
        }
        this.freeNode(node);
    }

    public void printStats() {
        System.out.println("nodes alloc:\t" + this.nodesAlloc);
        System.out.println("nodes free:\t" + this.nodesFree);
    }

    Node allocNode() {
        ++this.nodesAlloc;
        Node newNode = new Node(8);
        return newNode;
    }

    void freeNode(Node node) {
        ++this.nodesFree;
        assert (node != null);
    }

    private Node insertRectRec(Rect rect, T item, Node node, int level) {
        if (node.level > level) {
            int idx = this.pickBranch(node, rect);
            Branch<Node>[] children = node.children();
            Node newNode = this.insertRectRec(rect, item, (Node)children[idx].node, level);
            if (newNode != null) {
                node.branch[idx].setCover((Node)children[idx].node);
                Branch branch = new Branch();
                branch.node = newNode;
                branch.setCover(newNode);
                if (node.addBranch(branch)) {
                    return this.splitNode(node, branch);
                }
                return null;
            }
            node.branch[idx].add(rect);
            return null;
        }
        assert (node.level == level);
        Branch branch = new Branch();
        branch.set(rect);
        branch.node = item;
        if (node.addBranch(branch)) {
            return this.splitNode(node, branch);
        }
        return null;
    }

    static final double mergedArea(Rect a, Rect b) {
        return (a.xmax > b.xmax ? a.xmax : b.xmax) - (a.xmin < b.xmin ? a.xmin : b.xmin) * ((a.ymax > b.ymax ? a.ymax : b.ymax) - (a.ymin < b.ymin ? a.ymin : b.ymin));
    }

    int pickBranch(Node node, Rect rect) {
        boolean firstTime = true;
        double bestIncr = -1.0;
        double bestArea = 0.0;
        int best = 0;
        for (int idx = 0; idx < node.count; ++idx) {
            Branch<?> curRect = node.branch[idx];
            double area = curRect.calcRectVolume();
            double increase = RTree.mergedArea(rect, curRect) - area;
            if (increase < bestIncr || firstTime) {
                best = idx;
                bestArea = area;
                bestIncr = increase;
                firstTime = false;
                continue;
            }
            if (increase != bestIncr || !(area < bestArea)) continue;
            best = idx;
            bestArea = area;
            bestIncr = increase;
        }
        return best;
    }

    public boolean insertRect(Rect rect, T item, int level) {
        Node root = this.mRoot;
        Node newNode = this.insertRectRec(rect, item, root, level);
        if (newNode != null) {
            Node newRoot = this.allocNode();
            newRoot.level = root.level + 1;
            Branch branch = new Branch();
            branch.setCover(root);
            branch.node = root;
            newRoot.addBranch(branch);
            branch = new Branch();
            branch.setCover(newNode);
            branch.node = newNode;
            newRoot.addBranch(branch);
            this.mRoot = newRoot;
            return true;
        }
        return false;
    }

    void disconnectBranch(Node node, int idx) {
        assert (node != null && idx >= 0 && idx < 8);
        assert (node.count > 0);
        --node.count;
        if (node.count != idx) {
            node.branch[idx] = node.branch[node.count];
        }
        node.branch[node.count] = null;
    }

    Node splitNode(Node node, Branch<?> branch) {
        assert (node != null);
        assert (branch != null);
        Partition partition = this.mLocalVars.clear();
        int level = node.level;
        partition.getBranches(node, branch);
        partition.choosePartition();
        Node newNode = this.allocNode();
        newNode.level = node.level = level;
        partition.loadNodes(node, newNode);
        assert (node.count + newNode.count == partition.total);
        for (int i = node.count; i < 8; ++i) {
            node.branch[i] = null;
        }
        return newNode;
    }

    public boolean removeRect(Rect rect, T item) {
        Node root = this.mRoot;
        ArrayList<Node> reInsertList = this.mReinsertNodes;
        if (this.removeRectRec(rect, item, root, reInsertList)) {
            for (Node node : reInsertList) {
                for (int idx = 0; idx < node.count; ++idx) {
                    this.insertRect(node.branch[idx], node.branch[idx].node, node.level);
                }
                this.freeNode(node);
            }
            reInsertList.clear();
            if (root.count == 1 && !root.isLeaf()) {
                Node tempNode = (Node)root.children()[0].node;
                assert (tempNode != null);
                this.freeNode(root);
                this.mRoot = tempNode;
            }
            return true;
        }
        return false;
    }

    private boolean removeRectRec(Rect rect, T item, Node node, ArrayList<Node> removed) {
        assert (rect != null && node != null && removed != null);
        assert (node.level >= 0);
        if (node.isLeaf()) {
            for (int idx = 0; idx < node.count; ++idx) {
                if (node.branch[idx].node != item) continue;
                this.disconnectBranch(node, idx);
                return true;
            }
            return false;
        }
        for (int idx = 0; idx < node.count; ++idx) {
            if (!rect.overlap(node.branch[idx])) continue;
            Branch<Node>[] children = node.children();
            if (!this.removeRectRec(rect, item, (Node)children[idx].node, removed)) continue;
            if (((Node)children[idx].node).count >= 4) {
                children[idx].setCover((Node)children[idx].node);
            } else {
                removed.add((Node)children[idx].node);
                this.disconnectBranch(node, idx);
            }
            return true;
        }
        return false;
    }

    public void searchStack(Rect rect, SpatialIndex.SearchCb<T> cb, Object context) {
        Stack stack = this.stackPool.get();
        stack.push(this.mRoot, 0);
        block0: while (!stack.empty()) {
            int i;
            int idx;
            stack.pop();
            Node node = stack.node();
            if (node.level == 0) {
                for (idx = 0; idx < node.count; ++idx) {
                    Branch<?>[] branch = node.branch;
                    if (rect.overlap(branch[idx]) && !cb.call(branch[idx].node, context)) break block0;
                }
                continue;
            }
            idx = stack.branchIndex();
            for (i = idx + 1; i < node.count; ++i) {
                if (!rect.overlap(node.branch[i])) continue;
                stack.push(node, i);
                break;
            }
            node = (Node)node.branch[idx].node;
            for (i = 0; i < node.count; ++i) {
                if (!rect.overlap(node.branch[i])) continue;
                stack.push(node, i);
                continue block0;
            }
        }
        this.stackPool.release(stack);
    }

    public boolean searchStack(Rect rect, List<T> results) {
        List<T> out = results;
        Stack stack = this.stackPool.get();
        stack.push(this.mRoot, 0);
        block0: while (!stack.empty()) {
            int i;
            int idx;
            stack.pop();
            Node node = stack.node();
            if (node.level == 0) {
                for (idx = 0; idx < node.count; ++idx) {
                    if (!rect.overlap(node.branch[idx])) continue;
                    out.add(node.branch[idx].node);
                }
                continue;
            }
            idx = stack.branchIndex();
            for (i = idx + 1; i < node.count; ++i) {
                if (!rect.overlap(node.branch[i])) continue;
                stack.push(node, i);
                break;
            }
            node = (Node)node.branch[idx].node;
            for (i = 0; i < node.count; ++i) {
                if (!rect.overlap(node.branch[i])) continue;
                stack.push(node, i);
                continue block0;
            }
        }
        this.stackPool.release(stack);
        return true;
    }

    @Override
    public java.util.Iterator<T> iterator() {
        return new Iterator(this.mRoot);
    }

    public static class Iterator<T>
    implements java.util.Iterator<T> {
        final StackElement[] stack = new StackElement[32];
        int tos;

        Iterator(Node root) {
            for (int i = 0; i < 32; ++i) {
                this.stack[i] = new StackElement();
            }
            this.push(root, 0);
            this.findNextData();
        }

        boolean isNull() {
            return this.tos <= 0;
        }

        boolean isNotNull() {
            return this.tos > 0;
        }

        @Override
        public T next() {
            assert (this.isNotNull());
            StackElement curTos = this.stack[this.tos - 1];
            Object result = curTos.node.branch[curTos.branchIndex].node;
            ++curTos.branchIndex;
            this.findNextData();
            return (T)result;
        }

        boolean findNextData() {
            while (true) {
                if (this.tos <= 0) {
                    return false;
                }
                StackElement curTos = this.pop();
                if (curTos.node.isLeaf()) {
                    if (curTos.branchIndex >= curTos.node.count) continue;
                    this.push(curTos.node, curTos.branchIndex);
                    return true;
                }
                int idx = curTos.branchIndex;
                if (idx + 1 < curTos.node.count) {
                    this.push(curTos.node, idx + 1);
                }
                Node nextLevelnode = (Node)curTos.node.branch[idx].node;
                this.push(nextLevelnode, 0);
                if (nextLevelnode.isLeaf()) break;
            }
            return true;
        }

        void push(Node node, int branchIndex) {
            this.stack[this.tos].node = node;
            this.stack[this.tos].branchIndex = branchIndex;
            ++this.tos;
            assert (this.tos <= 32);
        }

        StackElement pop() {
            assert (this.tos > 0);
            --this.tos;
            return this.stack[this.tos];
        }

        @Override
        public boolean hasNext() {
            return this.isNotNull();
        }

        @Override
        public void remove() {
        }
    }

    static class Stack
    extends Inlist<Stack> {
        int tos;
        final Node[] nodes = new Node[32];
        final int[] branchIndex = new int[32];

        Stack() {
        }

        @Override
        void push(Node node, int pos) {
            this.nodes[this.tos] = node;
            this.branchIndex[this.tos] = pos;
            ++this.tos;
            assert (this.tos <= 32);
        }

        boolean pop() {
            assert (this.tos > 0);
            this.nodes[this.tos] = null;
            --this.tos;
            return this.tos >= 0;
        }

        Node node() {
            return this.nodes[this.tos];
        }

        int branchIndex() {
            return this.branchIndex[this.tos];
        }

        boolean empty() {
            return this.tos <= 0;
        }
    }

    static class StackElement {
        Node node;
        int branchIndex;

        StackElement() {
        }
    }

    static class Rect {
        double xmin;
        double ymin;
        double xmax;
        double ymax;

        public Rect() {
        }

        public Rect(Box box) {
            assert (this.xmin <= this.xmax);
            assert (this.ymin <= this.ymax);
            this.xmin = box.xmin;
            this.ymin = box.ymin;
            this.xmax = box.xmax;
            this.ymax = box.ymax;
        }

        public Rect(double[] min, double[] max) {
            for (int index = 0; index < 2; ++index) {
                assert (min[index] <= max[index]);
            }
            this.xmin = min[0];
            this.ymin = min[1];
            this.xmax = max[0];
            this.ymax = max[1];
        }

        double axisDistance(double k, double min, double max) {
            return k < min ? min - k : (k <= max ? 0.0 : k - max);
        }

        public double calcRectVolume() {
            return (this.xmax - this.xmin) * (this.ymax - this.ymin);
        }

        public boolean overlap(Rect other) {
            return !(this.xmin > other.xmax || this.xmax < other.xmin || this.ymin > other.ymax || this.ymax < other.ymin);
        }

        public void combine(Rect rectA, Rect rectB) {
            this.xmin = Math.min(rectA.xmin, rectB.xmin);
            this.ymin = Math.min(rectA.ymin, rectB.ymin);
            this.xmax = Math.max(rectA.xmax, rectB.xmax);
            this.ymax = Math.max(rectA.ymax, rectB.ymax);
        }

        public void add(Rect rect) {
            this.xmin = Math.min(this.xmin, rect.xmin);
            this.ymin = Math.min(this.ymin, rect.ymin);
            this.xmax = Math.max(this.xmax, rect.xmax);
            this.ymax = Math.max(this.ymax, rect.ymax);
        }

        public void set(Rect rect) {
            this.xmin = rect.xmin;
            this.ymin = rect.ymin;
            this.xmax = rect.xmax;
            this.ymax = rect.ymax;
        }

        public void set(double[] min, double[] max) {
            for (int index = 0; index < 2; ++index) {
                assert (min[index] <= max[index]);
            }
            this.xmin = min[0];
            this.ymin = min[1];
            this.xmax = max[0];
            this.ymax = max[1];
        }

        public void set(Box box) {
            assert (box.xmin <= box.xmax);
            assert (box.ymin <= box.ymax);
            this.xmin = box.xmin;
            this.ymin = box.ymin;
            this.xmax = box.xmax;
            this.ymax = box.ymax;
        }

        void setCover(Node node) {
            assert (node != null);
            this.set(node.branch[0]);
            for (int idx = 1; idx < node.count; ++idx) {
                this.add(node.branch[idx]);
            }
        }

        double squareDistance(Point xy) {
            double dx = this.axisDistance(xy.x, this.xmin, this.xmax);
            double dy = this.axisDistance(xy.y, this.ymin, this.ymax);
            return dx * dx + dy * dy;
        }
    }

    static final class Node {
        int level = -1;
        int count;
        final Branch<?>[] branch;

        public Node(int maxnodes) {
            this.branch = new Branch[maxnodes];
        }

        boolean isLeaf() {
            return this.level == 0;
        }

        Branch<Node>[] children() {
            if (this.level == 0) {
                throw new IllegalStateException();
            }
            return this.branch;
        }

        boolean addBranch(Branch<?> branch) {
            assert (branch != null);
            if (this.count < 8) {
                this.branch[this.count] = branch;
                ++this.count;
                return false;
            }
            return true;
        }

        public String toString() {
            return this.count + "/" + Arrays.deepToString(this.branch) + '\n';
        }
    }

    class KnnItem
    implements Comparable<KnnItem> {
        Branch<?> branch;
        boolean isLeaf;
        double squareDistance;

        KnnItem() {
        }

        @Override
        public int compareTo(KnnItem o) {
            return Double.compare(this.squareDistance, o.squareDistance);
        }
    }

    static final class Branch<E>
    extends Rect {
        E node;

        Branch() {
        }

        public String toString() {
            return this.node.toString();
        }
    }
}

