/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.utils.geom;

import org.oscim.core.GeometryBuffer;

public class LineClipper {
    public static final int INSIDE = 0;
    public static final int LEFT = 1;
    public static final int RIGHT = 2;
    public static final int BOTTOM = 4;
    public static final int TOP = 8;
    public static final int OUTSIDE = 15;
    public static final int INTERSECTION = -1;
    private float xmin;
    private float xmax;
    private float ymin;
    private float ymax;
    private int mPrevOutcode;
    private float mPrevX;
    private float mPrevY;
    public float outX1;
    public float outY1;
    public float outX2;
    public float outY2;

    public LineClipper(float minx, float miny, float maxx, float maxy) {
        this.xmin = minx;
        this.ymin = miny;
        this.xmax = maxx;
        this.ymax = maxy;
    }

    public void setRect(float minx, float miny, float maxx, float maxy) {
        this.xmin = minx;
        this.ymin = miny;
        this.xmax = maxx;
        this.ymax = maxy;
    }

    public boolean clipStart(float x0, float y0) {
        this.mPrevX = x0;
        this.mPrevY = y0;
        this.mPrevOutcode = 0;
        if (x0 < this.xmin) {
            this.mPrevOutcode |= 1;
        } else if (x0 > this.xmax) {
            this.mPrevOutcode |= 2;
        }
        if (y0 < this.ymin) {
            this.mPrevOutcode |= 4;
        } else if (y0 > this.ymax) {
            this.mPrevOutcode |= 8;
        }
        return this.mPrevOutcode == 0;
    }

    public int outcode(float x, float y) {
        int outcode = 0;
        if (x < this.xmin) {
            outcode |= 1;
        } else if (x > this.xmax) {
            outcode |= 2;
        }
        if (y < this.ymin) {
            outcode |= 4;
        } else if (y > this.ymax) {
            outcode |= 8;
        }
        return outcode;
    }

    public int clipNext(float x1, float y1) {
        int outcode = 0;
        if (x1 < this.xmin) {
            outcode |= 1;
        } else if (x1 > this.xmax) {
            outcode |= 2;
        }
        if (y1 < this.ymin) {
            outcode |= 4;
        } else if (y1 > this.ymax) {
            outcode |= 8;
        }
        int accept = (this.mPrevOutcode | outcode) == 0 ? 0 : ((this.mPrevOutcode & outcode) != 0 ? 15 : (this.clip(this.mPrevX, this.mPrevY, x1, y1, this.mPrevOutcode, outcode) ? -1 : 15));
        this.mPrevOutcode = outcode;
        this.mPrevX = x1;
        this.mPrevY = y1;
        return accept;
    }

    public int clipSegment(float x1, float y1, float x2, float y2) {
        this.clipStart(x1, y1);
        return this.clipNext(x2, y2);
    }

    private boolean clip(float x0, float y0, float x1, float y1, int outcode0, int outcode1) {
        boolean accept = false;
        while (true) {
            int outcodeOut;
            if ((outcode0 | outcode1) == 0) {
                accept = true;
                break;
            }
            if ((outcode0 & outcode1) != 0) break;
            float x = 0.0f;
            float y = 0.0f;
            int n = outcodeOut = outcode0 == 0 ? outcode1 : outcode0;
            if ((outcodeOut & 8) != 0) {
                x = x0 + (x1 - x0) * (this.ymax - y0) / (y1 - y0);
                y = this.ymax;
            } else if ((outcodeOut & 4) != 0) {
                x = x0 + (x1 - x0) * (this.ymin - y0) / (y1 - y0);
                y = this.ymin;
            } else if ((outcodeOut & 2) != 0) {
                y = y0 + (y1 - y0) * (this.xmax - x0) / (x1 - x0);
                x = this.xmax;
            } else if ((outcodeOut & 1) != 0) {
                y = y0 + (y1 - y0) * (this.xmin - x0) / (x1 - x0);
                x = this.xmin;
            }
            int outcode = 0;
            if (x < this.xmin) {
                outcode |= 1;
            } else if (x > this.xmax) {
                outcode |= 2;
            }
            if (y < this.ymin) {
                outcode |= 4;
            } else if (y > this.ymax) {
                outcode |= 8;
            }
            if (outcodeOut == outcode0) {
                x0 = x;
                y0 = y;
                outcode0 = outcode;
                continue;
            }
            x1 = x;
            y1 = y;
            outcode1 = outcode;
        }
        if (accept) {
            this.outX1 = x0;
            this.outY1 = y0;
            this.outX2 = x1;
            this.outY2 = y1;
        }
        return accept;
    }

    public float[] getLine(float[] out, int offset) {
        if (out == null) {
            return new float[]{this.outX1, this.outY1, this.outX2, this.outY2};
        }
        out[offset + 0] = this.outX1;
        out[offset + 1] = this.outY1;
        out[offset + 2] = this.outX2;
        out[offset + 3] = this.outY2;
        return out;
    }

    public int getPrevOutcode() {
        return this.mPrevOutcode;
    }

    public int clipLine(GeometryBuffer in, GeometryBuffer out) {
        out.clear();
        int pointPos = 0;
        int numLines = 0;
        for (int len : in.index) {
            float y;
            float x;
            boolean inside;
            if (len < 0) break;
            if (len < 4) {
                pointPos += len;
                continue;
            }
            if (len == 0) continue;
            int inPos = pointPos;
            int end = inPos + len;
            if (inside = this.clipStart(x = in.points[inPos++], y = in.points[inPos++])) {
                out.startLine();
                out.addPoint(x, y);
                ++numLines;
            }
            while (inPos < end) {
                int clip;
                if ((clip = this.clipNext(x = in.points[inPos++], y = in.points[inPos++])) == 15) {
                    inside = false;
                    continue;
                }
                if (clip == 0) {
                    out.addPoint(x, y);
                    continue;
                }
                if (inside) {
                    out.addPoint(this.outX2, this.outY2);
                } else {
                    out.startLine();
                    ++numLines;
                    out.addPoint(this.outX1, this.outY1);
                    out.addPoint(this.outX2, this.outY2);
                }
                inside = this.clipStart(x, y);
            }
            pointPos = end;
        }
        return numLines;
    }
}

