/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.core;

import org.oscim.core.GeometryBuffer;
import org.oscim.core.PointF;
import org.oscim.core.TagSet;
import org.oscim.theme.IRenderTheme;

public class MapElement
extends GeometryBuffer {
    public PointF centroidPosition;
    public PointF labelPosition;
    public int layer;
    public final TagSet tags = new TagSet();

    public MapElement() {
        super(1024, 16);
    }

    public MapElement(int numPoints, int numIndices) {
        super(numPoints, numIndices);
    }

    public MapElement(float[] points, int[] index) {
        super(points, index);
    }

    public MapElement(MapElement element) {
        super(element);
        this.tags.set(element.tags.asArray());
        this.centroidPosition = element.centroidPosition;
        this.labelPosition = element.labelPosition;
        this.setLayer(element.layer);
    }

    public Float getHeight(IRenderTheme theme) {
        String res = theme != null ? theme.transformBackwardKey("height") : "height";
        String v = this.tags.getValue(res != null ? res : "height");
        if (v != null) {
            return Float.valueOf(Float.parseFloat(v));
        }
        return null;
    }

    public Float getMinHeight(IRenderTheme theme) {
        String res = theme != null ? theme.transformBackwardKey("min_height") : "min_height";
        String v = this.tags.getValue(res != null ? res : "min_height");
        if (v != null) {
            return Float.valueOf(Float.parseFloat(v));
        }
        return null;
    }

    public boolean isBuilding() {
        return this.tags.containsKey("building") || "building".equals(this.tags.getValue("kind")) || "building".equals(this.tags.getValue("layer"));
    }

    public boolean isBuildingPart() {
        return this.tags.containsKey("building:part") || "building_part".equals(this.tags.getValue("kind")) || "building:part".equals(this.tags.getValue("layer"));
    }

    public void setCentroidPosition(float x, float y) {
        this.centroidPosition = new PointF(x, y);
    }

    public void setLabelPosition(float x, float y) {
        this.labelPosition = new PointF(x, y);
    }

    public void setLayer(int layer) {
        this.layer = layer;
    }

    @Override
    public MapElement clear() {
        this.layer = 5;
        super.clear();
        return this;
    }

    @Override
    public MapElement scale(float scaleX, float scaleY) {
        super.scale(scaleX, scaleY);
        if (this.centroidPosition != null) {
            this.centroidPosition.x *= scaleX;
            this.centroidPosition.y *= scaleY;
        }
        if (this.labelPosition != null) {
            this.labelPosition.x *= scaleX;
            this.labelPosition.y *= scaleY;
        }
        return this;
    }

    @Override
    public MapElement translate(float dx, float dy) {
        super.translate(dx, dy);
        if (this.centroidPosition != null) {
            this.centroidPosition.x += dx;
            this.centroidPosition.y += dy;
        }
        if (this.labelPosition != null) {
            this.labelPosition.x += dx;
            this.labelPosition.y += dy;
        }
        return this;
    }

    @Override
    public String toString() {
        return this.tags.toString() + '\n' + super.toString() + '\n';
    }
}

