/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.layers.tile.bitmap;

import org.oscim.core.MapPosition;
import org.oscim.event.Event;
import org.oscim.layers.tile.TileLayer;
import org.oscim.layers.tile.TileLoader;
import org.oscim.layers.tile.TileManager;
import org.oscim.layers.tile.VectorTileRenderer;
import org.oscim.layers.tile.bitmap.BitmapTileLoader;
import org.oscim.map.Map;
import org.oscim.renderer.bucket.TextureItem;
import org.oscim.tiling.TileSource;
import org.oscim.utils.FastMath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BitmapTileLayer
extends TileLayer {
    protected static final Logger log = LoggerFactory.getLogger(BitmapTileLayer.class);
    private static final int CACHE_LIMIT = 40;
    private float mBitmapAlpha = 1.0f;
    static final int POOL_FILL = 20;
    final TextureItem.TexturePool pool = new TextureItem.TexturePool(20){};

    public BitmapTileLayer(Map map, TileSource tileSource) {
        this(map, tileSource, 40);
    }

    public BitmapTileLayer(Map map, TileSource tileSource, float bitmapAlpha) {
        this(map, tileSource, 40, bitmapAlpha);
    }

    public BitmapTileLayer(Map map, TileSource tileSource, int cacheLimit) {
        this(map, tileSource, cacheLimit, tileSource.getAlpha());
    }

    public BitmapTileLayer(Map map, TileSource tileSource, int cacheLimit, float bitmapAlpha) {
        super(map, new TileManager(map, cacheLimit), new VectorTileRenderer());
        this.mTileManager.setZoomLevel(tileSource.getZoomLevelMin(), tileSource.getZoomLevelMax());
        this.mTileSource = tileSource;
        this.setBitmapAlpha(bitmapAlpha, false);
        this.initLoader(this.getNumLoaders());
        this.setFade(map.getMapPosition());
    }

    public void setBitmapAlpha(float bitmapAlpha, boolean redraw) {
        this.mBitmapAlpha = FastMath.clamp(bitmapAlpha, 0.0f, 1.0f);
        this.tileRenderer().setBitmapAlpha(this.mBitmapAlpha);
        if (redraw) {
            this.map().updateMap(true);
        }
    }

    @Override
    public void onMapEvent(Event event, MapPosition pos) {
        super.onMapEvent(event, pos);
        if (event != Map.POSITION_EVENT) {
            return;
        }
        this.setFade(pos);
    }

    private void setFade(MapPosition pos) {
        FadeStep[] fade = this.mTileSource.getFadeSteps();
        if (fade == null) {
            return;
        }
        float alpha = this.mBitmapAlpha;
        for (FadeStep f : fade) {
            if (pos.scale < f.scaleStart || pos.scale > f.scaleEnd) continue;
            if (f.alphaStart == f.alphaEnd) {
                alpha = f.alphaStart;
                break;
            }
            alpha = (float)((double)f.alphaStart + (pos.getZoom() - f.zoomStart) * (double)(f.alphaEnd - f.alphaStart) / (f.zoomEnd - f.zoomStart));
            break;
        }
        alpha = FastMath.clamp(alpha, 0.0f, 1.0f) * this.mBitmapAlpha;
        this.tileRenderer().setBitmapAlpha(alpha);
    }

    @Override
    protected TileLoader createLoader() {
        return new BitmapTileLoader(this, this.mTileSource);
    }

    @Override
    public void onDetach() {
        super.onDetach();
        this.pool.clear();
    }

    public static class FadeStep {
        public final double scaleStart;
        public final double scaleEnd;
        public final double zoomStart;
        public final double zoomEnd;
        public final float alphaStart;
        public final float alphaEnd;

        public FadeStep(int zoomStart, int zoomEnd, float alphaStart, float alphaEnd) {
            if (zoomEnd < zoomStart) {
                throw new IllegalArgumentException("zoomEnd must be larger than zoomStart");
            }
            this.scaleStart = 1 << zoomStart;
            this.scaleEnd = 1 << zoomEnd;
            this.zoomStart = zoomStart;
            this.zoomEnd = zoomEnd;
            this.alphaStart = alphaStart;
            this.alphaEnd = alphaEnd;
        }

        public FadeStep(double scaleStart, double scaleEnd, float alphaStart, float alphaEnd) {
            if (scaleEnd < scaleStart) {
                throw new IllegalArgumentException("scaleEnd must be larger than scaleStart");
            }
            this.scaleStart = scaleStart;
            this.scaleEnd = scaleEnd;
            this.zoomStart = Math.log(scaleStart) / Math.log(2.0);
            this.zoomEnd = Math.log(scaleEnd) / Math.log(2.0);
            this.alphaStart = alphaStart;
            this.alphaEnd = alphaEnd;
        }
    }
}

