/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.theme;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.oscim.backend.CanvasAdapter;
import org.oscim.backend.Platform;
import org.oscim.backend.canvas.Bitmap;
import org.oscim.renderer.atlas.TextureAtlas;
import org.oscim.renderer.atlas.TextureRegion;
import org.oscim.theme.AtlasRenderTheme;
import org.oscim.theme.IRenderTheme;
import org.oscim.theme.RenderTheme;
import org.oscim.theme.ThemeCallback;
import org.oscim.theme.ThemeFile;
import org.oscim.theme.XmlThemeBuilder;
import org.oscim.theme.rule.Rule;
import org.oscim.theme.styles.RenderStyle;
import org.oscim.theme.styles.SymbolStyle;
import org.oscim.utils.IOUtils;
import org.oscim.utils.TextureAtlasUtils;
import org.xmlpull.v1.XmlPullParser;

public class XmlAtlasThemeBuilder
extends XmlThemeBuilder {
    private final Map<Object, TextureRegion> regionMap;
    private final List<TextureAtlas> atlasList;
    private final Map<Object, Bitmap> bitmapMap = new HashMap<Object, Bitmap>();

    public static IRenderTheme read(ThemeFile theme) throws IRenderTheme.ThemeException {
        return XmlAtlasThemeBuilder.read(theme, null);
    }

    public static IRenderTheme read(ThemeFile theme, ThemeCallback themeCallback) throws IRenderTheme.ThemeException {
        IRenderTheme iRenderTheme;
        InputStream inputStream = null;
        try {
            XmlPullParser pullParser = XmlAtlasThemeBuilder.getXmlPullParserFactory().newPullParser();
            HashMap<Object, TextureRegion> outputMap = new HashMap<Object, TextureRegion>();
            ArrayList<TextureAtlas> atlasList = new ArrayList<TextureAtlas>();
            XmlAtlasThemeBuilder renderThemeHandler = new XmlAtlasThemeBuilder(theme, pullParser, themeCallback, outputMap, atlasList);
            inputStream = theme.getRenderThemeAsStream();
            pullParser.setInput(inputStream, null);
            renderThemeHandler.processRenderTheme();
            TextureAtlasUtils.createTextureRegions(renderThemeHandler.bitmapMap, outputMap, atlasList, true, CanvasAdapter.platform == Platform.IOS);
            iRenderTheme = XmlAtlasThemeBuilder.replaceThemeSymbols(renderThemeHandler.mRenderTheme, outputMap);
        }
        catch (Exception e) {
            try {
                throw new IRenderTheme.ThemeException(e.getMessage());
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(inputStream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly(inputStream);
        return iRenderTheme;
    }

    private static IRenderTheme replaceThemeSymbols(RenderTheme renderTheme, Map<Object, TextureRegion> regionMap) {
        SymbolStyle.SymbolBuilder<?> symbolBuilder = SymbolStyle.builder();
        for (Rule rule : renderTheme.getRules()) {
            XmlAtlasThemeBuilder.replaceRuleSymbols(rule, regionMap, symbolBuilder);
        }
        return renderTheme;
    }

    private static void replaceRuleSymbols(Rule rule, Map<Object, TextureRegion> regionMap, SymbolStyle.SymbolBuilder<?> b) {
        for (RenderStyle style : rule.styles) {
            if (!(style instanceof SymbolStyle)) continue;
            SymbolStyle symbol = (SymbolStyle)style;
            TextureRegion region = regionMap.get(symbol.hash);
            if (region == null) continue;
            rule.styles[i] = ((SymbolStyle.SymbolBuilder)((SymbolStyle.SymbolBuilder)((SymbolStyle.SymbolBuilder)b.set(symbol)).bitmap(null)).texture(region)).build();
        }
        for (Rule subRule : rule.subRules) {
            XmlAtlasThemeBuilder.replaceRuleSymbols(subRule, regionMap, b);
        }
    }

    public XmlAtlasThemeBuilder(ThemeFile theme, XmlPullParser pullParser, Map<Object, TextureRegion> regionMap, List<TextureAtlas> atlasList) {
        this(theme, pullParser, null, regionMap, atlasList);
    }

    public XmlAtlasThemeBuilder(ThemeFile theme, XmlPullParser pullParser, ThemeCallback themeCallback, Map<Object, TextureRegion> regionMap, List<TextureAtlas> atlasList) {
        super(theme, pullParser, themeCallback);
        this.regionMap = regionMap;
        this.atlasList = atlasList;
    }

    @Override
    RenderTheme createTheme(Rule[] rules) {
        return new AtlasRenderTheme(this.mMapBackground, this.mTextScale, rules, this.mLevels, this.mMapsforgeTheme, this.regionMap, this.atlasList);
    }

    @Override
    SymbolStyle buildSymbol(SymbolStyle.SymbolBuilder<?> b, String src, Bitmap bitmap) {
        String absoluteName = CanvasAdapter.getAbsoluteFile(this.mTheme.getRelativePathPrefix(), src).getAbsolutePath();
        int hash = (absoluteName + b.symbolWidth + b.symbolHeight + b.symbolPercent).hashCode();
        this.bitmapMap.put(hash, bitmap);
        return ((SymbolStyle.SymbolBuilder)b.hash(hash)).build();
    }
}

