/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.theme;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.oscim.backend.CanvasAdapter;
import org.oscim.backend.canvas.Bitmap;
import org.oscim.backend.canvas.Canvas;
import org.oscim.backend.canvas.Color;
import org.oscim.backend.canvas.Paint;
import org.oscim.core.Tag;
import org.oscim.renderer.atlas.TextureAtlas;
import org.oscim.renderer.atlas.TextureRegion;
import org.oscim.renderer.bucket.TextureItem;
import org.oscim.theme.IRenderTheme;
import org.oscim.theme.RenderTheme;
import org.oscim.theme.ThemeCallback;
import org.oscim.theme.ThemeFile;
import org.oscim.theme.XmlRenderThemeStyleLayer;
import org.oscim.theme.XmlRenderThemeStyleMenu;
import org.oscim.theme.rule.Rule;
import org.oscim.theme.rule.RuleBuilder;
import org.oscim.theme.styles.AreaStyle;
import org.oscim.theme.styles.CircleStyle;
import org.oscim.theme.styles.ExtrusionStyle;
import org.oscim.theme.styles.LineStyle;
import org.oscim.theme.styles.RenderStyle;
import org.oscim.theme.styles.SymbolStyle;
import org.oscim.theme.styles.TextStyle;
import org.oscim.utils.FastMath;
import org.oscim.utils.IOUtils;
import org.oscim.utils.Parameters;
import org.oscim.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;

public class XmlThemeBuilder {
    private static final Logger log = LoggerFactory.getLogger(XmlThemeBuilder.class);
    private static final int RENDER_THEME_VERSION_MAPSFORGE = 6;
    private static final int RENDER_THEME_VERSION_VTM = 1;
    private static XmlPullParserFactory xmlPullParserFactory = null;
    private static final String ELEMENT_NAME_RENDER_THEME = "rendertheme";
    private static final String ELEMENT_NAME_STYLE_MENU = "stylemenu";
    private static final String ELEMENT_NAME_MATCH_MAPSFORGE = "rule";
    private static final String ELEMENT_NAME_MATCH_VTM = "m";
    private static final String UNEXPECTED_ELEMENT_STACK_NOT_EMPTY = "Stack not empty, unexpected element: ";
    private static final String UNEXPECTED_ELEMENT_RENDERING_INSTRUCTION_PARENT_ELEMENT_MISMATCH = "Rendering instruction:: Parent element mismatch: unexpected element: ";
    private static final String UNEXPECTED_ELEMENT_RULE_PARENT_ELEMENT_MISMATCH = "Rule:: Parent element mismatch: unexpected element: ";
    private static final String UNEXPECTED_ELEMENT_STYLE_PARENT_ELEMENT_MISMATCH = "Style:: Parent element mismatch: unexpected element: ";
    private static final String UNEXPECTED_ELEMENT_ATLAS_PARENT_ELEMENT_MISMATCH = "Atlas:: Parent element mismatch: unexpected element: ";
    private static final String UNEXPECTED_ELEMENT_RECT_PARENT_ELEMENT_MISMATCH = "Rect:: Parent element mismatch: unexpected element: ";
    private static final String UNEXPECTED_ELEMENT_TAG_TRANSFORM_PARENT_ELEMENT_MISMATCH = "Tag transform:: Parent element mismatch: unexpected element: ";
    private static final String LINE_STYLE = "L";
    private static final String OUTLINE_STYLE = "O";
    private static final String AREA_STYLE = "A";
    private static final int DEFAULT_PRIORITY = 0x3FFFFFFF;
    private final ArrayList<RuleBuilder> mRulesList = new ArrayList();
    private final Stack<Element> mElementStack = new Stack();
    private final Stack<RuleBuilder> mRuleStack = new Stack();
    private final Map<String, RenderStyle<?>> mStyles = new HashMap(10);
    private final Map<String, TextStyle.TextBuilder<?>> mTextStyles = new HashMap(10);
    private final Map<String, SymbolStyle.SymbolBuilder<?>> mSymbolStyles = new HashMap(10);
    private final AreaStyle.AreaBuilder<?> mAreaBuilder = AreaStyle.builder();
    private final CircleStyle.CircleBuilder<?> mCircleBuilder = CircleStyle.builder();
    private final ExtrusionStyle.ExtrusionBuilder<?> mExtrusionBuilder = ExtrusionStyle.builder();
    private final LineStyle.LineBuilder<?> mLineBuilder = LineStyle.builder();
    private final SymbolStyle.SymbolBuilder<?> mSymbolBuilder = SymbolStyle.builder();
    private final TextStyle.TextBuilder<?> mTextBuilder = TextStyle.builder();
    private RuleBuilder mCurrentRule;
    private TextureAtlas mTextureAtlas;
    int mLevels = 0;
    int mMapBackground = -1;
    private float mStrokeScale = 1.0f;
    float mTextScale = 1.0f;
    private final XmlPullParser mPullParser;
    private String qName;
    final ThemeFile mTheme;
    private final ThemeCallback mThemeCallback;
    RenderTheme mRenderTheme;
    final boolean mMapsforgeTheme;
    private final float mScale;
    private Set<String> mCategories;
    private XmlRenderThemeStyleLayer mCurrentLayer;
    private XmlRenderThemeStyleMenu mRenderThemeStyleMenu;
    private final Map<String, String> mTransformKeyMap = new HashMap<String, String>();
    private final Map<Tag, Tag> mTransformTagMap = new HashMap<Tag, Tag>();

    public static IRenderTheme read(ThemeFile theme) throws IRenderTheme.ThemeException {
        return XmlThemeBuilder.read(theme, null);
    }

    public static IRenderTheme read(ThemeFile theme, ThemeCallback themeCallback) throws IRenderTheme.ThemeException {
        RenderTheme renderTheme;
        InputStream inputStream = null;
        try {
            XmlPullParser pullParser = XmlThemeBuilder.getXmlPullParserFactory().newPullParser();
            XmlThemeBuilder renderThemeHandler = new XmlThemeBuilder(theme, pullParser, themeCallback);
            inputStream = theme.getRenderThemeAsStream();
            pullParser.setInput(inputStream, null);
            renderThemeHandler.processRenderTheme();
            renderTheme = renderThemeHandler.mRenderTheme;
        }
        catch (Exception e) {
            try {
                throw new IRenderTheme.ThemeException(e.getMessage());
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(inputStream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly(inputStream);
        return renderTheme;
    }

    public static XmlPullParserFactory getXmlPullParserFactory() throws XmlPullParserException {
        if (xmlPullParserFactory == null) {
            xmlPullParserFactory = XmlPullParserFactory.newInstance();
        }
        return xmlPullParserFactory;
    }

    public static void setXmlPullParserFactory(XmlPullParserFactory xmlPullParserFactory) {
        XmlThemeBuilder.xmlPullParserFactory = xmlPullParserFactory;
    }

    private static void logUnknownAttribute(String element, String name, String value, int attributeIndex) {
        log.debug("unknown attribute in element {} {} : {} = {}", new Object[]{element, attributeIndex, name, value});
    }

    public XmlThemeBuilder(ThemeFile theme, XmlPullParser pullParser) {
        this(theme, pullParser, null);
    }

    public XmlThemeBuilder(ThemeFile theme, XmlPullParser pullParser, ThemeCallback themeCallback) {
        this.mTheme = theme;
        this.mPullParser = pullParser;
        this.mThemeCallback = themeCallback;
        this.mMapsforgeTheme = theme.isMapsforgeTheme();
        this.mScale = CanvasAdapter.getScale();
    }

    public void processRenderTheme() throws XmlPullParserException, IOException {
        int eventType = this.mPullParser.getEventType();
        do {
            if (eventType == 0) continue;
            if (eventType == 2) {
                this.startElement();
                continue;
            }
            if (eventType == 3) {
                this.endElement();
                continue;
            }
            if (eventType != 4) continue;
        } while ((eventType = this.mPullParser.next()) != 1);
        this.endDocument();
    }

    public void endDocument() {
        if (this.mMapsforgeTheme) {
            this.mRulesList.add(this.buildingRule());
        }
        Rule[] rules = new Rule[this.mRulesList.size()];
        int n = rules.length;
        for (int i = 0; i < n; ++i) {
            rules[i] = this.mRulesList.get(i).onComplete(this.mMapsforgeTheme ? new int[1] : null);
        }
        this.mRenderTheme = this.createTheme(rules);
        this.mRulesList.clear();
        this.mStyles.clear();
        this.mTextStyles.clear();
        this.mSymbolStyles.clear();
        this.mRuleStack.clear();
        this.mElementStack.clear();
        this.mTextureAtlas = null;
    }

    RenderTheme createTheme(Rule[] rules) {
        return new RenderTheme(this.mMapBackground, this.mTextScale, rules, this.mLevels, this.mTransformKeyMap, this.mTransformTagMap, this.mMapsforgeTheme);
    }

    public void endElement() {
        this.qName = this.mPullParser.getName();
        this.mElementStack.pop();
        if (ELEMENT_NAME_MATCH_MAPSFORGE.equals(this.qName) || ELEMENT_NAME_MATCH_VTM.equals(this.qName)) {
            this.mRuleStack.pop();
            if (this.mRuleStack.empty()) {
                if (this.isVisible(this.mCurrentRule)) {
                    this.mRulesList.add(this.mCurrentRule);
                }
            } else {
                this.mCurrentRule = this.mRuleStack.peek();
            }
        } else if (ELEMENT_NAME_STYLE_MENU.equals(this.qName) && null != this.mTheme.getMenuCallback()) {
            this.mCategories = this.mTheme.getMenuCallback().getCategories(this.mRenderThemeStyleMenu);
        }
    }

    public void startElement() throws IRenderTheme.ThemeException {
        block35: {
            this.qName = this.mPullParser.getName();
            try {
                if (ELEMENT_NAME_RENDER_THEME.equals(this.qName)) {
                    this.checkState(this.qName, Element.RENDER_THEME);
                    this.createRenderTheme(this.qName);
                    break block35;
                }
                if (ELEMENT_NAME_MATCH_MAPSFORGE.equals(this.qName) || ELEMENT_NAME_MATCH_VTM.equals(this.qName)) {
                    this.checkState(this.qName, Element.RULE);
                    RuleBuilder rule = this.createRule(this.qName);
                    if (!this.mRuleStack.empty() && this.isVisible(rule)) {
                        this.mCurrentRule.addSubRule(rule);
                    }
                    this.mCurrentRule = rule;
                    this.mRuleStack.push(this.mCurrentRule);
                    break block35;
                }
                if ("style-text".equals(this.qName)) {
                    this.checkState(this.qName, Element.STYLE);
                    this.handleTextElement(this.qName, true, false);
                    break block35;
                }
                if ("style-symbol".equals(this.qName)) {
                    this.checkState(this.qName, Element.STYLE);
                    this.handleSymbolElement(this.qName, true);
                    break block35;
                }
                if ("style-area".equals(this.qName)) {
                    this.checkState(this.qName, Element.STYLE);
                    this.handleAreaElement(this.qName, true);
                    break block35;
                }
                if ("style-line".equals(this.qName)) {
                    this.checkState(this.qName, Element.STYLE);
                    this.handleLineElement(this.qName, true, false);
                    break block35;
                }
                if ("outline-layer".equals(this.qName)) {
                    this.checkState(this.qName, Element.RENDERING_INSTRUCTION);
                    LineStyle line = this.createLine(null, this.qName, this.mLevels++, true, false);
                    this.mStyles.put(OUTLINE_STYLE + line.style, line);
                    break block35;
                }
                if ("area".equals(this.qName)) {
                    this.checkState(this.qName, Element.RENDERING_INSTRUCTION);
                    this.handleAreaElement(this.qName, false);
                    break block35;
                }
                if ("caption".equals(this.qName)) {
                    this.checkState(this.qName, Element.RENDERING_INSTRUCTION);
                    this.handleTextElement(this.qName, false, true);
                    break block35;
                }
                if ("circle".equals(this.qName)) {
                    this.checkState(this.qName, Element.RENDERING_INSTRUCTION);
                    CircleStyle circle = this.createCircle(this.qName, this.mLevels++);
                    if (this.isVisible(circle)) {
                        this.mCurrentRule.addStyle(circle);
                    }
                    break block35;
                }
                if ("line".equals(this.qName)) {
                    this.checkState(this.qName, Element.RENDERING_INSTRUCTION);
                    this.handleLineElement(this.qName, false, false);
                    break block35;
                }
                if ("text".equals(this.qName) || "pathText".equals(this.qName)) {
                    this.checkState(this.qName, Element.RENDERING_INSTRUCTION);
                    this.handleTextElement(this.qName, false, false);
                    break block35;
                }
                if ("symbol".equals(this.qName)) {
                    this.checkState(this.qName, Element.RENDERING_INSTRUCTION);
                    this.handleSymbolElement(this.qName, false);
                    break block35;
                }
                if ("outline".equals(this.qName)) {
                    this.checkState(this.qName, Element.RENDERING_INSTRUCTION);
                    LineStyle outline = this.createOutline(this.getStringAttribute("use"));
                    if (outline != null && this.isVisible(outline)) {
                        this.mCurrentRule.addStyle(outline);
                    }
                    break block35;
                }
                if ("extrusion".equals(this.qName)) {
                    this.checkState(this.qName, Element.RENDERING_INSTRUCTION);
                    ExtrusionStyle extrusion = this.createExtrusion(this.qName, this.mLevels++);
                    if (this.isVisible(extrusion)) {
                        this.mCurrentRule.addStyle(extrusion);
                    }
                    break block35;
                }
                if ("lineSymbol".equals(this.qName)) {
                    this.checkState(this.qName, Element.RENDERING_INSTRUCTION);
                    this.handleLineElement(this.qName, false, true);
                    break block35;
                }
                if ("atlas".equals(this.qName)) {
                    this.checkState(this.qName, Element.ATLAS);
                    this.createAtlas(this.qName);
                    break block35;
                }
                if ("rect".equals(this.qName)) {
                    this.checkState(this.qName, Element.RECT);
                    this.createTextureRegion(this.qName);
                    break block35;
                }
                if ("cat".equals(this.qName)) {
                    this.checkState(this.qName, Element.RENDERING_STYLE);
                    this.mCurrentLayer.addCategory(this.getStringAttribute("id"));
                    break block35;
                }
                if ("layer".equals(this.qName)) {
                    XmlRenderThemeStyleLayer parentEntry;
                    this.checkState(this.qName, Element.RENDERING_STYLE);
                    boolean enabled = false;
                    if (this.getStringAttribute("enabled") != null) {
                        enabled = Boolean.parseBoolean(this.getStringAttribute("enabled"));
                    }
                    boolean visible = Boolean.parseBoolean(this.getStringAttribute("visible"));
                    this.mCurrentLayer = this.mRenderThemeStyleMenu.createLayer(this.getStringAttribute("id"), visible, enabled);
                    String parent = this.getStringAttribute("parent");
                    if (null != parent && null != (parentEntry = this.mRenderThemeStyleMenu.getLayer(parent))) {
                        for (String cat : parentEntry.getCategories()) {
                            this.mCurrentLayer.addCategory(cat);
                        }
                        for (XmlRenderThemeStyleLayer overlay : parentEntry.getOverlays()) {
                            this.mCurrentLayer.addOverlay(overlay);
                        }
                    }
                    break block35;
                }
                if ("name".equals(this.qName)) {
                    this.checkState(this.qName, Element.RENDERING_STYLE);
                    this.mCurrentLayer.addTranslation(this.getStringAttribute("lang"), this.getStringAttribute("value"));
                    break block35;
                }
                if ("overlay".equals(this.qName)) {
                    this.checkState(this.qName, Element.RENDERING_STYLE);
                    XmlRenderThemeStyleLayer overlay = this.mRenderThemeStyleMenu.getLayer(this.getStringAttribute("id"));
                    if (overlay != null) {
                        this.mCurrentLayer.addOverlay(overlay);
                    }
                    break block35;
                }
                if (ELEMENT_NAME_STYLE_MENU.equals(this.qName)) {
                    this.checkState(this.qName, Element.RENDERING_STYLE);
                    this.mRenderThemeStyleMenu = new XmlRenderThemeStyleMenu(this.getStringAttribute("id"), this.getStringAttribute("defaultlang"), this.getStringAttribute("defaultvalue"));
                    break block35;
                }
                if ("tag-transform".equals(this.qName)) {
                    this.checkState(this.qName, Element.TAG_TRANSFORM);
                    this.tagTransform(this.qName);
                    break block35;
                }
                log.error("unknown element: {}", (Object)this.qName);
                throw new XmlPullParserException("unknown element: " + this.qName);
            }
            catch (IOException | XmlPullParserException e) {
                throw new IRenderTheme.ThemeException(e.getMessage());
            }
        }
    }

    private RuleBuilder createRule(String qName) {
        String cat = null;
        int element = 7;
        int closed = 3;
        String keys = null;
        String values = null;
        byte zoomMin = 0;
        byte zoomMax = 127;
        int selector = 0;
        int n = this.mPullParser.getAttributeCount();
        for (int i = 0; i < n; ++i) {
            String val;
            String name = this.mPullParser.getAttributeName(i);
            String value = this.mPullParser.getAttributeValue(i);
            if ("e".equals(name)) {
                val = value.toUpperCase(Locale.ENGLISH);
                if ("WAY".equals(val)) {
                    element = 6;
                    continue;
                }
                if (!"NODE".equals(val)) continue;
                element = 1;
                continue;
            }
            if ("k".equals(name)) {
                if (this.mMapsforgeTheme) {
                    if ("*".equals(value)) continue;
                    keys = value;
                    continue;
                }
                keys = value;
                continue;
            }
            if ("v".equals(name)) {
                if (this.mMapsforgeTheme) {
                    if ("*".equals(value)) continue;
                    values = value;
                    continue;
                }
                values = value;
                continue;
            }
            if ("cat".equals(name)) {
                cat = value;
                continue;
            }
            if ("closed".equals(name)) {
                val = value.toUpperCase(Locale.ENGLISH);
                if ("YES".equals(val)) {
                    closed = 2;
                    continue;
                }
                if (!"NO".equals(val)) continue;
                closed = 1;
                continue;
            }
            if ("zoom-min".equals(name)) {
                zoomMin = Byte.parseByte(value);
                continue;
            }
            if ("zoom-max".equals(name)) {
                zoomMax = Byte.parseByte(value);
                continue;
            }
            if ("select".equals(name)) {
                if ("first".equals(value)) {
                    selector |= 1;
                }
                if (!"when-matched".equals(value)) continue;
                selector |= 2;
                continue;
            }
            XmlThemeBuilder.logUnknownAttribute(qName, name, value, i);
        }
        if (closed == 2) {
            element = 4;
        } else if (closed == 1) {
            element = 2;
        }
        XmlThemeBuilder.validateNonNegative("zoom-min", zoomMin);
        XmlThemeBuilder.validateNonNegative("zoom-max", zoomMax);
        if (zoomMin > zoomMax) {
            throw new IRenderTheme.ThemeException("zoom-min must be less or equal zoom-max: " + zoomMin);
        }
        RuleBuilder b = RuleBuilder.create(keys, values);
        b.cat(cat);
        b.zoom(zoomMin, zoomMax);
        b.element(element);
        b.select(selector);
        return b;
    }

    private TextureRegion getAtlasRegion(String src) {
        if (this.mTextureAtlas == null) {
            return null;
        }
        TextureRegion texture = this.mTextureAtlas.getTextureRegion(src);
        if (texture == null) {
            log.debug("missing texture atlas item '" + src + "'");
        }
        return texture;
    }

    private void handleLineElement(String qName, boolean isStyle, boolean hasSymbol) {
        String use = this.getStringAttribute("use");
        LineStyle style = null;
        if (use != null && (style = (LineStyle)this.mStyles.get(LINE_STYLE + use)) == null) {
            log.debug("missing line style 'use': " + use);
            return;
        }
        LineStyle line = this.createLine(style, qName, this.mLevels++, false, hasSymbol);
        if (isStyle) {
            this.mStyles.put(LINE_STYLE + line.style, line);
        } else if (this.isVisible(line)) {
            LineStyle outline;
            this.mCurrentRule.addStyle(line);
            String outlineValue = this.getStringAttribute("outline");
            if (outlineValue != null && (outline = this.createOutline(outlineValue)) != null) {
                this.mCurrentRule.addStyle(outline);
            }
        }
    }

    private LineStyle createLine(LineStyle line, String elementName, int level, boolean isOutline, boolean hasSymbol) {
        Bitmap bitmap;
        int height;
        int width;
        Object b = this.mLineBuilder.set(line);
        ((LineStyle.LineBuilder)b).isOutline(isOutline);
        ((RenderStyle.StyleBuilder)b).level(level);
        ((RenderStyle.StyleBuilder)b).themeCallback(this.mThemeCallback);
        String src = null;
        int n = this.mPullParser.getAttributeCount();
        for (int i = 0; i < n; ++i) {
            String name = this.mPullParser.getAttributeName(i);
            String value = this.mPullParser.getAttributeValue(i);
            if ("id".equals(name)) {
                ((LineStyle.LineBuilder)b).style = value;
                continue;
            }
            if ("cat".equals(name)) {
                ((RenderStyle.StyleBuilder)b).cat(value);
                continue;
            }
            if ("src".equals(name)) {
                src = value;
                continue;
            }
            if ("use".equals(name) || "outline".equals(name)) continue;
            if ("stroke".equals(name)) {
                ((RenderStyle.StyleBuilder)b).color(value);
                continue;
            }
            if ("width".equals(name) || "stroke-width".equals(name)) {
                ((LineStyle.LineBuilder)b).strokeWidth = Float.parseFloat(value) * this.mScale * this.mStrokeScale;
                if (line == null) {
                    if (isOutline) continue;
                    XmlThemeBuilder.validateNonNegative("width", ((LineStyle.LineBuilder)b).strokeWidth);
                    continue;
                }
                ((LineStyle.LineBuilder)b).strokeWidth += line.width;
                if (!(((LineStyle.LineBuilder)b).strokeWidth <= 0.0f)) continue;
                ((LineStyle.LineBuilder)b).strokeWidth = 1.0f;
                continue;
            }
            if ("cap".equals(name) || "stroke-linecap".equals(name)) {
                ((LineStyle.LineBuilder)b).cap = Paint.Cap.valueOf(value.toUpperCase(Locale.ENGLISH));
                continue;
            }
            if ("fix".equals(name)) {
                ((LineStyle.LineBuilder)b).fixed = Boolean.parseBoolean(value);
                continue;
            }
            if ("stipple".equals(name)) {
                ((LineStyle.LineBuilder)b).stipple = Math.round((float)Integer.parseInt(value) * this.mScale * this.mStrokeScale);
                continue;
            }
            if ("stipple-stroke".equals(name)) {
                ((LineStyle.LineBuilder)b).stippleColor(value);
                continue;
            }
            if ("stipple-width".equals(name)) {
                ((LineStyle.LineBuilder)b).stippleWidth = Float.parseFloat(value);
                continue;
            }
            if ("fade".equals(name)) {
                ((LineStyle.LineBuilder)b).fadeScale = Integer.parseInt(value);
                continue;
            }
            if ("min".equals(name)) continue;
            if ("blur".equals(name)) {
                ((LineStyle.LineBuilder)b).blur = Float.parseFloat(value);
                continue;
            }
            if ("style".equals(name)) continue;
            if ("dasharray".equals(name) || "stroke-dasharray".equals(name)) {
                ((LineStyle.LineBuilder)b).dashArray = XmlThemeBuilder.parseFloatArray(value);
                for (int j = 0; j < ((LineStyle.LineBuilder)b).dashArray.length; ++j) {
                    ((LineStyle.LineBuilder)b).dashArray[j] = ((LineStyle.LineBuilder)b).dashArray[j] * this.mScale * this.mStrokeScale;
                }
                continue;
            }
            if ("symbol-width".equals(name)) {
                ((LineStyle.LineBuilder)b).symbolWidth = (int)((float)Integer.parseInt(value) * this.mScale);
                continue;
            }
            if ("symbol-height".equals(name)) {
                ((LineStyle.LineBuilder)b).symbolHeight = (int)((float)Integer.parseInt(value) * this.mScale);
                continue;
            }
            if ("symbol-percent".equals(name)) {
                ((LineStyle.LineBuilder)b).symbolPercent = Integer.parseInt(value);
                continue;
            }
            if ("symbol-scaling".equals(name)) continue;
            if ("repeat-start".equals(name)) {
                ((LineStyle.LineBuilder)b).repeatStart = Float.parseFloat(value) * this.mScale;
                continue;
            }
            if ("repeat-gap".equals(name)) {
                ((LineStyle.LineBuilder)b).repeatGap = Float.parseFloat(value) * this.mScale;
                continue;
            }
            XmlThemeBuilder.logUnknownAttribute(elementName, name, value, i);
        }
        if (((LineStyle.LineBuilder)b).dashArray != null) {
            if (((LineStyle.LineBuilder)b).dashArray.length % 2 != 0) {
                float[] newDashArray = new float[((LineStyle.LineBuilder)b).dashArray.length * 2];
                System.arraycopy(((LineStyle.LineBuilder)b).dashArray, 0, newDashArray, 0, ((LineStyle.LineBuilder)b).dashArray.length);
                System.arraycopy(((LineStyle.LineBuilder)b).dashArray, 0, newDashArray, ((LineStyle.LineBuilder)b).dashArray.length, ((LineStyle.LineBuilder)b).dashArray.length);
                ((LineStyle.LineBuilder)b).dashArray = newDashArray;
            }
            width = 0;
            height = (int)((LineStyle.LineBuilder)b).strokeWidth;
            if (height < 1) {
                height = 1;
            }
            for (Object f : (String)((LineStyle.LineBuilder)b).dashArray) {
                if (f < 1.0f) {
                    f = 1.0f;
                }
                width = (int)((float)width + f);
            }
            bitmap = CanvasAdapter.newBitmap(width, height, 0);
            Canvas canvas = CanvasAdapter.newCanvas();
            canvas.setBitmap(bitmap);
            int x = 0;
            boolean transparent = false;
            for (float f : ((LineStyle.LineBuilder)b).dashArray) {
                if (f < 1.0f) {
                    f = 1.0f;
                }
                canvas.fillRectangle(x, 0.0f, f, height, transparent ? 0 : -1);
                x = (int)((float)x + f);
                transparent = !transparent;
            }
            ((LineStyle.LineBuilder)b).texture = new TextureItem(Utils.potBitmap(bitmap));
            ((LineStyle.LineBuilder)b).randomOffset = false;
            ((LineStyle.LineBuilder)b).stipple = width;
            ((LineStyle.LineBuilder)b).stippleWidth = 1.0f;
            ((LineStyle.LineBuilder)b).stippleColor = ((LineStyle.LineBuilder)b).fillColor;
        } else {
            if (src != null) {
                float symbolScale = Parameters.SYMBOL_SCALING == Parameters.SymbolScaling.ALL ? CanvasAdapter.symbolScale : 1.0f;
                ((LineStyle.LineBuilder)b).texture = Utils.loadTexture(this.mTheme.getRelativePathPrefix(), src, ((LineStyle.LineBuilder)b).symbolWidth, ((LineStyle.LineBuilder)b).symbolHeight, (int)((float)((LineStyle.LineBuilder)b).symbolPercent * symbolScale));
            }
            if (((LineStyle.LineBuilder)b).texture != null && hasSymbol) {
                width = (int)((float)((LineStyle.LineBuilder)b).texture.width + ((LineStyle.LineBuilder)b).repeatGap);
                height = ((LineStyle.LineBuilder)b).texture.height;
                bitmap = CanvasAdapter.newBitmap(width, height, 0);
                Canvas canvas = CanvasAdapter.newCanvas();
                canvas.setBitmap(bitmap);
                canvas.drawBitmap(((LineStyle.LineBuilder)b).texture.bitmap, ((LineStyle.LineBuilder)b).repeatStart, 0.0f);
                ((LineStyle.LineBuilder)b).texture = new TextureItem(Utils.potBitmap(bitmap));
                ((LineStyle.LineBuilder)b).fixed = true;
                ((LineStyle.LineBuilder)b).randomOffset = false;
                ((LineStyle.LineBuilder)b).stipple = width;
                ((LineStyle.LineBuilder)b).stippleWidth = 1.0f;
                ((LineStyle.LineBuilder)b).strokeWidth = (float)height * 0.5f;
                ((LineStyle.LineBuilder)b).stippleColor = -1;
            }
        }
        return ((LineStyle.LineBuilder)b).build();
    }

    private void handleAreaElement(String qName, boolean isStyle) {
        String use = this.getStringAttribute("use");
        AreaStyle style = null;
        if (use != null && (style = (AreaStyle)this.mStyles.get(AREA_STYLE + use)) == null) {
            log.debug("missing area style 'use': " + use);
            return;
        }
        AreaStyle area = this.createArea(style, qName, this.mLevels++);
        if (isStyle) {
            this.mStyles.put(AREA_STYLE + area.style, area);
        } else if (this.isVisible(area)) {
            this.mCurrentRule.addStyle(area);
        }
    }

    private AreaStyle createArea(AreaStyle area, String elementName, int level) {
        Object b = this.mAreaBuilder.set(area);
        ((RenderStyle.StyleBuilder)b).level(level);
        ((RenderStyle.StyleBuilder)b).themeCallback(this.mThemeCallback);
        String src = null;
        int n = this.mPullParser.getAttributeCount();
        for (int i = 0; i < n; ++i) {
            String name = this.mPullParser.getAttributeName(i);
            String value = this.mPullParser.getAttributeValue(i);
            if ("id".equals(name)) {
                ((AreaStyle.AreaBuilder)b).style = value;
                continue;
            }
            if ("cat".equals(name)) {
                ((RenderStyle.StyleBuilder)b).cat(value);
                continue;
            }
            if ("use".equals(name)) continue;
            if ("src".equals(name)) {
                src = value;
                continue;
            }
            if ("fill".equals(name)) {
                ((RenderStyle.StyleBuilder)b).color(value);
                continue;
            }
            if ("stroke".equals(name)) {
                ((RenderStyle.StyleBuilder)b).strokeColor(value);
                continue;
            }
            if ("stroke-width".equals(name)) {
                float strokeWidth = Float.parseFloat(value);
                XmlThemeBuilder.validateNonNegative("stroke-width", strokeWidth);
                ((AreaStyle.AreaBuilder)b).strokeWidth = strokeWidth * this.mScale * this.mStrokeScale;
                continue;
            }
            if ("fade".equals(name)) {
                ((AreaStyle.AreaBuilder)b).fadeScale = Integer.parseInt(value);
                continue;
            }
            if ("blend".equals(name)) {
                ((AreaStyle.AreaBuilder)b).blendScale = Integer.parseInt(value);
                continue;
            }
            if ("blend-fill".equals(name)) {
                ((AreaStyle.AreaBuilder)b).blendColor(value);
                continue;
            }
            if ("mesh".equals(name)) {
                ((AreaStyle.AreaBuilder)b).mesh(Boolean.parseBoolean(value));
                continue;
            }
            if ("symbol-width".equals(name)) {
                ((AreaStyle.AreaBuilder)b).symbolWidth = (int)((float)Integer.parseInt(value) * this.mScale);
                continue;
            }
            if ("symbol-height".equals(name)) {
                ((AreaStyle.AreaBuilder)b).symbolHeight = (int)((float)Integer.parseInt(value) * this.mScale);
                continue;
            }
            if ("symbol-percent".equals(name)) {
                ((AreaStyle.AreaBuilder)b).symbolPercent = Integer.parseInt(value);
                continue;
            }
            if ("symbol-scaling".equals(name)) continue;
            XmlThemeBuilder.logUnknownAttribute(elementName, name, value, i);
        }
        if (src != null) {
            ((AreaStyle.AreaBuilder)b).texture = Utils.loadTexture(this.mTheme.getRelativePathPrefix(), src, ((AreaStyle.AreaBuilder)b).symbolWidth, ((AreaStyle.AreaBuilder)b).symbolHeight, ((AreaStyle.AreaBuilder)b).symbolPercent);
        }
        return ((AreaStyle.AreaBuilder)b).build();
    }

    private LineStyle createOutline(String style) {
        LineStyle line;
        if (style != null && (line = (LineStyle)this.mStyles.get(OUTLINE_STYLE + style)) != null && line.outline) {
            String cat = null;
            int n = this.mPullParser.getAttributeCount();
            for (int i = 0; i < n; ++i) {
                String name = this.mPullParser.getAttributeName(i);
                String value = this.mPullParser.getAttributeValue(i);
                if (!"cat".equals(name)) continue;
                cat = value;
                break;
            }
            return (LineStyle)line.setCat(cat);
        }
        log.debug("BUG not an outline style: " + style);
        return null;
    }

    private void createAtlas(String elementName) throws IOException {
        String img = null;
        int n = this.mPullParser.getAttributeCount();
        for (int i = 0; i < n; ++i) {
            String name = this.mPullParser.getAttributeName(i);
            String value = this.mPullParser.getAttributeValue(i);
            if ("img".equals(name)) {
                img = value;
                continue;
            }
            XmlThemeBuilder.logUnknownAttribute(elementName, name, value, i);
        }
        XmlThemeBuilder.validateExists("img", img, elementName);
        Bitmap bitmap = CanvasAdapter.getBitmapAsset(this.mTheme.getRelativePathPrefix(), img);
        if (bitmap != null) {
            this.mTextureAtlas = new TextureAtlas(bitmap);
        }
    }

    private void createTextureRegion(String elementName) {
        if (this.mTextureAtlas == null) {
            return;
        }
        String regionName = null;
        TextureAtlas.Rect r = null;
        int n = this.mPullParser.getAttributeCount();
        for (int i = 0; i < n; ++i) {
            String name = this.mPullParser.getAttributeName(i);
            String value = this.mPullParser.getAttributeValue(i);
            if ("id".equals(name)) {
                regionName = value;
                continue;
            }
            if ("pos".equals(name)) {
                String[] pos = value.split(" ");
                if (pos.length != 4) continue;
                r = new TextureAtlas.Rect(Integer.parseInt(pos[0]), Integer.parseInt(pos[1]), Integer.parseInt(pos[2]), Integer.parseInt(pos[3]));
                continue;
            }
            XmlThemeBuilder.logUnknownAttribute(elementName, name, value, i);
        }
        XmlThemeBuilder.validateExists("id", regionName, elementName);
        XmlThemeBuilder.validateExists("pos", r, elementName);
        this.mTextureAtlas.addTextureRegion(regionName.intern(), r);
    }

    private void checkElement(String elementName, Element element) throws XmlPullParserException {
        switch (element) {
            case RENDER_THEME: {
                if (!this.mElementStack.empty()) {
                    throw new XmlPullParserException(UNEXPECTED_ELEMENT_STACK_NOT_EMPTY + elementName);
                }
                return;
            }
            case RULE: {
                Element parentElement = this.mElementStack.peek();
                if (parentElement != Element.RENDER_THEME && parentElement != Element.RULE) {
                    throw new XmlPullParserException(UNEXPECTED_ELEMENT_RULE_PARENT_ELEMENT_MISMATCH + elementName);
                }
                return;
            }
            case STYLE: {
                Element parentElement = this.mElementStack.peek();
                if (parentElement != Element.RENDER_THEME) {
                    throw new XmlPullParserException(UNEXPECTED_ELEMENT_STYLE_PARENT_ELEMENT_MISMATCH + elementName);
                }
                return;
            }
            case RENDERING_INSTRUCTION: {
                if (this.mElementStack.peek() != Element.RULE) {
                    throw new XmlPullParserException(UNEXPECTED_ELEMENT_RENDERING_INSTRUCTION_PARENT_ELEMENT_MISMATCH + elementName);
                }
                return;
            }
            case ATLAS: {
                Element parentElement = this.mElementStack.peek();
                if (parentElement != Element.RENDER_THEME) {
                    throw new XmlPullParserException(UNEXPECTED_ELEMENT_ATLAS_PARENT_ELEMENT_MISMATCH + elementName);
                }
                return;
            }
            case RECT: {
                Element parentElement = this.mElementStack.peek();
                if (parentElement != Element.ATLAS) {
                    throw new XmlPullParserException(UNEXPECTED_ELEMENT_RECT_PARENT_ELEMENT_MISMATCH + elementName);
                }
                return;
            }
            case RENDERING_STYLE: {
                return;
            }
            case TAG_TRANSFORM: {
                Element parentElement = this.mElementStack.peek();
                if (parentElement != Element.RENDER_THEME) {
                    throw new XmlPullParserException(UNEXPECTED_ELEMENT_TAG_TRANSFORM_PARENT_ELEMENT_MISMATCH + elementName);
                }
                return;
            }
        }
        throw new XmlPullParserException("unknown enum value: " + (Object)((Object)element));
    }

    private void checkState(String elementName, Element element) throws XmlPullParserException {
        this.checkElement(elementName, element);
        this.mElementStack.push(element);
    }

    private void createRenderTheme(String elementName) {
        int renderThemeVersion;
        Integer version = null;
        int mapBackground = -1;
        float baseStrokeWidth = 1.0f;
        float baseTextScale = 1.0f;
        int n = this.mPullParser.getAttributeCount();
        for (int i = 0; i < n; ++i) {
            String name = this.mPullParser.getAttributeName(i);
            String value = this.mPullParser.getAttributeValue(i);
            if ("schemaLocation".equals(name)) continue;
            if ("version".equals(name)) {
                version = Integer.parseInt(value);
                continue;
            }
            if ("map-background".equals(name)) {
                mapBackground = Color.parseColor(value);
                if (this.mThemeCallback == null) continue;
                mapBackground = this.mThemeCallback.getColor(null, mapBackground);
                continue;
            }
            if ("base-stroke-width".equals(name)) {
                baseStrokeWidth = Float.parseFloat(value);
                continue;
            }
            if ("base-text-scale".equals(name) || "base-text-size".equals(name)) {
                baseTextScale = Float.parseFloat(value);
                continue;
            }
            XmlThemeBuilder.logUnknownAttribute(elementName, name, value, i);
        }
        XmlThemeBuilder.validateExists("version", version, elementName);
        int n2 = renderThemeVersion = this.mMapsforgeTheme ? 6 : 1;
        if (version > renderThemeVersion) {
            throw new IRenderTheme.ThemeException("invalid render theme version:" + version);
        }
        XmlThemeBuilder.validateNonNegative("base-stroke-width", baseStrokeWidth);
        XmlThemeBuilder.validateNonNegative("base-text-scale", baseTextScale);
        this.mMapBackground = mapBackground;
        this.mStrokeScale = baseStrokeWidth;
        this.mTextScale = baseTextScale;
    }

    private void handleTextElement(String qName, boolean isStyle, boolean isCaption) {
        String style = this.getStringAttribute("use");
        TextStyle.TextBuilder<?> pt = null;
        if (style != null && (pt = this.mTextStyles.get(style)) == null) {
            log.debug("missing text style: " + style);
            return;
        }
        TextStyle.TextBuilder<?> b = this.createText(qName, isCaption, pt);
        if (isStyle) {
            log.debug("put style {}", (Object)b.style);
            this.mTextStyles.put(b.style, (TextStyle.TextBuilder<?>)TextStyle.builder().from(b));
        } else {
            TextStyle text = b.buildInternal();
            if (this.isVisible(text)) {
                this.mCurrentRule.addStyle(text);
            }
        }
    }

    private TextStyle.TextBuilder<?> createText(String elementName, boolean caption, TextStyle.TextBuilder<?> style) {
        Object b;
        if (style == null) {
            b = this.mTextBuilder.reset();
            ((TextStyle.TextBuilder)b).caption = caption;
        } else {
            b = this.mTextBuilder.from(style);
        }
        ((RenderStyle.StyleBuilder)b).themeCallback(this.mThemeCallback);
        String symbol = null;
        if (this.mMapsforgeTheme) {
            ((TextStyle.TextBuilder)b).priority = 0x3FFFFFFF;
        }
        int n = this.mPullParser.getAttributeCount();
        for (int i = 0; i < n; ++i) {
            String name = this.mPullParser.getAttributeName(i);
            String value = this.mPullParser.getAttributeValue(i);
            if ("id".equals(name)) {
                ((TextStyle.TextBuilder)b).style = value;
                continue;
            }
            if ("cat".equals(name)) {
                ((RenderStyle.StyleBuilder)b).cat(value);
                continue;
            }
            if ("k".equals(name)) {
                ((TextStyle.TextBuilder)b).textKey = value.intern();
                continue;
            }
            if ("font-family".equals(name)) {
                ((TextStyle.TextBuilder)b).fontFamily = Paint.FontFamily.valueOf(value.toUpperCase(Locale.ENGLISH));
                continue;
            }
            if ("style".equals(name) || "font-style".equals(name)) {
                ((TextStyle.TextBuilder)b).fontStyle = Paint.FontStyle.valueOf(value.toUpperCase(Locale.ENGLISH));
                continue;
            }
            if ("size".equals(name) || "font-size".equals(name)) {
                ((TextStyle.TextBuilder)b).fontSize = Float.parseFloat(value);
                continue;
            }
            if ("bg-fill".equals(name)) {
                ((TextStyle.TextBuilder)b).bgFillColor = Color.parseColor(value);
                continue;
            }
            if ("fill".equals(name)) {
                ((TextStyle.TextBuilder)b).fillColor = Color.parseColor(value);
                continue;
            }
            if ("stroke".equals(name)) {
                ((TextStyle.TextBuilder)b).strokeColor = Color.parseColor(value);
                continue;
            }
            if ("stroke-width".equals(name)) {
                ((TextStyle.TextBuilder)b).strokeWidth = Float.parseFloat(value) * this.mScale;
                continue;
            }
            if ("caption".equals(name)) {
                ((TextStyle.TextBuilder)b).caption = Boolean.parseBoolean(value);
                continue;
            }
            if ("priority".equals(name)) {
                ((TextStyle.TextBuilder)b).priority = Integer.parseInt(value);
                if (!this.mMapsforgeTheme) continue;
                ((TextStyle.TextBuilder)b).priority = FastMath.clamp(0x3FFFFFFF - ((TextStyle.TextBuilder)b).priority, 0, Integer.MAX_VALUE);
                continue;
            }
            if ("area-size".equals(name)) {
                ((TextStyle.TextBuilder)b).areaSize = Float.parseFloat(value);
                continue;
            }
            if ("dy".equals(name)) {
                ((TextStyle.TextBuilder)b).dy = -Float.parseFloat(value) * this.mScale * CanvasAdapter.symbolScale;
                continue;
            }
            if ("symbol".equals(name)) {
                symbol = value;
                continue;
            }
            if ("use".equals(name)) continue;
            if ("symbol-width".equals(name)) {
                ((TextStyle.TextBuilder)b).symbolWidth = (int)((float)Integer.parseInt(value) * this.mScale);
                continue;
            }
            if ("symbol-height".equals(name)) {
                ((TextStyle.TextBuilder)b).symbolHeight = (int)((float)Integer.parseInt(value) * this.mScale);
                continue;
            }
            if ("symbol-percent".equals(name)) {
                ((TextStyle.TextBuilder)b).symbolPercent = Integer.parseInt(value);
                continue;
            }
            if ("symbol-scaling".equals(name)) continue;
            if ("position".equals(name)) {
                if (((TextStyle.TextBuilder)b).dy != 0.0f) continue;
                value = "above".equals(value) ? "20" : "-20";
                ((TextStyle.TextBuilder)b).dy = -Float.parseFloat(value) * this.mScale * CanvasAdapter.symbolScale;
                continue;
            }
            XmlThemeBuilder.logUnknownAttribute(elementName, name, value, i);
        }
        XmlThemeBuilder.validateExists("k", ((TextStyle.TextBuilder)b).textKey, elementName);
        XmlThemeBuilder.validateNonNegative("size", ((TextStyle.TextBuilder)b).fontSize);
        XmlThemeBuilder.validateNonNegative("stroke-width", ((TextStyle.TextBuilder)b).strokeWidth);
        if (symbol != null && symbol.length() > 0) {
            String lowValue = symbol.toLowerCase(Locale.ENGLISH);
            if (lowValue.endsWith(".png") || lowValue.endsWith(".svg")) {
                try {
                    ((TextStyle.TextBuilder)b).bitmap = CanvasAdapter.getBitmapAsset(this.mTheme.getRelativePathPrefix(), symbol, ((TextStyle.TextBuilder)b).symbolWidth, ((TextStyle.TextBuilder)b).symbolHeight, (int)((float)((TextStyle.TextBuilder)b).symbolPercent * CanvasAdapter.symbolScale));
                }
                catch (Exception e) {
                    log.error("{}: {}", (Object)symbol, (Object)e.getMessage());
                }
            } else {
                ((TextStyle.TextBuilder)b).texture = this.getAtlasRegion(symbol);
            }
        }
        return b;
    }

    private CircleStyle createCircle(String elementName, int level) {
        Object b = this.mCircleBuilder.reset();
        ((RenderStyle.StyleBuilder)b).level(level);
        ((RenderStyle.StyleBuilder)b).themeCallback(this.mThemeCallback);
        int n = this.mPullParser.getAttributeCount();
        for (int i = 0; i < n; ++i) {
            String name = this.mPullParser.getAttributeName(i);
            String value = this.mPullParser.getAttributeValue(i);
            if ("r".equals(name) || "radius".equals(name)) {
                ((CircleStyle.CircleBuilder)b).radius(Float.parseFloat(value) * this.mScale * this.mStrokeScale);
                continue;
            }
            if ("cat".equals(name)) {
                ((RenderStyle.StyleBuilder)b).cat(value);
                continue;
            }
            if ("scale-radius".equals(name)) {
                ((CircleStyle.CircleBuilder)b).scaleRadius(Boolean.parseBoolean(value));
                continue;
            }
            if ("fill".equals(name)) {
                ((RenderStyle.StyleBuilder)b).color(Color.parseColor(value));
                continue;
            }
            if ("stroke".equals(name)) {
                ((RenderStyle.StyleBuilder)b).strokeColor(Color.parseColor(value));
                continue;
            }
            if ("stroke-width".equals(name)) {
                ((RenderStyle.StyleBuilder)b).strokeWidth(Float.parseFloat(value) * this.mScale * this.mStrokeScale);
                continue;
            }
            XmlThemeBuilder.logUnknownAttribute(elementName, name, value, i);
        }
        XmlThemeBuilder.validateExists("radius", Float.valueOf(((CircleStyle.CircleBuilder)b).radius), elementName);
        XmlThemeBuilder.validateNonNegative("radius", ((CircleStyle.CircleBuilder)b).radius);
        XmlThemeBuilder.validateNonNegative("stroke-width", ((CircleStyle.CircleBuilder)b).strokeWidth);
        return ((CircleStyle.CircleBuilder)b).build();
    }

    private void handleSymbolElement(String qName, boolean isStyle) {
        String style = this.getStringAttribute("use");
        SymbolStyle.SymbolBuilder<?> ps = null;
        if (style != null && (ps = this.mSymbolStyles.get(style)) == null) {
            log.debug("missing symbol style: " + style);
            return;
        }
        SymbolStyle.SymbolBuilder<?> b = this.createSymbol(qName, ps);
        if (isStyle) {
            log.debug("put style {}", (Object)b.style);
            this.mSymbolStyles.put(b.style, (SymbolStyle.SymbolBuilder<?>)SymbolStyle.builder().from(b));
        } else {
            SymbolStyle symbol = this.buildSymbol(b);
            if (symbol != null && this.isVisible(symbol)) {
                this.mCurrentRule.addStyle(symbol);
            }
        }
    }

    private SymbolStyle.SymbolBuilder<?> createSymbol(String elementName, SymbolStyle.SymbolBuilder<?> style) {
        Object b = style == null ? this.mSymbolBuilder.reset() : this.mSymbolBuilder.from(style);
        ((RenderStyle.StyleBuilder)b).themeCallback(this.mThemeCallback);
        int n = this.mPullParser.getAttributeCount();
        for (int i = 0; i < n; ++i) {
            String name = this.mPullParser.getAttributeName(i);
            String value = this.mPullParser.getAttributeValue(i);
            if ("id".equals(name)) {
                ((SymbolStyle.SymbolBuilder)b).style = value;
                continue;
            }
            if ("src".equals(name)) {
                ((SymbolStyle.SymbolBuilder)b).src(value);
                continue;
            }
            if ("cat".equals(name)) {
                ((RenderStyle.StyleBuilder)b).cat(value);
                continue;
            }
            if ("use".equals(name)) continue;
            if ("symbol-width".equals(name)) {
                ((SymbolStyle.SymbolBuilder)b).symbolWidth = (int)((float)Integer.parseInt(value) * this.mScale);
                continue;
            }
            if ("symbol-height".equals(name)) {
                ((SymbolStyle.SymbolBuilder)b).symbolHeight = (int)((float)Integer.parseInt(value) * this.mScale);
                continue;
            }
            if ("symbol-percent".equals(name)) {
                ((SymbolStyle.SymbolBuilder)b).symbolPercent = Integer.parseInt(value);
                continue;
            }
            if ("symbol-scaling".equals(name)) continue;
            if ("billboard".equals(name)) {
                ((SymbolStyle.SymbolBuilder)b).billboard(Boolean.parseBoolean(value));
                continue;
            }
            if ("repeat".equals(name)) {
                ((SymbolStyle.SymbolBuilder)b).repeat(Boolean.parseBoolean(value));
                continue;
            }
            if ("repeat-start".equals(name)) {
                ((SymbolStyle.SymbolBuilder)b).repeatStart = Float.parseFloat(value) * this.mScale;
                continue;
            }
            if ("repeat-gap".equals(name)) {
                ((SymbolStyle.SymbolBuilder)b).repeatGap = Float.parseFloat(value) * this.mScale;
                continue;
            }
            if ("rotate".equals(name)) {
                ((SymbolStyle.SymbolBuilder)b).rotate(Boolean.parseBoolean(value));
                continue;
            }
            XmlThemeBuilder.logUnknownAttribute(elementName, name, value, i);
        }
        XmlThemeBuilder.validateExists("src", ((SymbolStyle.SymbolBuilder)b).src, elementName);
        return b;
    }

    private SymbolStyle buildSymbol(SymbolStyle.SymbolBuilder<?> b) {
        String lowSrc = b.src.toLowerCase(Locale.ENGLISH);
        if (lowSrc.endsWith(".png") || lowSrc.endsWith(".svg")) {
            try {
                float symbolScale = 1.0f;
                switch (Parameters.SYMBOL_SCALING) {
                    case ALL: {
                        symbolScale = CanvasAdapter.symbolScale;
                        break;
                    }
                    case POI: {
                        if (b.repeat) break;
                        symbolScale = CanvasAdapter.symbolScale;
                    }
                }
                Bitmap bitmap = CanvasAdapter.getBitmapAsset(this.mTheme.getRelativePathPrefix(), b.src, b.symbolWidth, b.symbolHeight, (int)((float)b.symbolPercent * symbolScale));
                if (bitmap != null) {
                    return this.buildSymbol(b, b.src, bitmap);
                }
            }
            catch (Exception e) {
                log.error("{}: {}", (Object)b.src, (Object)e.getMessage());
            }
            return null;
        }
        return ((SymbolStyle.SymbolBuilder)b.texture(this.getAtlasRegion(b.src))).build();
    }

    SymbolStyle buildSymbol(SymbolStyle.SymbolBuilder<?> b, String src, Bitmap bitmap) {
        return ((SymbolStyle.SymbolBuilder)b.bitmap(bitmap)).build();
    }

    private ExtrusionStyle createExtrusion(String elementName, int level) {
        Object b = this.mExtrusionBuilder.reset();
        ((RenderStyle.StyleBuilder)b).level(level);
        ((RenderStyle.StyleBuilder)b).themeCallback(this.mThemeCallback);
        int n = this.mPullParser.getAttributeCount();
        for (int i = 0; i < n; ++i) {
            String name = this.mPullParser.getAttributeName(i);
            String value = this.mPullParser.getAttributeValue(i);
            if ("cat".equals(name)) {
                ((RenderStyle.StyleBuilder)b).cat(value);
                continue;
            }
            if ("side-color".equals(name)) {
                ((ExtrusionStyle.ExtrusionBuilder)b).colorSide(Color.parseColor(value));
                continue;
            }
            if ("top-color".equals(name)) {
                ((ExtrusionStyle.ExtrusionBuilder)b).colorTop(Color.parseColor(value));
                continue;
            }
            if ("line-color".equals(name)) {
                ((ExtrusionStyle.ExtrusionBuilder)b).colorLine(Color.parseColor(value));
                continue;
            }
            if ("hsv-h".equals(name)) {
                ((ExtrusionStyle.ExtrusionBuilder)b).hsvHue(Double.parseDouble(value));
                continue;
            }
            if ("hsv-s".equals(name)) {
                ((ExtrusionStyle.ExtrusionBuilder)b).hsvSaturation(Double.parseDouble(value));
                continue;
            }
            if ("hsv-v".equals(name)) {
                ((ExtrusionStyle.ExtrusionBuilder)b).hsvValue(Double.parseDouble(value));
                continue;
            }
            if ("default-height".equals(name)) {
                ((ExtrusionStyle.ExtrusionBuilder)b).defaultHeight(Integer.parseInt(value));
                continue;
            }
            XmlThemeBuilder.logUnknownAttribute(elementName, name, value, i);
        }
        return ((ExtrusionStyle.ExtrusionBuilder)b).build();
    }

    private String getStringAttribute(String name) {
        int n = this.mPullParser.getAttributeCount();
        for (int i = 0; i < n; ++i) {
            if (!this.mPullParser.getAttributeName(i).equals(name)) continue;
            return this.mPullParser.getAttributeValue(i);
        }
        return null;
    }

    private boolean isVisible(RenderStyle<?> renderStyle) {
        return this.mCategories == null || renderStyle.cat == null || this.mCategories.contains(renderStyle.cat);
    }

    private boolean isVisible(RuleBuilder rule) {
        return this.mCategories == null || rule.cat == null || this.mCategories.contains(rule.cat);
    }

    private static float[] parseFloatArray(String dashString) {
        String[] dashEntries = dashString.split(",");
        float[] dashIntervals = new float[dashEntries.length];
        for (int i = 0; i < dashEntries.length; ++i) {
            dashIntervals[i] = Float.parseFloat(dashEntries[i]);
        }
        return dashIntervals;
    }

    private void tagTransform(String qName) {
        String libV = null;
        String libK = null;
        String v = null;
        String k = null;
        int n = this.mPullParser.getAttributeCount();
        block12: for (int i = 0; i < n; ++i) {
            String name = this.mPullParser.getAttributeName(i);
            String value = this.mPullParser.getAttributeValue(i);
            switch (name) {
                case "k": {
                    k = value;
                    continue block12;
                }
                case "v": {
                    v = value;
                    continue block12;
                }
                case "k-lib": {
                    libK = value;
                    continue block12;
                }
                case "v-lib": {
                    libV = value;
                    continue block12;
                }
                default: {
                    XmlThemeBuilder.logUnknownAttribute(qName, name, value, i);
                }
            }
        }
        if (k == null || k.isEmpty() || libK == null || libK.isEmpty()) {
            log.debug("empty key in element " + qName);
            return;
        }
        if (v == null && libV == null) {
            this.mTransformKeyMap.put(k, libK);
        } else {
            this.mTransformTagMap.put(new Tag(k, v), new Tag(libK, libV));
        }
    }

    private static void validateNonNegative(String name, float value) {
        if (value < 0.0f) {
            throw new IRenderTheme.ThemeException(name + " must not be negative: " + value);
        }
    }

    private static void validateExists(String name, Object obj, String elementName) {
        if (obj == null) {
            throw new IRenderTheme.ThemeException("missing attribute " + name + " for element: " + elementName);
        }
    }

    private RuleBuilder buildingRule() {
        Object b = this.mExtrusionBuilder.reset();
        ((RenderStyle.StyleBuilder)b).level(this.mLevels++);
        ((RenderStyle.StyleBuilder)b).themeCallback(this.mThemeCallback);
        ((ExtrusionStyle.ExtrusionBuilder)b).colorLine(-2500394);
        ((ExtrusionStyle.ExtrusionBuilder)b).colorSide(-353571863);
        ((ExtrusionStyle.ExtrusionBuilder)b).colorTop(-352716554);
        RuleBuilder rule = new RuleBuilder(RuleBuilder.RuleType.POSITIVE, new String[]{"building", "building:part"}, new String[0]);
        rule.element(6).zoom((byte)17, (byte)127).style(new RenderStyle.StyleBuilder[]{b});
        return rule;
    }

    private static enum Element {
        RENDER_THEME,
        RENDERING_INSTRUCTION,
        RULE,
        STYLE,
        ATLAS,
        RECT,
        RENDERING_STYLE,
        TAG_TRANSFORM;

    }
}

