/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.theme.styles;

import org.oscim.backend.CanvasAdapter;
import org.oscim.backend.canvas.Bitmap;
import org.oscim.backend.canvas.Color;
import org.oscim.backend.canvas.Paint;
import org.oscim.renderer.atlas.TextureRegion;
import org.oscim.theme.styles.RenderStyle;

public final class TextStyle
extends RenderStyle<TextStyle> {
    public final String style;
    public final Paint.FontFamily fontFamily;
    public final Paint.FontStyle fontStyle;
    public float fontSize;
    public final Paint paint;
    public final Paint stroke;
    public final String textKey;
    public final boolean caption;
    public final float dy;
    public final int priority;
    public final float areaSize;
    public float fontHeight;
    public float fontDescent;
    public final Bitmap bitmap;
    public final TextureRegion texture;
    public final int symbolWidth;
    public final int symbolHeight;
    public final int symbolPercent;
    public final Paint bgFill;

    TextStyle(TextBuilder<?> b) {
        this.cat = b.cat;
        this.style = b.style;
        this.textKey = b.textKey;
        this.caption = b.caption;
        this.dy = b.dy;
        this.priority = b.priority;
        this.areaSize = b.areaSize;
        this.bitmap = b.bitmap;
        this.texture = b.texture;
        this.paint = CanvasAdapter.newPaint();
        this.paint.setTypeface(b.fontFamily, b.fontStyle);
        this.paint.setColor(b.themeCallback != null ? b.themeCallback.getColor(this, b.fillColor) : b.fillColor);
        this.paint.setTextSize(b.fontSize);
        if (b.strokeWidth > 0.0f) {
            this.stroke = CanvasAdapter.newPaint();
            this.stroke.setStyle(Paint.Style.STROKE);
            this.stroke.setTypeface(b.fontFamily, b.fontStyle);
            this.stroke.setColor(b.themeCallback != null ? b.themeCallback.getColor(this, b.strokeColor) : b.strokeColor);
            this.stroke.setStrokeWidth(b.strokeWidth);
            this.stroke.setTextSize(b.fontSize);
        } else {
            this.stroke = null;
        }
        this.fontFamily = b.fontFamily;
        this.fontStyle = b.fontStyle;
        this.fontSize = b.fontSize;
        this.symbolWidth = b.symbolWidth;
        this.symbolHeight = b.symbolHeight;
        this.symbolPercent = b.symbolPercent;
        if (b.bgFillColor != 0) {
            this.bgFill = CanvasAdapter.newPaint();
            this.bgFill.setColor(b.themeCallback != null ? b.themeCallback.getColor(this, b.bgFillColor) : b.bgFillColor);
        } else {
            this.bgFill = null;
        }
    }

    @Override
    public void dispose() {
        if (this.bitmap != null) {
            this.bitmap.recycle();
        }
    }

    @Override
    public void renderNode(RenderStyle.Callback cb) {
        cb.renderText(this);
    }

    @Override
    public void renderWay(RenderStyle.Callback cb) {
        cb.renderText(this);
    }

    @Override
    public TextStyle current() {
        return (TextStyle)this.mCurrent;
    }

    @Override
    public void scaleTextSize(float scaleFactor) {
        this.fontSize *= scaleFactor;
        this.paint.setTextSize(this.fontSize);
        if (this.stroke != null) {
            this.stroke.setTextSize(this.fontSize);
        }
        this.fontHeight = this.paint.getFontHeight();
        this.fontDescent = this.paint.getFontDescent();
    }

    public static TextBuilder<?> builder() {
        return new TextBuilder();
    }

    public static class TextBuilder<T extends TextBuilder<T>>
    extends RenderStyle.StyleBuilder<T> {
        public float fontSize;
        public String textKey;
        public boolean caption;
        public float dy;
        public int priority;
        public float areaSize;
        public Bitmap bitmap;
        public TextureRegion texture;
        public Paint.FontFamily fontFamily;
        public Paint.FontStyle fontStyle;
        public int symbolWidth;
        public int symbolHeight;
        public int symbolPercent;
        public int bgFillColor;

        public T reset() {
            this.cat = null;
            this.fontFamily = Paint.FontFamily.DEFAULT;
            this.fontStyle = Paint.FontStyle.NORMAL;
            this.style = null;
            this.textKey = null;
            this.fontSize = 0.0f;
            this.caption = false;
            this.priority = Integer.MAX_VALUE;
            this.areaSize = 0.0f;
            this.bitmap = null;
            this.texture = null;
            this.fillColor = -16777216;
            this.strokeColor = -16777216;
            this.strokeWidth = 0.0f;
            this.dy = 0.0f;
            this.symbolWidth = 0;
            this.symbolHeight = 0;
            this.symbolPercent = 100;
            this.bgFillColor = 0;
            return (T)((TextBuilder)this.self());
        }

        public TextBuilder() {
            this.reset();
        }

        @Override
        public TextStyle build() {
            TextStyle t = new TextStyle(this);
            t.fontHeight = t.paint.getFontHeight();
            t.fontDescent = t.paint.getFontDescent();
            return t;
        }

        public TextStyle buildInternal() {
            return new TextStyle(this);
        }

        public T fontSize(float fontSize) {
            this.fontSize = fontSize;
            return (T)((TextBuilder)this.self());
        }

        public T textKey(String textKey) {
            this.textKey = textKey;
            return (T)((TextBuilder)this.self());
        }

        public T isCaption(boolean caption) {
            this.caption = caption;
            return (T)((TextBuilder)this.self());
        }

        public T offsetY(float dy) {
            this.dy = dy;
            return (T)((TextBuilder)this.self());
        }

        public T priority(int priority) {
            this.priority = priority;
            return (T)((TextBuilder)this.self());
        }

        public T areaSize(float areaSize) {
            this.areaSize = areaSize;
            return (T)((TextBuilder)this.self());
        }

        public T bitmap(Bitmap bitmap) {
            this.bitmap = bitmap;
            return (T)((TextBuilder)this.self());
        }

        public T texture(TextureRegion texture) {
            this.texture = texture;
            return (T)((TextBuilder)this.self());
        }

        public T fontFamily(Paint.FontFamily fontFamily) {
            this.fontFamily = fontFamily;
            return (T)((TextBuilder)this.self());
        }

        public T fontStyle(Paint.FontStyle fontStyle) {
            this.fontStyle = fontStyle;
            return (T)((TextBuilder)this.self());
        }

        public T symbolWidth(int symbolWidth) {
            this.symbolWidth = symbolWidth;
            return (T)((TextBuilder)this.self());
        }

        public T symbolHeight(int symbolHeight) {
            this.symbolHeight = symbolHeight;
            return (T)((TextBuilder)this.self());
        }

        public T symbolPercent(int symbolPercent) {
            this.symbolPercent = symbolPercent;
            return (T)((TextBuilder)this.self());
        }

        public T bgFillColor(int color) {
            this.bgFillColor = color;
            return (T)((TextBuilder)this.self());
        }

        public T bgFillColor(String color) {
            this.bgFillColor = Color.parseColor(color);
            return (T)((TextBuilder)this.self());
        }

        public T from(TextBuilder<?> other) {
            this.cat = other.cat;
            this.fontFamily = other.fontFamily;
            this.fontStyle = other.fontStyle;
            this.style = other.style;
            this.textKey = other.textKey;
            this.fontSize = other.fontSize;
            this.caption = other.caption;
            this.priority = other.priority;
            this.areaSize = other.areaSize;
            this.bitmap = other.bitmap;
            this.texture = other.texture;
            this.fillColor = other.fillColor;
            this.strokeColor = other.strokeColor;
            this.strokeWidth = other.strokeWidth;
            this.dy = other.dy;
            this.symbolWidth = other.symbolWidth;
            this.symbolHeight = other.symbolHeight;
            this.symbolPercent = other.symbolPercent;
            this.bgFillColor = other.bgFillColor;
            return (T)((TextBuilder)this.self());
        }

        public TextBuilder<?> set(TextStyle text) {
            if (text == null) {
                return this.reset();
            }
            this.cat = text.cat;
            this.style = text.style;
            this.textKey = text.textKey;
            this.caption = text.caption;
            this.dy = text.dy;
            this.priority = text.priority;
            this.areaSize = text.areaSize;
            this.bitmap = text.bitmap;
            this.texture = text.texture;
            this.fillColor = this.themeCallback != null ? this.themeCallback.getColor(text, text.paint.getColor()) : text.paint.getColor();
            this.fontFamily = text.fontFamily;
            this.fontStyle = text.fontStyle;
            if (text.stroke != null) {
                this.strokeColor = this.themeCallback != null ? this.themeCallback.getColor(text, text.stroke.getColor()) : text.stroke.getColor();
                this.strokeWidth = text.stroke.getStrokeWidth();
            }
            this.fontSize = text.fontSize;
            this.symbolWidth = text.symbolWidth;
            this.symbolHeight = text.symbolHeight;
            this.symbolPercent = text.symbolPercent;
            if (text.bgFill != null) {
                this.bgFillColor = this.themeCallback != null ? this.themeCallback.getColor(text, text.bgFill.getColor()) : text.bgFill.getColor();
            }
            return (TextBuilder)this.self();
        }
    }
}

