/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.tiling.source.mapfile;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.oscim.core.Tag;
import org.oscim.core.TagSet;
import org.oscim.utils.Parameters;

public class ReadBuffer {
    private static final String CHARSET_UTF8 = "UTF-8";
    private static final Logger LOG = Logger.getLogger(ReadBuffer.class.getName());
    private byte[] mBufferData;
    private int mBufferPosition;
    private ByteBuffer mBufferWrapper;
    private final FileChannel mInputChannel;
    private final List<Integer> mTagIds = new ArrayList<Integer>();
    private static final int WAY_NUMBER_OF_TAGS_BITMASK = 15;
    int lastTagPosition;

    ReadBuffer(FileChannel inputChannel) {
        this.mInputChannel = inputChannel;
    }

    public byte readByte() {
        return this.mBufferData[this.mBufferPosition++];
    }

    public float readFloat() {
        return Float.intBitsToFloat(this.readInt());
    }

    public boolean readFromFile(int length) throws IOException {
        if (this.mBufferData == null || this.mBufferData.length < length) {
            if (length > Parameters.MAXIMUM_BUFFER_SIZE) {
                LOG.warning("invalid read length: " + length);
                return false;
            }
            try {
                this.mBufferData = new byte[length];
            }
            catch (Throwable t) {
                LOG.log(Level.SEVERE, t.getMessage(), t);
                return false;
            }
            this.mBufferWrapper = ByteBuffer.wrap(this.mBufferData, 0, length);
        }
        this.mBufferPosition = 0;
        this.mBufferWrapper.clear();
        return this.mInputChannel.read(this.mBufferWrapper) == length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean readFromFile(long offset, int length) throws IOException {
        if (this.mBufferData == null || this.mBufferData.length < length) {
            if (length > Parameters.MAXIMUM_BUFFER_SIZE) {
                LOG.warning("invalid read length: " + length);
                return false;
            }
            try {
                this.mBufferData = new byte[length];
            }
            catch (Throwable t) {
                LOG.log(Level.SEVERE, t.getMessage(), t);
                return false;
            }
            this.mBufferWrapper = ByteBuffer.wrap(this.mBufferData, 0, length);
        }
        this.mBufferPosition = 0;
        this.mBufferWrapper.clear();
        FileChannel fileChannel = this.mInputChannel;
        synchronized (fileChannel) {
            this.mInputChannel.position(offset);
            return this.mInputChannel.read(this.mBufferWrapper) == length;
        }
    }

    public int readInt() {
        int pos = this.mBufferPosition;
        byte[] data = this.mBufferData;
        this.mBufferPosition += 4;
        return data[pos] << 24 | (data[pos + 1] & 0xFF) << 16 | (data[pos + 2] & 0xFF) << 8 | data[pos + 3] & 0xFF;
    }

    public long readLong() {
        int pos = this.mBufferPosition;
        byte[] data = this.mBufferData;
        this.mBufferPosition += 8;
        return ((long)data[pos] & 0xFFL) << 56 | ((long)data[pos + 1] & 0xFFL) << 48 | ((long)data[pos + 2] & 0xFFL) << 40 | ((long)data[pos + 3] & 0xFFL) << 32 | ((long)data[pos + 4] & 0xFFL) << 24 | ((long)data[pos + 5] & 0xFFL) << 16 | ((long)data[pos + 6] & 0xFFL) << 8 | (long)data[pos + 7] & 0xFFL;
    }

    public int readShort() {
        this.mBufferPosition += 2;
        return this.mBufferData[this.mBufferPosition - 2] << 8 | this.mBufferData[this.mBufferPosition - 1] & 0xFF;
    }

    public int readSignedInt() {
        int pos;
        byte[] data = this.mBufferData;
        if ((data[pos = this.mBufferPosition++] & 0x80) == 0) {
            int flag = (data[pos] & 0x40) >> 6;
            return (data[pos] & 0x3F ^ -flag) + flag;
        }
        if ((data[pos + 1] & 0x80) == 0) {
            this.mBufferPosition += 2;
            int flag = (data[pos + 1] & 0x40) >> 6;
            return ((data[pos] & 0x7F | (data[pos + 1] & 0x3F) << 7) ^ -flag) + flag;
        }
        if ((data[pos + 2] & 0x80) == 0) {
            this.mBufferPosition += 3;
            int flag = (data[pos + 2] & 0x40) >> 6;
            return ((data[pos] & 0x7F | (data[pos + 1] & 0x7F) << 7 | (data[pos + 2] & 0x3F) << 14) ^ -flag) + flag;
        }
        if ((data[pos + 3] & 0x80) == 0) {
            this.mBufferPosition += 4;
            int flag = (data[pos + 3] & 0x40) >> 6;
            return ((data[pos] & 0x7F | (data[pos + 1] & 0x7F) << 7 | (data[pos + 2] & 0x7F) << 14 | (data[pos + 3] & 0x3F) << 21) ^ -flag) + flag;
        }
        this.mBufferPosition += 5;
        int flag = (data[pos + 4] & 0x40) >> 6;
        return ((data[pos] & 0x7F | (data[pos + 1] & 0x7F) << 7 | (data[pos + 2] & 0x7F) << 14 | (data[pos + 3] & 0x7F) << 21 | (data[pos + 4] & 0x3F) << 28) ^ -flag) + flag;
    }

    public void readSignedInt(int[] values, int length) {
        int pos = this.mBufferPosition;
        byte[] data = this.mBufferData;
        for (int i = 0; i < length; ++i) {
            int flag;
            if ((data[pos] & 0x80) == 0) {
                flag = (data[pos] & 0x40) >> 6;
                values[i] = (data[pos] & 0x3F ^ -flag) + flag;
                ++pos;
                continue;
            }
            if ((data[pos + 1] & 0x80) == 0) {
                flag = (data[pos + 1] & 0x40) >> 6;
                values[i] = ((data[pos] & 0x7F | (data[pos + 1] & 0x3F) << 7) ^ -flag) + flag;
                pos += 2;
                continue;
            }
            if ((data[pos + 2] & 0x80) == 0) {
                flag = (data[pos + 2] & 0x40) >> 6;
                values[i] = ((data[pos] & 0x7F | (data[pos + 1] & 0x7F) << 7 | (data[pos + 2] & 0x3F) << 14) ^ -flag) + flag;
                pos += 3;
                continue;
            }
            if ((data[pos + 3] & 0x80) == 0) {
                flag = (data[pos + 3] & 0x40) >> 6;
                values[i] = ((data[pos] & 0x7F | (data[pos + 1] & 0x7F) << 7 | (data[pos + 2] & 0x7F) << 14 | (data[pos + 3] & 0x3F) << 21) ^ -flag) + flag;
                pos += 4;
                continue;
            }
            flag = (data[pos + 4] & 0x40) >> 6;
            values[i] = ((data[pos] & 0x7F | (data[pos + 1] & 0x7F) << 7 | (data[pos + 2] & 0x7F) << 14 | (data[pos + 3] & 0x7F) << 21 | (data[pos + 4] & 0x3F) << 28) ^ -flag) + flag;
            pos += 5;
        }
        this.mBufferPosition = pos;
    }

    public int readUnsignedInt() {
        int pos;
        byte[] data = this.mBufferData;
        if ((data[pos = this.mBufferPosition++] & 0x80) == 0) {
            return data[pos] & 0x7F;
        }
        if ((data[pos + 1] & 0x80) == 0) {
            this.mBufferPosition += 2;
            return data[pos] & 0x7F | (data[pos + 1] & 0x7F) << 7;
        }
        if ((data[pos + 2] & 0x80) == 0) {
            this.mBufferPosition += 3;
            return data[pos] & 0x7F | (data[pos + 1] & 0x7F) << 7 | (data[pos + 2] & 0x7F) << 14;
        }
        if ((data[pos + 3] & 0x80) == 0) {
            this.mBufferPosition += 4;
            return data[pos] & 0x7F | (data[pos + 1] & 0x7F) << 7 | (data[pos + 2] & 0x7F) << 14 | (data[pos + 3] & 0x7F) << 21;
        }
        this.mBufferPosition += 5;
        return data[pos] & 0x7F | (data[pos + 1] & 0x7F) << 7 | (data[pos + 2] & 0x7F) << 14 | (data[pos + 3] & 0x7F) << 21 | (data[pos + 4] & 0x7F) << 28;
    }

    public String readUTF8EncodedString() {
        return this.readUTF8EncodedString(this.readUnsignedInt());
    }

    public int getPositionAndSkip() {
        int pos = this.mBufferPosition;
        int length = this.readUnsignedInt();
        this.skipBytes(length);
        return pos;
    }

    public String readUTF8EncodedString(int stringLength) {
        if (stringLength > 0 && this.mBufferPosition + stringLength <= this.mBufferData.length) {
            this.mBufferPosition += stringLength;
            try {
                return new String(this.mBufferData, this.mBufferPosition - stringLength, stringLength, CHARSET_UTF8);
            }
            catch (UnsupportedEncodingException e) {
                throw new IllegalStateException(e);
            }
        }
        LOG.warning("invalid string length: " + stringLength);
        return null;
    }

    public String readUTF8EncodedStringAt(int position) {
        int curPosition = this.mBufferPosition;
        this.mBufferPosition = position;
        String result = this.readUTF8EncodedString(this.readUnsignedInt());
        this.mBufferPosition = curPosition;
        return result;
    }

    int getBufferPosition() {
        return this.mBufferPosition;
    }

    int getBufferSize() {
        return this.mBufferData.length;
    }

    void setBufferPosition(int bufferPosition) {
        this.mBufferPosition = bufferPosition;
    }

    void skipBytes(int bytes) {
        this.mBufferPosition += bytes;
    }

    boolean readTags(TagSet tags, Tag[] tagsArray, byte numberOfTags) {
        tags.clear();
        this.mTagIds.clear();
        int maxTag = tagsArray.length;
        for (byte i = 0; i < numberOfTags; i = (byte)(i + 1)) {
            int tagId = this.readUnsignedInt();
            if (tagId < 0 || tagId >= maxTag) {
                LOG.warning("invalid tag ID: " + tagId);
                break;
            }
            this.mTagIds.add(tagId);
        }
        for (int tagId : this.mTagIds) {
            Tag tag = tagsArray[tagId];
            if (tag.value.length() == 2 && tag.value.charAt(0) == '%') {
                String value = tag.value;
                if (value.charAt(1) == 'b') {
                    value = String.valueOf(this.readByte());
                } else if (value.charAt(1) == 'i') {
                    value = tag.key.contains(":colour") ? "#" + Integer.toHexString(this.readInt()) : String.valueOf(this.readInt());
                } else if (value.charAt(1) == 'f') {
                    value = String.valueOf(this.readFloat());
                } else if (value.charAt(1) == 'h') {
                    value = String.valueOf(this.readShort());
                } else if (value.charAt(1) == 's') {
                    value = this.readUTF8EncodedString();
                }
                tag = new Tag(tag.key, value);
            }
            tags.add(tag);
        }
        return true;
    }

    int skipWays(int queryTileBitmask, int elements) {
        int cnt;
        int pos = this.mBufferPosition;
        byte[] data = this.mBufferData;
        this.lastTagPosition = -1;
        for (cnt = elements; cnt > 0; --cnt) {
            int skip;
            if ((data[pos] & 0x80) == 0) {
                skip = data[pos] & 0x7F;
                ++pos;
            } else if ((data[pos + 1] & 0x80) == 0) {
                skip = data[pos] & 0x7F | (data[pos + 1] & 0x7F) << 7;
                pos += 2;
            } else if ((data[pos + 2] & 0x80) == 0) {
                skip = data[pos] & 0x7F | (data[pos + 1] & 0x7F) << 7 | (data[pos + 2] & 0x7F) << 14;
                pos += 3;
            } else if ((data[pos + 3] & 0x80) == 0) {
                skip = data[pos] & 0x7F | (data[pos + 1] & 0x7F) << 7 | (data[pos + 2] & 0x7F) << 14 | (data[pos + 3] & 0x7F) << 21;
                pos += 4;
            } else {
                skip = data[pos] & 0x7F | (data[pos + 1] & 0x7F) << 7 | (data[pos + 2] & 0x7F) << 14 | (data[pos + 3] & 0x7F) << 21 | (data[pos + 4] & 0x7F) << 28;
                pos += 5;
            }
            if (skip < 0) {
                this.mBufferPosition = pos;
                return -1;
            }
            if (((data[pos] << 8 | data[pos + 1] & 0xFF) & queryTileBitmask) == 0) {
                if ((data[pos + 2] & 0xF) != 0) {
                    this.lastTagPosition = pos + 2;
                }
                pos += skip;
                continue;
            }
            pos += 2;
            break;
        }
        this.mBufferPosition = pos;
        return cnt;
    }
}

