/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.oscim.backend.CanvasAdapter;
import org.oscim.backend.canvas.Bitmap;
import org.oscim.backend.canvas.Canvas;
import org.oscim.renderer.atlas.TextureAtlas;

public class BitmapPacker {
    private final int atlasWidth;
    private final int atlasHeight;
    private final int padding;
    private final PackStrategy packStrategy;
    private final boolean flipY;
    private final List<PackerAtlasItem> packerAtlasItems = new ArrayList<PackerAtlasItem>();

    public BitmapPacker(int atlasWidth, int atlasHeight, int padding, boolean flipY) {
        this(atlasWidth, atlasHeight, padding, new GuillotineStrategy(), flipY);
    }

    public BitmapPacker(int atlasWidth, int atlasHeight, int padding, PackStrategy packStrategy, boolean flipY) {
        this.atlasWidth = atlasWidth;
        this.atlasHeight = atlasHeight;
        this.padding = padding;
        this.packStrategy = packStrategy;
        this.flipY = flipY;
    }

    public synchronized Rect add(Object key, Bitmap image) {
        Rect rect = new Rect(0, 0, image.getWidth(), image.getHeight());
        if (rect.width > this.atlasWidth || rect.height > this.atlasHeight) {
            if (key == null) {
                throw new RuntimeException("PackerAtlasItem size too small for Bitmap.");
            }
            throw new RuntimeException("PackerAtlasItem size too small for Bitmap: " + key);
        }
        PackerAtlasItem packerAtlasItem = this.packStrategy.pack(this, key, rect);
        if (key != null) {
            packerAtlasItem.rects.put(key, rect);
            packerAtlasItem.addedRects.add(key);
        }
        int rectX = rect.x;
        int rectY = rect.y;
        int rectWidth = rect.width;
        int rectHeight = rect.height;
        packerAtlasItem.drawBitmap(image, rectX, this.flipY ? packerAtlasItem.image.getHeight() - rectY - rectHeight : rectY);
        return rect;
    }

    public synchronized PackerAtlasItem getAtlasItem(int index) {
        return this.packerAtlasItems.get(index);
    }

    public int getAtlasCount() {
        return this.packerAtlasItems.size();
    }

    private static class Rect {
        int x;
        int y;
        int width;
        int height;

        Rect() {
        }

        Rect(int x, int y, int width, int height) {
            this.set(x, y, width, height);
        }

        void set(int x, int y, int width, int height) {
            this.x = x;
            this.y = y;
            this.width = width;
            this.height = height;
        }

        TextureAtlas.Rect getAtlasRect() {
            return new TextureAtlas.Rect(this.x, this.y, this.width, this.height);
        }
    }

    public static class SkylineStrategy
    implements PackStrategy {
        Comparator<Bitmap> comparator;

        @Override
        public void sort(ArrayList<Bitmap> images) {
            if (this.comparator == null) {
                this.comparator = new Comparator<Bitmap>(){

                    @Override
                    public int compare(Bitmap o1, Bitmap o2) {
                        return o1.getHeight() - o2.getHeight();
                    }
                };
            }
            Collections.sort(images, this.comparator);
        }

        @Override
        public PackerAtlasItem pack(BitmapPacker packer, Object key, Rect rect) {
            int padding = packer.padding;
            int atlasWidth = packer.atlasWidth - padding * 2;
            int atlasHeight = packer.atlasHeight - padding * 2;
            int rectWidth = rect.width + padding;
            int rectHeight = rect.height + padding;
            int n = packer.packerAtlasItems.size();
            for (int i = 0; i < n; ++i) {
                SkylineAtlasItem atlasItem = (SkylineAtlasItem)packer.packerAtlasItems.get(i);
                SkylineAtlasItem.Row bestRow = null;
                int nn = atlasItem.rows.size() - 1;
                for (int ii = 0; ii < nn; ++ii) {
                    SkylineAtlasItem.Row row = atlasItem.rows.get(ii);
                    if (row.x + rectWidth >= atlasWidth || row.y + rectHeight >= atlasHeight || rectHeight > row.height || bestRow != null && row.height >= bestRow.height) continue;
                    bestRow = row;
                }
                if (bestRow == null) {
                    SkylineAtlasItem.Row row = atlasItem.rows.get(atlasItem.rows.size() - 1);
                    if (row.y + rectHeight >= atlasHeight) continue;
                    if (row.x + rectWidth < atlasWidth) {
                        row.height = Math.max(row.height, rectHeight);
                        bestRow = row;
                    } else {
                        bestRow = new SkylineAtlasItem.Row();
                        bestRow.y = row.y + row.height;
                        bestRow.height = rectHeight;
                        if (bestRow.y + bestRow.height > atlasHeight) continue;
                        atlasItem.rows.add(bestRow);
                    }
                }
                rect.x = bestRow.x;
                rect.y = bestRow.y;
                bestRow.x += rectWidth;
                return atlasItem;
            }
            SkylineAtlasItem atlasItem = new SkylineAtlasItem(packer);
            packer.packerAtlasItems.add(atlasItem);
            SkylineAtlasItem.Row row = new SkylineAtlasItem.Row();
            row.x = padding + rectWidth;
            row.y = padding;
            row.height = rectHeight;
            atlasItem.rows.add(row);
            rect.x = padding;
            rect.y = padding;
            return atlasItem;
        }

        static class SkylineAtlasItem
        extends PackerAtlasItem {
            ArrayList<Row> rows = new ArrayList();

            SkylineAtlasItem(BitmapPacker packer) {
                super(packer);
            }

            static class Row {
                int x;
                int y;
                int height;

                Row() {
                }
            }
        }
    }

    public static class GuillotineStrategy
    implements PackStrategy {
        Comparator<Bitmap> comparator;

        @Override
        public void sort(ArrayList<Bitmap> Bitmaps) {
            if (this.comparator == null) {
                this.comparator = new Comparator<Bitmap>(){

                    @Override
                    public int compare(Bitmap o1, Bitmap o2) {
                        return Math.max(o1.getWidth(), o1.getHeight()) - Math.max(o2.getWidth(), o2.getHeight());
                    }
                };
            }
            Collections.sort(Bitmaps, this.comparator);
        }

        @Override
        public PackerAtlasItem pack(BitmapPacker packer, Object key, Rect rect) {
            GuillotineAtlasItem atlasItem;
            if (packer.packerAtlasItems.size() == 0) {
                atlasItem = new GuillotineAtlasItem(packer);
                packer.packerAtlasItems.add(atlasItem);
            } else {
                atlasItem = (GuillotineAtlasItem)packer.packerAtlasItems.get(packer.packerAtlasItems.size() - 1);
            }
            int padding = packer.padding;
            rect.width += padding;
            rect.height += padding;
            Node node = this.insert(atlasItem.root, rect);
            if (node == null) {
                atlasItem = new GuillotineAtlasItem(packer);
                packer.packerAtlasItems.add(atlasItem);
                node = this.insert(atlasItem.root, rect);
            }
            node.full = true;
            rect.set(node.rect.x, node.rect.y, node.rect.width - padding, node.rect.height - padding);
            return atlasItem;
        }

        private Node insert(Node node, Rect rect) {
            if (!node.full && node.leftChild != null && node.rightChild != null) {
                Node newNode = this.insert(node.leftChild, rect);
                if (newNode == null) {
                    newNode = this.insert(node.rightChild, rect);
                }
                return newNode;
            }
            if (node.full) {
                return null;
            }
            if (node.rect.width == rect.width && node.rect.height == rect.height) {
                return node;
            }
            if (node.rect.width < rect.width || node.rect.height < rect.height) {
                return null;
            }
            node.leftChild = new Node();
            node.rightChild = new Node();
            int deltaWidth = node.rect.width - rect.width;
            int deltaHeight = node.rect.height - rect.height;
            if (deltaWidth > deltaHeight) {
                node.leftChild.rect.x = node.rect.x;
                node.leftChild.rect.y = node.rect.y;
                node.leftChild.rect.width = rect.width;
                node.leftChild.rect.height = node.rect.height;
                node.rightChild.rect.x = node.rect.x + rect.width;
                node.rightChild.rect.y = node.rect.y;
                node.rightChild.rect.width = node.rect.width - rect.width;
                node.rightChild.rect.height = node.rect.height;
            } else {
                node.leftChild.rect.x = node.rect.x;
                node.leftChild.rect.y = node.rect.y;
                node.leftChild.rect.width = node.rect.width;
                node.leftChild.rect.height = rect.height;
                node.rightChild.rect.x = node.rect.x;
                node.rightChild.rect.y = node.rect.y + rect.height;
                node.rightChild.rect.width = node.rect.width;
                node.rightChild.rect.height = node.rect.height - rect.height;
            }
            return this.insert(node.leftChild, rect);
        }

        static class GuillotineAtlasItem
        extends PackerAtlasItem {
            Node root = new Node();

            GuillotineAtlasItem(BitmapPacker packer) {
                super(packer);
                this.root.rect.x = packer.padding;
                this.root.rect.y = packer.padding;
                this.root.rect.width = packer.atlasWidth - packer.padding * 2;
                this.root.rect.height = packer.atlasHeight - packer.padding * 2;
            }
        }

        static final class Node {
            Node leftChild;
            Node rightChild;
            final Rect rect = new Rect();
            boolean full;

            Node() {
            }
        }
    }

    public static interface PackStrategy {
        public void sort(ArrayList<Bitmap> var1);

        public PackerAtlasItem pack(BitmapPacker var1, Object var2, Rect var3);
    }

    public static class PackerAtlasItem {
        HashMap<Object, Rect> rects = new HashMap();
        final Bitmap image;
        final Canvas canvas;
        final ArrayList<Object> addedRects = new ArrayList();

        PackerAtlasItem(BitmapPacker packer) {
            int format = CanvasAdapter.platform.isDesktop() ? 3 : 0;
            this.image = CanvasAdapter.newBitmap(packer.atlasWidth, packer.atlasHeight, format);
            this.canvas = CanvasAdapter.newCanvas();
            this.canvas.setBitmap(this.image);
            this.canvas.fillColor(0);
        }

        public TextureAtlas getAtlas() {
            TextureAtlas atlas = new TextureAtlas(this.image);
            for (Map.Entry<Object, Rect> entry : this.rects.entrySet()) {
                atlas.addTextureRegion(entry.getKey(), entry.getValue().getAtlasRect());
            }
            return atlas;
        }

        void drawBitmap(Bitmap image, int x, int y) {
            this.canvas.drawBitmap(image, x, y);
        }
    }
}

