/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.utils.animation;

public final class DragForce {
    private static final float DEFAULT_FRICTION = -4.2f;
    private static final float DEFAULT_MIN_VISIBLE_CHANGE_PIXELS = 0.5f;
    private static final float VELOCITY_THRESHOLD_MULTIPLIER = 62.5f;
    private float mFriction = -4.2f;
    private float mVelocityThreshold = 31.25f;
    private float mValue;
    private float mVelocity;

    public void setFrictionScalar(float frictionScalar) {
        this.mFriction = frictionScalar * -4.2f;
    }

    public float getFrictionScalar() {
        return this.mFriction / -4.2f;
    }

    public float updateValueAndVelocity(long deltaT) {
        float velocity = this.mVelocity;
        this.mVelocity = (float)((double)velocity * Math.exp((float)deltaT / 1000.0f * this.mFriction));
        float valueDelta = this.mVelocity - velocity;
        this.mValue += valueDelta;
        if (this.isAtEquilibrium(this.mValue, this.mVelocity)) {
            this.mVelocity = 0.0f;
        }
        return valueDelta;
    }

    public void setValueAndVelocity(float value, float velocity) {
        this.mValue = value;
        this.mVelocity = velocity;
    }

    public float getValue() {
        return this.mValue;
    }

    public float getVelocity() {
        return this.mVelocity;
    }

    public float getAcceleration(float position, float velocity) {
        return velocity * this.mFriction;
    }

    public boolean isAtEquilibrium(float value, float velocity) {
        return Math.abs(velocity) < this.mVelocityThreshold;
    }

    public void setValueThreshold(float threshold) {
        this.mVelocityThreshold = threshold * 62.5f;
    }
}

