/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.utils.geom;

import java.util.ArrayList;
import java.util.List;

public final class GeometryUtils {
    private GeometryUtils() {
    }

    public static boolean pointInPoly(float x, float y, float[] vertices, int length, int offset) {
        int end = offset + length;
        boolean inside = false;
        int j = end - 2;
        for (int i = offset; i < end; i += 2) {
            if (vertices[i + 1] > y != vertices[j + 1] > y && x < (vertices[j] - vertices[i]) * (y - vertices[i + 1]) / (vertices[j + 1] - vertices[i + 1]) + vertices[i]) {
                inside = !inside;
            }
            j = i;
        }
        return inside;
    }

    public static float area(float[] points, int size) {
        float area = GeometryUtils.isClockwise(points, size);
        return area < 0.0f ? -area : area;
    }

    public static float area(float ax, float ay, float bx, float by, float cx, float cy) {
        float area = (ax - cx) * (by - cy) - (bx - cx) * (ay - cy);
        return (area < 0.0f ? -area : area) * 0.5f;
    }

    public static float area(float[] a, int p1, int p2, int p3) {
        float area = (a[p1] - a[p3]) * (a[p2 + 1] - a[p3 + 1]) - (a[p2] - a[p3]) * (a[p1 + 1] - a[p3 + 1]);
        return (area < 0.0f ? -area : area) * 0.5f;
    }

    public static float[] bisectionNorm2D(float[] v1, float[] v2) {
        float[] bisection = new float[]{v1[0] + v2[0], v1[1] + v2[1]};
        if (bisection[0] == 0.0f && bisection[1] == 0.0f) {
            bisection[0] = v1[1];
            bisection[1] = -v1[0];
        }
        return bisection;
    }

    public static float[] center(float[] points, int pointPos, int n, float[] out) {
        if (out == null) {
            out = new float[2];
        }
        int i = 0;
        while (i < n) {
            out[0] = out[0] + points[pointPos];
            out[1] = out[1] + points[pointPos + 1];
            i += 2;
            pointPos += 2;
        }
        out[0] = out[0] * 2.0f / (float)n;
        out[1] = out[1] * 2.0f / (float)n;
        return out;
    }

    public static float[] closestPointOnLine2D(float[] pP, float[] pL, float[] vL) {
        float[] vPL = GeometryUtils.diffVec(pL, pP);
        float[] vPS = GeometryUtils.diffVec(vPL, GeometryUtils.scale(vL, GeometryUtils.dotProduct(vPL, vL) / GeometryUtils.dotProduct(vL, vL)));
        return GeometryUtils.sumVec(pP, vPS);
    }

    public static float[] diffVec(float[] a, float[] b) {
        float[] diff = new float[Math.min(a.length, b.length)];
        for (int i = 0; i < diff.length; ++i) {
            diff[i] = a[i] - b[i];
        }
        return diff;
    }

    public static float[] sumVec(float[] a, float[] b) {
        float[] add = new float[Math.min(a.length, b.length)];
        for (int i = 0; i < add.length; ++i) {
            add[i] = b[i] + a[i];
        }
        return add;
    }

    public static float squaredDistance(float[] p, int a, int b) {
        return (p[a] - p[b]) * (p[a] - p[b]) + (p[a + 1] - p[b + 1]) * (p[a + 1] - p[b + 1]);
    }

    public static float squareSegmentDistance(float[] p, int a, int b, int c) {
        float x = p[b];
        float y = p[b + 1];
        float dx = p[c] - x;
        float dy = p[c + 1] - y;
        if (dx != 0.0f || dy != 0.0f) {
            float t = ((p[a] - x) * dx + (p[a + 1] - y) * dy) / (dx * dx + dy * dy);
            if (t > 1.0f) {
                x = p[c];
                y = p[c + 1];
            } else if (t > 0.0f) {
                x += dx * t;
                y += dy * t;
            }
        }
        dx = p[a] - x;
        dy = p[a + 1] - y;
        return dx * dx + dy * dy;
    }

    public static double distance(float[] p, int a, int b) {
        float dx = p[a] - p[b];
        float dy = p[a + 1] - p[b + 1];
        return Math.sqrt(dx * dx + dy * dy);
    }

    public static double distance2D(float[] a, float[] b) {
        float dx = a[0] - b[0];
        float dy = a[1] - b[1];
        return Math.sqrt(dx * dx + dy * dy);
    }

    public static float distancePointLine2D(float[] pP, float[] pL, float[] vL) {
        float[] vPL = GeometryUtils.diffVec(pL, pP);
        float[] vPS = GeometryUtils.diffVec(vPL, GeometryUtils.scale(vL, GeometryUtils.dotProduct(vPL, vL) / GeometryUtils.dotProduct(vL, vL)));
        return (float)Math.sqrt(GeometryUtils.dotProduct(vPS, vPS));
    }

    public static double dotProduct(float[] p, int a, int b, int c) {
        double vy;
        double vx;
        double bc;
        double ux = p[b] - p[a];
        double uy = p[b + 1] - p[a + 1];
        double ab = Math.sqrt(ux * ux + uy * uy);
        double d = ab * (bc = Math.sqrt((vx = (double)(p[b] - p[c])) * vx + (vy = (double)(p[b + 1] - p[c + 1])) * vy));
        if (d <= 0.0) {
            return 0.0;
        }
        double dotp = (ux * -vx + uy * -vy) / d;
        if (dotp > 1.0) {
            dotp = 1.0;
        } else if (dotp < -1.0) {
            dotp = -1.0;
        }
        return dotp;
    }

    public static float dotProduct(float[] a, float[] b) {
        float dp = 0.0f;
        for (int i = 0; i < a.length; ++i) {
            dp += a[i] * b[i];
        }
        return dp;
    }

    public static float[] intersectionLines2D(float[] pA, float[] vA, float[] pB, float[] vB) {
        float det = vB[0] * vA[1] - vB[1] * vA[0];
        if (det == 0.0f) {
            return null;
        }
        float lambA = ((pB[1] - pA[1]) * vB[0] - (pB[0] - pA[0]) * vB[1]) / det;
        float[] intersection = new float[]{pA[0] + lambA * vA[0], pA[1] + lambA * vA[1]};
        return intersection;
    }

    public static float[] intersectionLinePlane(float[] pL, float[] vL, float[] pP, float[] vP) {
        float det = GeometryUtils.dotProduct(vL, vP);
        if (det == 0.0f) {
            return null;
        }
        float phi = GeometryUtils.dotProduct(GeometryUtils.diffVec(pP, pL), vP) / det;
        return GeometryUtils.sumVec(GeometryUtils.scale(vL, phi), pL);
    }

    public static float isClockwise(float[] points, int size) {
        float area = 0.0f;
        for (int i = 0; i < size - 2; i += 2) {
            area += points[i] * points[i + 3] - points[i + 1] * points[i + 2];
        }
        return 0.5f * (area += points[size - 2] * points[1] - points[size - 1] * points[0]);
    }

    public static float isTrisClockwise(float[] pA, float[] pB, float[] pC) {
        return (pB[0] - pA[0]) * (pC[1] - pA[1]) - (pB[1] - pA[1]) * (pC[0] - pA[0]);
    }

    public static double length(float[] vec) {
        float length = 0.0f;
        for (float coord : vec) {
            length += coord * coord;
        }
        return Math.sqrt(length);
    }

    public static float[] normalize(float[] vec) {
        return GeometryUtils.scale(vec, 1.0f / (float)GeometryUtils.length(vec));
    }

    public static List<float[]> normalizedVectors2D(List<float[]> points, List<Float> outLengths) {
        ArrayList<float[]> normVectors = new ArrayList<float[]>();
        for (int i = 0; i < points.size(); ++i) {
            float[] pA = points.get(i);
            float[] pB = points.get((i + 1) % points.size());
            float[] vBA = GeometryUtils.diffVec(pB, pA);
            float length = (float)Math.sqrt(vBA[0] * vBA[0] + vBA[1] * vBA[1]);
            if (outLengths != null) {
                outLengths.add(Float.valueOf(length));
            }
            vBA[0] = vBA[0] / length;
            vBA[1] = vBA[1] / length;
            normVectors.add(vBA);
        }
        return normVectors;
    }

    public static float[] normalOfPlane(float[] pA, float[] pB, float[] pC) {
        float[] BA = GeometryUtils.diffVec(pB, pA);
        float[] BC = GeometryUtils.diffVec(pC, pA);
        float[] normal = new float[]{BA[1] * BC[2] - BA[2] * BC[1], BA[2] * BC[0] - BA[0] * BC[2], BA[0] * BC[1] - BA[1] * BC[0]};
        return normal;
    }

    public static float[] scale(float[] v, float scale) {
        float[] scaled = new float[v.length];
        for (int i = 0; i < v.length; ++i) {
            scaled[i] = v[i] * scale;
        }
        return scaled;
    }
}

