/*
 * Copyright 2019 Gustl22
 *
 * This program is free software: you can redistribute it and/or modify it under the
 * terms of the GNU Lesser General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE. See the GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License along with
 * this program. If not, see <http://www.gnu.org/licenses/>.
 */
package org.oscim.backend;

import java.util.Calendar;

public class DateTime extends DateTimeAdapter {

    @Override
    public int getHour() {
        return Calendar.getInstance().get(Calendar.HOUR_OF_DAY);
    }

    @Override
    public int getMinute() {
        return Calendar.getInstance().get(Calendar.MINUTE);
    }

    @Override
    public int getSecond() {
        return Calendar.getInstance().get(Calendar.SECOND);
    }

    @Override
    public int getDayOfYear() {
        return Calendar.getInstance().get(Calendar.DAY_OF_YEAR);
    }

    @Override
    public int getTimeZoneOffset() {
        Calendar calendar = Calendar.getInstance();
        return calendar.getTimeZone().getOffset(calendar.getTimeInMillis());
    }
}
