/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.event;

import org.oscim.event.Event;
import org.oscim.event.EventListener;
import org.oscim.utils.pool.LList;

public abstract class EventDispatcher<E extends EventListener, T> {
    protected LList<E> mListeners;

    public void bind(E listener) {
        if (LList.find(this.mListeners, listener) != null) {
            return;
        }
        this.mListeners = LList.push(this.mListeners, listener);
    }

    public void unbind(E listener) {
        this.mListeners = LList.remove(this.mListeners, listener);
    }

    public abstract void tell(E var1, Event var2, T var3);

    public void fire(Event event, T data) {
        LList l = this.mListeners;
        while (l != null) {
            this.tell((EventListener)l.data, event, data);
            l = (LList)l.next;
        }
    }

    public void clear() {
        this.mListeners = null;
    }
}

