/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.layers.marker;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.oscim.backend.CanvasAdapter;
import org.oscim.core.Box;
import org.oscim.core.Point;
import org.oscim.core.Tile;
import org.oscim.event.Gesture;
import org.oscim.event.GestureListener;
import org.oscim.event.MotionEvent;
import org.oscim.layers.marker.MarkerInterface;
import org.oscim.layers.marker.MarkerLayer;
import org.oscim.layers.marker.MarkerRendererFactory;
import org.oscim.layers.marker.MarkerSymbol;
import org.oscim.map.Map;
import org.oscim.map.ViewController;

public class ItemizedLayer
extends MarkerLayer
implements GestureListener {
    protected final List<MarkerInterface> mItemList;
    protected final Point mTmpPoint = new Point();
    protected OnItemGestureListener<MarkerInterface> mOnItemGestureListener;
    protected int mDrawnItemsLimit = Integer.MAX_VALUE;
    private final ActiveItem mActiveItemSingleTap = new ActiveItem(){

        @Override
        public boolean run(int index) {
            if (ItemizedLayer.this.mOnItemGestureListener == null) {
                return false;
            }
            return ItemizedLayer.this.onSingleTapUpHelper(index, ItemizedLayer.this.mItemList.get(index));
        }
    };
    private final ActiveItem mActiveItemLongPress = new ActiveItem(){

        @Override
        public boolean run(int index) {
            if (ItemizedLayer.this.mOnItemGestureListener == null) {
                return false;
            }
            return ItemizedLayer.this.onLongPressHelper(index, ItemizedLayer.this.mItemList.get(index));
        }
    };

    public ItemizedLayer(Map map, MarkerSymbol defaultMarker) {
        this(map, new ArrayList<MarkerInterface>(), defaultMarker, null);
    }

    public ItemizedLayer(Map map, List<MarkerInterface> list, MarkerSymbol defaultMarker, OnItemGestureListener<MarkerInterface> listener) {
        super(map, defaultMarker);
        this.mItemList = list;
        this.mOnItemGestureListener = listener;
        this.populate();
    }

    public ItemizedLayer(Map map, MarkerRendererFactory markerRendererFactory) {
        this(map, new ArrayList<MarkerInterface>(), markerRendererFactory, null);
    }

    public ItemizedLayer(Map map, List<MarkerInterface> list, MarkerRendererFactory markerRendererFactory, OnItemGestureListener<MarkerInterface> listener) {
        super(map, markerRendererFactory);
        this.mItemList = list;
        this.mOnItemGestureListener = listener;
        this.populate();
    }

    public void setOnItemGestureListener(OnItemGestureListener<MarkerInterface> listener) {
        this.mOnItemGestureListener = listener;
    }

    @Override
    public synchronized MarkerInterface createItem(int index) {
        return this.mItemList.get(index);
    }

    @Override
    public synchronized int size() {
        return Math.min(this.mItemList.size(), this.mDrawnItemsLimit);
    }

    public synchronized boolean addItem(MarkerInterface item) {
        boolean result = this.mItemList.add(item);
        this.populate();
        return result;
    }

    public synchronized void addItem(int location, MarkerInterface item) {
        this.mItemList.add(location, item);
        this.populate();
    }

    public synchronized boolean addItems(Collection<MarkerInterface> items) {
        boolean result = this.mItemList.addAll(items);
        this.populate();
        return result;
    }

    public synchronized List<MarkerInterface> getItemList() {
        return this.mItemList;
    }

    public synchronized void removeAllItems() {
        this.removeAllItems(true);
    }

    public synchronized void removeAllItems(boolean withPopulate) {
        this.mItemList.clear();
        if (withPopulate) {
            this.populate();
        }
    }

    public synchronized boolean removeItem(MarkerInterface item) {
        boolean result = this.mItemList.remove(item);
        this.populate();
        return result;
    }

    public synchronized MarkerInterface removeItem(int position) {
        MarkerInterface result = this.mItemList.remove(position);
        this.populate();
        return result;
    }

    protected boolean onSingleTapUpHelper(int index, MarkerInterface item) {
        return this.mOnItemGestureListener.onItemSingleTapUp(index, item);
    }

    protected boolean onLongPressHelper(int index, MarkerInterface item) {
        return this.mOnItemGestureListener.onItemLongPress(index, item);
    }

    protected boolean activateSelectedItems(MotionEvent event, ActiveItem task) {
        int size = this.mItemList.size();
        if (size == 0) {
            return false;
        }
        int eventX = (int)event.getX() - this.mMap.getWidth() / 2;
        int eventY = (int)event.getY() - this.mMap.getHeight() / 2;
        ViewController mapPosition = this.mMap.viewport();
        Box box = mapPosition.getBBox(null, Tile.SIZE / 2);
        box.map2mercator();
        box.scale(1000000.0);
        int nearest = -1;
        int inside = -1;
        double insideY = -1.7976931348623157E308;
        double dist = 20.0f * CanvasAdapter.getScale() * (20.0f * CanvasAdapter.getScale());
        for (int i = 0; i < size; ++i) {
            double d;
            MarkerInterface item = this.mItemList.get(i);
            if (!box.contains(item.getPoint().longitudeE6, item.getPoint().latitudeE6)) continue;
            mapPosition.toScreenPoint(item.getPoint(), this.mTmpPoint);
            float dx = (float)((double)eventX - this.mTmpPoint.x);
            float dy = (float)((double)eventY - this.mTmpPoint.y);
            MarkerSymbol it = item.getMarker();
            if (it == null) {
                it = this.mMarkerRenderer.mDefaultMarker;
            }
            if (it.isInside(dx, dy) && this.mTmpPoint.y > insideY) {
                insideY = this.mTmpPoint.y;
                inside = i;
            }
            if (inside >= 0 || (d = (double)(dx * dx + dy * dy)) > dist) continue;
            dist = d;
            nearest = i;
        }
        if (inside >= 0) {
            nearest = inside;
        }
        if (nearest >= 0 && task.run(nearest)) {
            this.mMarkerRenderer.update();
            this.mMap.render();
            return true;
        }
        return false;
    }

    @Override
    public boolean onGesture(Gesture g, MotionEvent e) {
        if (!this.isEnabled()) {
            return false;
        }
        if (g instanceof Gesture.Tap) {
            return this.activateSelectedItems(e, this.mActiveItemSingleTap);
        }
        if (g instanceof Gesture.LongPress) {
            return this.activateSelectedItems(e, this.mActiveItemLongPress);
        }
        return false;
    }

    public static interface OnItemGestureListener<T> {
        public boolean onItemSingleTapUp(int var1, T var2);

        public boolean onItemLongPress(int var1, T var2);
    }

    public static interface ActiveItem {
        public boolean run(int var1);
    }
}

