/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.layers.tile;

import org.oscim.core.MercatorProjection;
import org.oscim.core.Tile;
import org.oscim.renderer.bucket.RenderBuckets;
import org.oscim.utils.pool.Inlist;
import org.oscim.utils.quadtree.TreeNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapTile
extends Tile {
    static final Logger log = LoggerFactory.getLogger(MapTile.class);
    public static final int PROXY_CHILD00 = 1;
    public static final int PROXY_CHILD01 = 2;
    public static final int PROXY_CHILD10 = 4;
    public static final int PROXY_CHILD11 = 8;
    public static final int PROXY_PARENT = 16;
    public static final int PROXY_GRAMPA = 32;
    public static final int PROXY_HOLDER = 64;
    byte state = 1;
    public final double x;
    public final double y;
    public TileData data;
    public final TileNode node;
    public float distance;
    public boolean isVisible;
    public long fadeTime;
    int lastDraw = 0;
    private int proxy = 0;
    private int locked = 0;
    private int refs = 0;
    MapTile holder;

    public MapTile(int tileX, int tileY, int zoomLevel) {
        this(null, tileX, tileY, zoomLevel);
    }

    public MapTile(TileNode node, int tileX, int tileY, int zoomLevel) {
        super(tileX, tileY, (byte)zoomLevel);
        this.x = (double)tileX / (double)(1 << zoomLevel);
        this.y = (double)tileY / (double)(1 << zoomLevel);
        this.node = node;
    }

    public boolean state(int testState) {
        return (this.state & testState) != 0;
    }

    public int getState() {
        return this.state;
    }

    boolean isLocked() {
        return this.locked > 0 || this.refs > 0;
    }

    void lock() {
        MapTile p;
        if (this.state == 64) {
            log.debug("Locking dead tile {}", (Object)this);
            return;
        }
        if (this.locked++ > 0) {
            return;
        }
        for (int i = 0; i < 4; ++i) {
            p = (MapTile)this.node.child(i);
            if (p == null || !p.state(12)) continue;
            this.proxy |= 1 << i;
            ++p.refs;
        }
        if (this.node.isRoot()) {
            return;
        }
        p = (MapTile)this.node.parent();
        if (p != null && p.state(12)) {
            this.proxy |= 0x10;
            ++p.refs;
        }
        if (((TileNode)this.node.parent).isRoot()) {
            return;
        }
        p = (MapTile)((TileNode)this.node.parent).parent();
        if (p != null && p.state(12)) {
            this.proxy |= 0x20;
            ++p.refs;
        }
    }

    void unlock() {
        MapTile p;
        if (--this.locked > 0) {
            return;
        }
        if ((this.proxy & 0x10) != 0 && (p = (MapTile)this.node.parent()) != null) {
            --p.refs;
        }
        if ((this.proxy & 0x20) != 0 && (p = (MapTile)((TileNode)this.node.parent).parent()) != null) {
            --p.refs;
        }
        for (int i = 0; i < 4; ++i) {
            MapTile c;
            if ((this.proxy & 1 << i) == 0 || (c = (MapTile)this.node.child(i)) == null) continue;
            --c.refs;
        }
        this.proxy = 0;
        if (this.state == 64) {
            log.debug("Unlock dead tile {}", (Object)this);
            this.clear();
        }
    }

    public boolean isActive() {
        return this.state > 1;
    }

    public boolean hasProxy(int proxy) {
        return (this.proxy & proxy) != 0;
    }

    protected void clear() {
        while (this.data != null) {
            this.data.dispose();
            this.data = (TileData)this.data.next;
        }
        this.setState((byte)1);
    }

    public RenderBuckets getBuckets() {
        if (!(this.data instanceof RenderBuckets)) {
            return null;
        }
        return (RenderBuckets)this.data;
    }

    public TileData getData(Object id) {
        TileData d = this.data;
        while (d != null) {
            if (d.id == id) {
                return d;
            }
            d = (TileData)d.next;
        }
        return null;
    }

    public void addData(Object id, TileData td) {
        td.id = id;
        if (this.data != null) {
            td.next = this.data.next;
            this.data.next = td;
        } else {
            this.data = td;
        }
    }

    public TileData removeData(Object id) {
        if (this.data == null) {
            return null;
        }
        TileData prev = this.data;
        if (this.data.id == id) {
            this.data = (TileData)this.data.next;
            return prev;
        }
        TileData d = (TileData)this.data.next;
        while (d != null) {
            if (d.id == id) {
                prev.next = d.next;
                return d;
            }
            prev = d;
            d = (TileData)d.next;
        }
        return null;
    }

    public static int depthOffset(MapTile t) {
        return t.tileX % 4 + t.tileY % 4 * 4 + 1;
    }

    public float getGroundScale() {
        double lat = MercatorProjection.toLatitude(this.y);
        return (float)MercatorProjection.groundResolutionWithScale(lat, 1 << this.zoomLevel);
    }

    public MapTile getProxyChild(int id, byte state) {
        if ((this.proxy & 1 << id) == 0) {
            return null;
        }
        MapTile child = (MapTile)this.node.child(id);
        if (child == null || (child.state & state) == 0) {
            return null;
        }
        return child;
    }

    public MapTile getParent() {
        if ((this.proxy & 0x10) == 0) {
            return null;
        }
        return (MapTile)((TileNode)this.node.parent).item;
    }

    public MapTile getProxy(int proxy, byte state) {
        if ((this.proxy & proxy) == 0) {
            return null;
        }
        MapTile p = null;
        switch (proxy) {
            case 1: {
                p = (MapTile)this.node.child(0);
                break;
            }
            case 2: {
                p = (MapTile)this.node.child(1);
                break;
            }
            case 4: {
                p = (MapTile)this.node.child(2);
                break;
            }
            case 8: {
                p = (MapTile)this.node.child(3);
                break;
            }
            case 16: {
                p = (MapTile)this.node.parent();
                break;
            }
            case 32: {
                p = (MapTile)((TileNode)this.node.parent).parent();
                break;
            }
            case 64: {
                p = this.holder;
            }
        }
        if (p == null || (p.state & state) == 0) {
            return null;
        }
        return p;
    }

    public String state() {
        switch (this.state) {
            case 1: {
                return "None";
            }
            case 2: {
                return "Loading";
            }
            case 4: {
                return "Data";
            }
            case 8: {
                return "Ready";
            }
            case 16: {
                return "Cancel";
            }
            case 64: {
                return "Dead";
            }
        }
        return "";
    }

    public synchronized void setState(byte newState) {
        if (this.state == newState) {
            return;
        }
        if (this.state == 64) {
            return;
        }
        switch (newState) {
            case 1: {
                this.state = newState;
                return;
            }
            case 2: {
                if (this.state == 1) {
                    this.state = newState;
                    return;
                }
                throw new IllegalStateException("Loading <= " + this.state() + " " + this);
            }
            case 4: {
                if (this.state == 2) {
                    this.state = newState;
                    return;
                }
                throw new IllegalStateException("NewData <= " + this.state() + " " + this);
            }
            case 8: {
                if (this.state == 4) {
                    this.state = newState;
                    return;
                }
                throw new IllegalStateException("Ready <= " + this.state() + " " + this);
            }
            case 16: {
                if (this.state == 2) {
                    this.state = newState;
                    return;
                }
                throw new IllegalStateException("Cancel <= " + this.state() + " " + this);
            }
            case 64: {
                this.state = newState;
                return;
            }
        }
    }

    public static final class State {
        public static final byte NONE = 1;
        public static final byte LOADING = 2;
        public static final byte NEW_DATA = 4;
        public static final byte READY = 8;
        public static final byte CANCEL = 16;
        public static final byte DEADBEEF = 64;
    }

    public static class TileNode
    extends TreeNode<TileNode, MapTile> {
    }

    public static abstract class TileData
    extends Inlist<TileData> {
        Object id;

        protected abstract void dispose();

        @Override
        public TileData next() {
            return (TileData)this.next;
        }
    }
}

