/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.layers.tile.bitmap;

import org.oscim.backend.canvas.Bitmap;
import org.oscim.core.Tile;
import org.oscim.layers.tile.MapTile;
import org.oscim.layers.tile.TileLoader;
import org.oscim.layers.tile.bitmap.BitmapTileLayer;
import org.oscim.renderer.bucket.BitmapBucket;
import org.oscim.renderer.bucket.RenderBuckets;
import org.oscim.tiling.ITileDataSource;
import org.oscim.tiling.TileSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BitmapTileLoader
extends TileLoader {
    protected static final Logger log = LoggerFactory.getLogger(BitmapTileLoader.class);
    private final ITileDataSource mTileDataSource;
    private final BitmapTileLayer mLayer;

    public BitmapTileLoader(BitmapTileLayer tileLayer, TileSource tileSource) {
        super(tileLayer.getManager());
        this.mTileDataSource = tileSource.getDataSource();
        this.mLayer = tileLayer;
    }

    @Override
    protected boolean loadTile(MapTile tile) {
        try {
            this.mTileDataSource.query(tile, this);
        }
        catch (Exception e) {
            log.debug("{} {}", (Object)tile, (Object)e.toString());
            return false;
        }
        return true;
    }

    @Override
    public void setTileImage(Bitmap bitmap) {
        if (this.isCanceled() || !this.mTile.state(2)) {
            bitmap.recycle();
            return;
        }
        BitmapBucket l = new BitmapBucket(false);
        l.setBitmap(bitmap, Tile.SIZE, Tile.SIZE, this.mLayer.pool);
        RenderBuckets buckets = new RenderBuckets();
        buckets.set(l);
        this.mTile.data = buckets;
    }

    @Override
    public void dispose() {
        this.mTileDataSource.cancel();
    }

    @Override
    public void cancel() {
        this.mTileDataSource.cancel();
    }
}

