/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.layers.tile.buildings;

import org.oscim.layers.tile.TileLayer;
import org.oscim.layers.tile.TileManager;
import org.oscim.layers.tile.TileRenderer;
import org.oscim.layers.tile.ZoomLimiter;
import org.oscim.layers.tile.buildings.BuildingRenderer;
import org.oscim.layers.tile.buildings.S3DBTileLoader;
import org.oscim.map.Map;
import org.oscim.renderer.GLViewport;
import org.oscim.renderer.LayerRenderer;
import org.oscim.renderer.OffscreenRenderer;
import org.oscim.tiling.TileSource;

public class S3DBTileLayer
extends TileLayer {
    private static final int MAX_CACHE = 32;
    private static final int MIN_ZOOM = 16;
    private static final int MAX_ZOOM = 16;

    public S3DBTileLayer(Map map, TileSource tileSource) {
        this(map, tileSource, true, false);
    }

    public S3DBTileLayer(Map map, TileSource tileSource, boolean fxaa, boolean ssao) {
        super(map, new TileManager(map, 32));
        this.setRenderer(new S3DBTileRenderer(this.mTileManager, fxaa, ssao));
        this.mTileManager.setZoomLevel(16, 16);
        this.mTileSource = tileSource;
        this.initLoader(2);
    }

    @Override
    protected S3DBTileLoader createLoader() {
        return new S3DBTileLoader(this.getManager(), this.mTileSource);
    }

    public static class S3DBTileRenderer
    extends TileRenderer {
        LayerRenderer mRenderer;

        public S3DBTileRenderer(TileManager manager, boolean fxaa, boolean ssao) {
            this.mRenderer = new BuildingRenderer(this, new ZoomLimiter(manager, 16, 16, 16), true, false);
            if (fxaa || ssao) {
                OffscreenRenderer.Mode mode = OffscreenRenderer.Mode.FXAA;
                if (fxaa && ssao) {
                    mode = OffscreenRenderer.Mode.SSAO_FXAA;
                } else if (ssao) {
                    mode = OffscreenRenderer.Mode.SSAO;
                }
                this.mRenderer = new OffscreenRenderer(mode, this.mRenderer);
            }
        }

        @Override
        public synchronized void update(GLViewport v) {
            super.update(v);
            this.mRenderer.update(v);
            this.setReady(this.mRenderer.isReady());
        }

        @Override
        public synchronized void render(GLViewport v) {
            this.mRenderer.render(v);
        }

        @Override
        public boolean setup() {
            this.mRenderer.setup();
            return super.setup();
        }
    }
}

