/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.layers.tile.vector;

import org.oscim.core.Tag;
import org.oscim.core.TagSet;
import org.oscim.layers.tile.TileLoader;
import org.oscim.layers.tile.vector.VectorTileLayer;
import org.oscim.layers.tile.vector.VectorTileLoader;
import org.oscim.map.Map;
import org.oscim.tiling.TileSource;
import org.oscim.utils.Utils;

public class OsmTileLayer
extends VectorTileLayer {
    private static final int CACHE_LIMIT = 150;

    public OsmTileLayer(Map map) {
        this(map, map.viewport().getMinZoomLevel(), map.viewport().getMaxZoomLevel());
    }

    public OsmTileLayer(Map map, int zoomMin, int zoomMax) {
        super(map, 150);
        this.mTileManager.setZoomLevel(zoomMin, zoomMax);
    }

    public OsmTileLayer(Map map, TileSource tileSource) {
        this(map);
        this.setTileSource(tileSource);
    }

    @Override
    protected TileLoader createLoader() {
        return new OsmTileLoader(this);
    }

    private static class OsmTileLoader
    extends VectorTileLoader {
        private final TagSet mFilteredTags = new TagSet();
        private static final VectorTileLoader.TagReplacement[] mTagReplacement = new VectorTileLoader.TagReplacement[]{new VectorTileLoader.TagReplacement("name"), new VectorTileLoader.TagReplacement("addr:housenumber"), new VectorTileLoader.TagReplacement("ref"), new VectorTileLoader.TagReplacement("height"), new VectorTileLoader.TagReplacement("min_height")};

        OsmTileLoader(VectorTileLayer tileLayer) {
            super(tileLayer);
        }

        @Override
        protected TagSet filterTags(TagSet tagSet) {
            Tag[] tags = tagSet.getTags();
            this.mFilteredTags.clear();
            int n = tagSet.size();
            block0: for (int i = 0; i < n; ++i) {
                Tag t = tags[i];
                for (VectorTileLoader.TagReplacement replacement : mTagReplacement) {
                    if (!Utils.equals(t.key, replacement.key)) continue;
                    this.mFilteredTags.add(replacement.tag);
                    continue block0;
                }
                this.mFilteredTags.add(t);
            }
            return this.mFilteredTags;
        }
    }
}

